/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.locker.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;

@From(after="LOCKER_TRANSACTION t LEFT JOIN AUTH_AREA a on t.AREA_NAME = a.NAME LEFT join AUTH_DEPARTMENT d on t.DEPT_CODE = d.CODE")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig
public class LockerTransactionItem
extends BaseItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(width="0", show=false)
    private String id;
    @Column(name="t.DEV_SN")
    private String devSn;
    @Column(name="t.DEV_NAME")
    @GridColumn(label="common_dev_name", width="140")
    private String devName;
    @Column(name="t.LOCK_NO")
    @GridColumn(label="locker_lockNo", width="110")
    private Integer lockNo;
    @Column(name="t.LOCK_SIZE")
    @GridColumn(label="locker_lock_size", width="90", columnType="custom", convert="convertLockSize")
    private Short lockSize;
    @Column(name="t.PERS_PIN")
    @GridColumn(label="locker_lock_persPin", width="110", encryptMode="${pers.pin.encryptMode}", encryptProp="${pers.pin.encryptProp}")
    private String persPin;
    @Column(name="t.PERS_NAME")
    @GridColumn(label="pers_person_name", width="140", encryptMode="${pers.name.encryptMode}", encryptProp="${pers.name.encryptProp}")
    private String persName;
    @Column(name="t.PERS_LAST_NAME")
    @GridColumn(label="pers_person_lastName", width="100", showExpression="#language!='zh_CN'", encryptMode="${pers.lastName.encryptMode}", encryptProp="${pers.lastName.encryptProp}")
    private String persLastName;
    @Column(name="t.DEPT_NAME")
    @GridColumn(label="pers_department", width="140")
    private String deptName;
    @Column(name="t.VERIFY_TYPE")
    @GridColumn(label="common_verifyMode_entiy", width="110", columnType="custom", convert="convertVerifyModeName")
    private Short verifyType;
    @Column(name="t.OP_TYPE")
    @GridColumn(label="base_opLog_opType", width="110", columnType="custom", convert="convertOpType")
    private Short opType;
    @Column(name="t.OP_TIME")
    @GridColumn(label="base_opLog_opTime", width="150")
    private Date opTime;
    @Column(name="t.CAPTURE_PHOTO")
    private String capturePhoto;
    @Column(name="t.VID_LINKAGE_HANDLE")
    @GridColumn(label="common_mediaFile", minWidth="150", width="*", columnType="custom", convert="convertLockerVidLinkage", isExportExcel=false, sort="na")
    private String vidLinkageHandle;
    @Column(name="t.DEPT_CODE")
    @GridColumn(label="base_department_deptNo", isExportExcel=false)
    private String deptCode;
    @Column(name="t.AREA_NAME")
    private String areaName;
    @Column(name="t.CARD_NO")
    private String cardNo;
    @Column(name="t.TRIGGER_COND")
    private Short triggerCond;
    @Condition(value="t.OP_TIME", equalTag=">=")
    private Date startTime;
    @Condition(value="t.OP_TIME", equalTag="<=")
    private Date endTime;
    @Condition(value="a.ID IN (SELECT ua.AUTH_AREA_ID FROM AUTH_USER_AREA ua WHERE ua.AUTH_USER_ID=''{0}'')")
    private String userArea;
    @Condition(value="d.ID IN (SELECT ud.AUTH_DEPT_ID FROM AUTH_USER_DEPT ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String userDept;
    @Condition(value="(LOWER (t.PERS_NAME) LIKE LOWER (''%{0}%'') OR LOWER (t.PERS_LAST_NAME) LIKE LOWER (''%{0}%''))")
    private String likeName;
    private String devId;
    private Integer captureTime;
    protected List<Map<String, Object>> vidDevices;
    private Object vidLinkageData;
    private Object vidLinkageFilePathData;
    @Column(name="t.UNIQUE_KEY")
    private String uniqueKey;
    @Column(name="t.LOG_ID")
    private Integer logId;
    private Boolean sendWhatsapp;
    private String whatsappMobileNo;
    private Boolean sendEmail;
    private String email;
    private Boolean sendSMS;
    private String mobilePhone;
    private String attachments;

    public String getId() {
        return this.id;
    }

    public String getDevSn() {
        return this.devSn;
    }

    public String getDevName() {
        return this.devName;
    }

    public Integer getLockNo() {
        return this.lockNo;
    }

    public Short getLockSize() {
        return this.lockSize;
    }

    public String getPersPin() {
        return this.persPin;
    }

    public String getPersName() {
        return this.persName;
    }

    public String getPersLastName() {
        return this.persLastName;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public Short getVerifyType() {
        return this.verifyType;
    }

    public Short getOpType() {
        return this.opType;
    }

    public Date getOpTime() {
        return this.opTime;
    }

    public String getCapturePhoto() {
        return this.capturePhoto;
    }

    public String getVidLinkageHandle() {
        return this.vidLinkageHandle;
    }

    public String getDeptCode() {
        return this.deptCode;
    }

    public String getAreaName() {
        return this.areaName;
    }

    public String getCardNo() {
        return this.cardNo;
    }

    public Short getTriggerCond() {
        return this.triggerCond;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public String getUserArea() {
        return this.userArea;
    }

    public String getUserDept() {
        return this.userDept;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getDevId() {
        return this.devId;
    }

    public Integer getCaptureTime() {
        return this.captureTime;
    }

    public List<Map<String, Object>> getVidDevices() {
        return this.vidDevices;
    }

    public Object getVidLinkageData() {
        return this.vidLinkageData;
    }

    public Object getVidLinkageFilePathData() {
        return this.vidLinkageFilePathData;
    }

    public String getUniqueKey() {
        return this.uniqueKey;
    }

    public Integer getLogId() {
        return this.logId;
    }

    public Boolean getSendWhatsapp() {
        return this.sendWhatsapp;
    }

    public String getWhatsappMobileNo() {
        return this.whatsappMobileNo;
    }

    public Boolean getSendEmail() {
        return this.sendEmail;
    }

    public String getEmail() {
        return this.email;
    }

    public Boolean getSendSMS() {
        return this.sendSMS;
    }

    public String getMobilePhone() {
        return this.mobilePhone;
    }

    public String getAttachments() {
        return this.attachments;
    }

    public LockerTransactionItem setId(String id) {
        this.id = id;
        return this;
    }

    public LockerTransactionItem setDevSn(String devSn) {
        this.devSn = devSn;
        return this;
    }

    public LockerTransactionItem setDevName(String devName) {
        this.devName = devName;
        return this;
    }

    public LockerTransactionItem setLockNo(Integer lockNo) {
        this.lockNo = lockNo;
        return this;
    }

    public LockerTransactionItem setLockSize(Short lockSize) {
        this.lockSize = lockSize;
        return this;
    }

    public LockerTransactionItem setPersPin(String persPin) {
        this.persPin = persPin;
        return this;
    }

    public LockerTransactionItem setPersName(String persName) {
        this.persName = persName;
        return this;
    }

    public LockerTransactionItem setPersLastName(String persLastName) {
        this.persLastName = persLastName;
        return this;
    }

    public LockerTransactionItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public LockerTransactionItem setVerifyType(Short verifyType) {
        this.verifyType = verifyType;
        return this;
    }

    public LockerTransactionItem setOpType(Short opType) {
        this.opType = opType;
        return this;
    }

    public LockerTransactionItem setOpTime(Date opTime) {
        this.opTime = opTime;
        return this;
    }

    public LockerTransactionItem setCapturePhoto(String capturePhoto) {
        this.capturePhoto = capturePhoto;
        return this;
    }

    public LockerTransactionItem setVidLinkageHandle(String vidLinkageHandle) {
        this.vidLinkageHandle = vidLinkageHandle;
        return this;
    }

    public LockerTransactionItem setDeptCode(String deptCode) {
        this.deptCode = deptCode;
        return this;
    }

    public LockerTransactionItem setAreaName(String areaName) {
        this.areaName = areaName;
        return this;
    }

    public LockerTransactionItem setCardNo(String cardNo) {
        this.cardNo = cardNo;
        return this;
    }

    public LockerTransactionItem setTriggerCond(Short triggerCond) {
        this.triggerCond = triggerCond;
        return this;
    }

    public LockerTransactionItem setStartTime(Date startTime) {
        this.startTime = startTime;
        return this;
    }

    public LockerTransactionItem setEndTime(Date endTime) {
        this.endTime = endTime;
        return this;
    }

    public LockerTransactionItem setUserArea(String userArea) {
        this.userArea = userArea;
        return this;
    }

    public LockerTransactionItem setUserDept(String userDept) {
        this.userDept = userDept;
        return this;
    }

    public LockerTransactionItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public LockerTransactionItem setDevId(String devId) {
        this.devId = devId;
        return this;
    }

    public LockerTransactionItem setCaptureTime(Integer captureTime) {
        this.captureTime = captureTime;
        return this;
    }

    public LockerTransactionItem setVidDevices(List<Map<String, Object>> vidDevices) {
        this.vidDevices = vidDevices;
        return this;
    }

    public LockerTransactionItem setVidLinkageData(Object vidLinkageData) {
        this.vidLinkageData = vidLinkageData;
        return this;
    }

    public LockerTransactionItem setVidLinkageFilePathData(Object vidLinkageFilePathData) {
        this.vidLinkageFilePathData = vidLinkageFilePathData;
        return this;
    }

    public LockerTransactionItem setUniqueKey(String uniqueKey) {
        this.uniqueKey = uniqueKey;
        return this;
    }

    public LockerTransactionItem setLogId(Integer logId) {
        this.logId = logId;
        return this;
    }

    public LockerTransactionItem setSendWhatsapp(Boolean sendWhatsapp) {
        this.sendWhatsapp = sendWhatsapp;
        return this;
    }

    public LockerTransactionItem setWhatsappMobileNo(String whatsappMobileNo) {
        this.whatsappMobileNo = whatsappMobileNo;
        return this;
    }

    public LockerTransactionItem setSendEmail(Boolean sendEmail) {
        this.sendEmail = sendEmail;
        return this;
    }

    public LockerTransactionItem setEmail(String email) {
        this.email = email;
        return this;
    }

    public LockerTransactionItem setSendSMS(Boolean sendSMS) {
        this.sendSMS = sendSMS;
        return this;
    }

    public LockerTransactionItem setMobilePhone(String mobilePhone) {
        this.mobilePhone = mobilePhone;
        return this;
    }

    public LockerTransactionItem setAttachments(String attachments) {
        this.attachments = attachments;
        return this;
    }
}

