/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.locker.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;

@From(after="PERS_PERSON t LEFT join AUTH_DEPARTMENT d on t.auth_dept_id = d.id")
@OrderBy(after="t.UPDATE_TIME DESC")
@GridConfig(operate=false, idField="id")
public class LockerSelectPersonItem
extends BaseItem {
    @Column(name="t.ID", equalTag="=")
    @GridColumn(checkbox=true, width="40", sortNo=0)
    private String id;
    @Column(name="t.PIN")
    @GridColumn(label="pers_person_pin", sortNo=1, width="90")
    private String personPin;
    @Column(name="t.NAME")
    @GridColumn(label="pers_person_name", sortNo=2, width="90")
    private String personName;
    @Column(name="t.LAST_NAME")
    @GridColumn(label="pers_person_lastName", showExpression="#language!='zh_CN'", sortNo=3, width="90")
    private String personLastName;
    @Column(name="d.NAME")
    @GridColumn(label="pers_dept_entity", sortNo=6, sort="na")
    private String deptName;
    private String type;
    @Condition(value="(LOWER (t.NAME) LIKE LOWER (''%{0}%'') OR LOWER (t.LAST_NAME) LIKE LOWER (''%{0}%''))")
    private String likeName;
    private String selectId;
    @Condition(value="t.ID", equalTag="not in")
    private String notInId;
    @Condition(value="t.ID", equalTag="in")
    private String inId;
    @Condition(value="t.AUTH_DEPT_ID IN (SELECT ud.AUTH_DEPT_ID FROM AUTH_USER_DEPT ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String userId;
    private String devId;
    private String lockId;
    @Column(name="t.ENABLED_CREDENTIAL")
    private Boolean enabledCredential;

    public String getId() {
        return this.id;
    }

    public String getPersonPin() {
        return this.personPin;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getPersonLastName() {
        return this.personLastName;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public String getType() {
        return this.type;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getSelectId() {
        return this.selectId;
    }

    public String getNotInId() {
        return this.notInId;
    }

    public String getInId() {
        return this.inId;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getDevId() {
        return this.devId;
    }

    public String getLockId() {
        return this.lockId;
    }

    public Boolean getEnabledCredential() {
        return this.enabledCredential;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setPersonPin(String personPin) {
        this.personPin = personPin;
    }

    public void setPersonName(String personName) {
        this.personName = personName;
    }

    public void setPersonLastName(String personLastName) {
        this.personLastName = personLastName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setLikeName(String likeName) {
        this.likeName = likeName;
    }

    public void setSelectId(String selectId) {
        this.selectId = selectId;
    }

    public void setNotInId(String notInId) {
        this.notInId = notInId;
    }

    public void setInId(String inId) {
        this.inId = inId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setDevId(String devId) {
        this.devId = devId;
    }

    public void setLockId(String lockId) {
        this.lockId = lockId;
    }

    public void setEnabledCredential(Boolean enabledCredential) {
        this.enabledCredential = enabledCredential;
    }
}

