/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pos.utils;

import com.zkteco.zkbiosecurity.base.annotation.DateType;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.FileMagic;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class PosAllowanceImportUtil {
    private static final Logger log = LoggerFactory.getLogger(PosAllowanceImportUtil.class);

    public static <T> List<T> excelImport(InputStream inputStream, Class<T> cls) {
        Workbook workbook = PosAllowanceImportUtil.createImportWorkBook(inputStream);
        Sheet sheet = workbook.getSheetAt(0);
        Field[] fields = cls.getDeclaredFields();
        List fieldList = Arrays.stream(fields).filter(f -> f.getAnnotation(GridColumn.class) != null).collect(Collectors.toList());
        Row columnNames = sheet.getRow(1);
        ArrayList<T> list = new ArrayList<T>();
        Field field = null;
        try {
            for (Row row : sheet) {
                int rowNum = row.getRowNum();
                if (rowNum <= 1) continue;
                T t = cls.newInstance();
                for (Cell cell : row) {
                    Cell columnNameCell = columnNames.getCell(cell.getColumnIndex());
                    columnNameCell.setCellType(CellType.STRING);
                    if (StringUtils.isEmpty((Object)columnNameCell.getStringCellValue())) {
                        new ZKBusinessException("common_report_columnError");
                    }
                    if (columnNameCell == null) continue;
                    String columnName = columnNameCell.getStringCellValue();
                    field = fieldList.stream().filter(f -> columnName.equals(I18nUtil.i18nCode((String)f.getAnnotation(GridColumn.class).label(), (Object[])new Object[0]))).findFirst().orElseThrow(() -> new ZKBusinessException("common_report_columnError"));
                    field.setAccessible(true);
                    if (field.getType() == Date.class || field.getType() == Timestamp.class) {
                        DateType dateType = field.getAnnotation(DateType.class);
                        String format = PosAllowanceImportUtil.getDateFormt(dateType);
                        if (cell.getCellType() == CellType.NUMERIC) {
                            if (!(cell.getNumericCellValue() > 0.0)) continue;
                            field.set(t, org.apache.poi.ss.usermodel.DateUtil.getJavaDate((double)cell.getNumericCellValue()));
                            continue;
                        }
                        cell.setCellType(CellType.STRING);
                        if (StringUtils.isEmpty((Object)cell.getStringCellValue())) continue;
                        field.set(t, DateUtil.stringToDate((String)cell.getStringCellValue(), (String)format));
                        continue;
                    }
                    cell.setCellType(CellType.STRING);
                    if (StringUtils.isEmpty((Object)cell.getStringCellValue())) continue;
                    field.set(t, ConvertUtils.convert((String)cell.getStringCellValue(), field.getType()));
                }
                field = cls.getDeclaredField("rowNum");
                field.setAccessible(true);
                field.set(t, ConvertUtils.convert((Object)(rowNum + 1), Integer.class));
                list.add(t);
            }
        }
        catch (ZKBusinessException e) {
            log.error("import business error", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.error("import error", (Throwable)e);
            throw new ZKBusinessException("common_op_failed");
        }
        return list;
    }

    public static Workbook createImportWorkBook(InputStream inputStream) {
        Workbook workbook = null;
        try {
            workbook = PosAllowanceImportUtil.getImportWorkBook(inputStream);
        }
        catch (Exception ex) {
            throw new ZKBusinessException("Open the EXCEL file flow failure!", (Throwable)ex);
        }
        return workbook;
    }

    public static Workbook getImportWorkBook(InputStream inputStream) throws IOException {
        HSSFWorkbook workbook = null;
        if (!inputStream.markSupported()) {
            inputStream = new PushbackInputStream(inputStream, 8);
        }
        if (FileMagic.valueOf((InputStream)inputStream) == FileMagic.OLE2) {
            workbook = new HSSFWorkbook(inputStream);
        } else if (FileMagic.valueOf((InputStream)inputStream) == FileMagic.OOXML) {
            workbook = new XSSFWorkbook(inputStream);
        }
        return workbook;
    }

    public static String getDateFormt(DateType dateType) {
        String format = "yyyy-MM-dd HH:mm:ss";
        if (dateType != null) {
            switch (dateType.type()) {
                case "date": {
                    format = "yyyy-MM-dd";
                    break;
                }
                case "time": {
                    format = "HH:mm:ss";
                    break;
                }
                case "timestamp": {
                    format = "yyyy-MM-dd HH:mm:ss";
                }
            }
        }
        return format;
    }
}

