/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pos.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.pos.remote.PosTransactionRemote;
import com.zkteco.zkbiosecurity.pos.service.PosSystemParamService;
import com.zkteco.zkbiosecurity.pos.service.PosTransactionService;
import com.zkteco.zkbiosecurity.pos.vo.PosTransactionItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PosTransactionController
extends ExportController
implements PosTransactionRemote {
    @Autowired
    private PosTransactionService posTransactionService;
    @Autowired
    private PosSystemParamService posSystemParamService;

    @RequiresPermissions(value={"pos:transaction"})
    public ModelAndView index() {
        HashMap<String, String> param = new HashMap<String, String>();
        Integer cardModel = this.posSystemParamService.getDoubleCash();
        param.put("cardModel", cardModel.toString());
        return new ModelAndView("pos/transaction/posTransaction", param);
    }

    @RequiresPermissions(value={"pos:transaction:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.posTransactionService.getItemById(id));
        }
        return new ModelAndView("pos/transaction/editPosTransaction");
    }

    @RequiresPermissions(value={"pos:transaction:edit"})
    @LogRequest(module="pos_module", object="pos_transaction", opType="common_op_new", requestParams={"personPin"}, opContent="pos_card_personNum")
    public ZKResultMsg save(PosTransactionItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.posTransactionService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"pos:transaction:refresh"})
    public DxGrid list(PosTransactionItem codition) {
        Pager pager = this.posTransactionService.loadPagerByAuthFilter(codition, this.getPageNo(), this.getPageSize(), this.request.getSession().getId(), this.getLimitCount());
        return GridUtil.convert((Pager)pager, codition.getClass(), (boolean)this.getPageList());
    }

    @RequiresPermissions(value={"pos:transaction:del"})
    @LogRequest(module="pos_module", object="pos_transaction", opType="common_op_del", requestParams={"ids"}, opContent="pos_common_id")
    public ZKResultMsg delete(String ids) {
        this.posTransactionService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"pos:transaction:errorRecovery"})
    public ModelAndView errorRecovery(String ids) {
        HashMap<String, String> param = new HashMap<String, String>();
        Integer cardModel = this.posSystemParamService.getDoubleCash();
        String consumeOrder = this.posSystemParamService.getValByName("pos.consumeOrder");
        param.put("cardModel", cardModel.toString());
        param.put("consumeOrder", consumeOrder);
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            this.request.setAttribute("item", (Object)this.posTransactionService.getItemById(ids));
        }
        return new ModelAndView("pos/transaction/errorRecovery", param);
    }

    @RequiresPermissions(value={"pos:transaction:errorRecovery"})
    public ZKResultMsg checkErrorRecovery() {
        String id = this.request.getParameter("ids");
        if ("-1".equals(id) || this.posTransactionService.checkErrorRecovery(id) == 1) {
            return new ZKResultMsg("fail", "pos_error_message_errorRecovery");
        }
        if (this.posTransactionService.checkErrorRecovery(id) == 2) {
            return new ZKResultMsg("fail", "pos_error_message_repeatRecovery");
        }
        return new ZKResultMsg();
    }

    @RequiresPermissions(value={"pos:transaction:errorRecovery"})
    public ZKResultMsg errorRecoveryData(String id) {
        String sysCardNo = this.request.getParameter("SysID");
        String handSysCardNo = this.request.getParameter("cardSysNo");
        String cardSerial = this.request.getParameter("CardMark");
        Double cardBlance = Double.parseDouble(this.request.getParameter("Banlance"));
        Double finalBlance = cardBlance / 100.0;
        String subBalance = this.request.getParameter("PosMoney_Sub");
        String money = this.request.getParameter("money");
        String cashMoney = StringUtils.isNotBlank((CharSequence)this.request.getParameter("cashMoney")) ? this.request.getParameter("cashMoney") : "0";
        String allowMoney = StringUtils.isNotBlank((CharSequence)this.request.getParameter("allowMoney")) ? this.request.getParameter("allowMoney") : "0";
        Double oldBalance = Double.parseDouble(StringUtils.isNotBlank((CharSequence)this.request.getParameter("oldBalance")) ? this.request.getParameter("oldBalance") : "0") / 100.0;
        Double oldSubBalance = Double.parseDouble(StringUtils.isNotBlank((CharSequence)this.request.getParameter("oldSubBalance")) ? this.request.getParameter("oldSubBalance") : "0") / 100.0;
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("sysCardNo", sysCardNo);
        data.put("cardSerial", cardSerial);
        data.put("finalBlance", finalBlance);
        data.put("subBalance", subBalance);
        data.put("money", money);
        data.put("cashMoney", cashMoney);
        data.put("allowMoney", allowMoney);
        data.put("handSysCardNo", handSysCardNo);
        data.put("oldBalance", oldBalance);
        data.put("oldSubBalance", oldSubBalance);
        ZKResultMsg zKResultMsg = this.posTransactionService.errorRecoveryData(id, data);
        return I18nUtil.i18nMsg((ZKResultMsg)zKResultMsg);
    }

    @RequiresPermissions(value={"pos:transaction:export"})
    public void export(HttpServletRequest request, HttpServletResponse response) throws IllegalAccessException, InvocationTargetException {
        PosTransactionItem posTransactionItem = new PosTransactionItem();
        this.setConditionValue((BaseItem)posTransactionItem);
        List itemList = this.posTransactionService.loadListByAuthFilter(posTransactionItem, this.getBeginIndex(), this.getEndIndex(), request.getSession().getId());
        if (itemList.size() > 0) {
            PosTransactionItem sumItem = new PosTransactionItem();
            Double sumMoney = 0.0;
            Double sumSubMoney = 0.0;
            for (PosTransactionItem item : itemList) {
                sumMoney = new BigDecimal(item.getMoney().toString()).add(new BigDecimal(sumMoney.toString())).doubleValue();
                sumSubMoney = new BigDecimal(item.getSubMoney().toString()).add(new BigDecimal(sumSubMoney.toString())).doubleValue();
            }
            sumItem.setId("-1");
            sumItem.setPersonPin("pos_countTable_total");
            sumItem.setMoney(sumMoney);
            sumItem.setSubMoney(sumSubMoney);
            itemList.add(sumItem);
        }
        this.excelExport(itemList, PosTransactionItem.class);
    }

    public ZKResultMsg importTxt(MultipartFile upload) throws IOException {
        ZKResultMsg result = this.posTransactionService.txtImport(upload.getInputStream());
        return I18nUtil.i18nMsg((ZKResultMsg)result);
    }
}

