/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pos.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.StrUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.pos.remote.PosTransactionCardRecordRemote;
import com.zkteco.zkbiosecurity.pos.service.PosTransactionCardService;
import com.zkteco.zkbiosecurity.pos.vo.PosTransactionCardItem;
import com.zkteco.zkbiosecurity.pos.vo.PosTransactionRecordBackCardItem;
import com.zkteco.zkbiosecurity.pos.vo.PosTransactionRecordCardBlanceItem;
import com.zkteco.zkbiosecurity.pos.vo.PosTransactionRecordCardCostItem;
import com.zkteco.zkbiosecurity.pos.vo.PosTransactionRecordCardNoCardBackCardItem;
import com.zkteco.zkbiosecurity.pos.vo.PosTransactionRecordCardRefundItem;
import com.zkteco.zkbiosecurity.pos.vo.PosTransactionRecordCardSubsidyItem;
import com.zkteco.zkbiosecurity.pos.vo.PosTransactionRecordLoseUniteCardItem;
import com.zkteco.zkbiosecurity.pos.vo.PosTransactionRecordRechargeformItem;
import com.zkteco.zkbiosecurity.pos.vo.PosTransactionRecordSendTableItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PosTransactionCardRecordController
extends ExportController
implements PosTransactionCardRecordRemote {
    @Autowired
    private PosTransactionCardService posTransactionCardService;

    @RequiresPermissions(value={"pos:sendTable", "pos:rechargeForm", "pos:cardRefund", "pos:cardSubsidy", "pos:backCard", "pos:cardCost", "pos:cardBlance", "pos:cardNoCardBackCard", "pos:loseUniteCard"})
    public ModelAndView index() {
        String requestType = this.request.getParameter("requestType");
        return new ModelAndView("pos/transactionCardRecord/pos" + StrUtil.firstUpperCase((String)requestType));
    }

    public DxGrid list(PosTransactionCardItem codition) {
        Pager pager = this.posTransactionCardService.loadPagerByAuthFilter(codition, this.getPageNo(), this.getPageSize(), this.request.getSession().getId(), this.getLimitCount());
        return GridUtil.convert((Pager)pager, codition.getClass(), (boolean)this.getPageList());
    }

    public void export(HttpServletRequest request, HttpServletResponse response) throws IllegalAccessException, InvocationTargetException {
        PosTransactionCardItem posTransactionCardItem = new PosTransactionCardItem();
        this.setConditionValue((BaseItem)posTransactionCardItem);
        List itemList = this.posTransactionCardService.loadListByAuthFilter(posTransactionCardItem, this.getBeginIndex(), this.getEndIndex(), request.getSession().getId());
        this.excelExport(itemList, PosTransactionCardItem.class);
    }

    @RequiresPermissions(value={"pos:sendTable:export"})
    public void exportSendTable(HttpServletRequest request, HttpServletResponse response) throws IllegalAccessException, InvocationTargetException {
        PosTransactionRecordSendTableItem posTransactionRecordSendTableItem = new PosTransactionRecordSendTableItem();
        this.setConditionValue((BaseItem)posTransactionRecordSendTableItem);
        List itemList = this.posTransactionCardService.getSendTableItemData(posTransactionRecordSendTableItem, this.getBeginIndex(), this.getEndIndex(), request.getSession().getId());
        this.excelExport(itemList, PosTransactionRecordSendTableItem.class);
    }

    @RequiresPermissions(value={"pos:sendTable:refresh"})
    public DxGrid getSendTableItemList(PosTransactionRecordSendTableItem condition) {
        Pager pager = this.posTransactionCardService.loadPagerByAuthFilter(condition, this.getPageNo(), this.getPageSize(), this.request.getSession().getId(), this.getLimitCount());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"pos:rechargeForm:refresh"})
    public DxGrid getRechargeformItemList(PosTransactionRecordRechargeformItem condition) {
        Pager pager = this.posTransactionCardService.loadPagerByAuthFilter(condition, this.getPageNo(), this.getPageSize(), this.request.getSession().getId(), this.getLimitCount());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"pos:rechargeForm:export"})
    public void exportRechargeform(HttpServletRequest request, HttpServletResponse response) throws InvocationTargetException, IllegalAccessException {
        PosTransactionRecordRechargeformItem posTransactionRecordRechargeformItem = new PosTransactionRecordRechargeformItem();
        this.setConditionValue((BaseItem)posTransactionRecordRechargeformItem);
        List itemList = this.posTransactionCardService.getRechargeformItemData(posTransactionRecordRechargeformItem, this.getBeginIndex(), this.getEndIndex(), request.getSession().getId());
        this.excelExport(itemList, PosTransactionRecordRechargeformItem.class);
    }

    @RequiresPermissions(value={"pos:cardRefund:refresh"})
    public DxGrid getCardRefundItemList(PosTransactionRecordCardRefundItem condition) {
        Pager pager = this.posTransactionCardService.loadPagerByAuthFilter(condition, this.getPageNo(), this.getPageSize(), this.request.getSession().getId(), this.getLimitCount());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"pos:cardRefund:export"})
    public void exportCardRefund(HttpServletRequest request, HttpServletResponse response) throws InvocationTargetException, IllegalAccessException {
        PosTransactionRecordCardRefundItem posTransactionRecordCardRefundItem = new PosTransactionRecordCardRefundItem();
        this.setConditionValue((BaseItem)posTransactionRecordCardRefundItem);
        List itemList = this.posTransactionCardService.getCardRefundItemData(posTransactionRecordCardRefundItem, this.getBeginIndex(), this.getEndIndex(), request.getSession().getId());
        this.excelExport(itemList, PosTransactionRecordCardRefundItem.class);
    }

    @RequiresPermissions(value={"pos:cardSubsidy:refresh"})
    public DxGrid getCardSubsidyList(PosTransactionRecordCardSubsidyItem condition) {
        Pager pager = this.posTransactionCardService.loadPagerByAuthFilter(condition, this.getPageNo(), this.getPageSize(), this.request.getSession().getId(), this.getLimitCount());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"pos:cardSubsidy:export"})
    public void exportCardSubsidy(HttpServletRequest request, HttpServletResponse response) throws InvocationTargetException, IllegalAccessException {
        PosTransactionRecordCardSubsidyItem posTransactionRecordCardSubsidyItem = new PosTransactionRecordCardSubsidyItem();
        this.setConditionValue((BaseItem)posTransactionRecordCardSubsidyItem);
        List itemList = this.posTransactionCardService.getCardSubsidyItemData(posTransactionRecordCardSubsidyItem, this.getBeginIndex(), this.getEndIndex(), request.getSession().getId());
        this.excelExport(itemList, PosTransactionRecordCardSubsidyItem.class);
    }

    @RequiresPermissions(value={"pos:backCard:refresh"})
    public DxGrid getBackCardItemList(PosTransactionRecordBackCardItem condition) {
        Pager pager = this.posTransactionCardService.loadPagerByAuthFilter(condition, this.getPageNo(), this.getPageSize(), this.request.getSession().getId(), this.getLimitCount());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"pos:backCard:export"})
    public void exportBackCard(HttpServletRequest request, HttpServletResponse response) throws InvocationTargetException, IllegalAccessException {
        PosTransactionRecordBackCardItem posTransactionRecordBackCardItem = new PosTransactionRecordBackCardItem();
        this.setConditionValue((BaseItem)posTransactionRecordBackCardItem);
        List itemList = this.posTransactionCardService.getBackCardItemData(posTransactionRecordBackCardItem, this.getBeginIndex(), this.getEndIndex(), request.getSession().getId());
        this.excelExport(itemList, PosTransactionRecordBackCardItem.class);
    }

    @RequiresPermissions(value={"pos:cardCost:refresh"})
    public DxGrid getCardCostItemList(PosTransactionRecordCardCostItem condition) {
        Pager pager = this.posTransactionCardService.loadPagerByAuthFilter(condition, this.getPageNo(), this.getPageSize(), this.request.getSession().getId(), this.getLimitCount());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"pos:cardCost:export"})
    public void exportCardCost(HttpServletRequest request, HttpServletResponse response) throws InvocationTargetException, IllegalAccessException {
        PosTransactionRecordCardCostItem posTransactionRecordCardCostItem = new PosTransactionRecordCardCostItem();
        this.setConditionValue((BaseItem)posTransactionRecordCardCostItem);
        List itemList = this.posTransactionCardService.getCardCostItemData(posTransactionRecordCardCostItem, this.getBeginIndex(), this.getEndIndex(), request.getSession().getId());
        this.excelExport(itemList, PosTransactionRecordCardCostItem.class);
    }

    @RequiresPermissions(value={"pos:cardBlance:refresh"})
    public DxGrid getCardBlanceItemList(PosTransactionRecordCardBlanceItem condition) {
        Pager pager = this.posTransactionCardService.loadPagerByAuthFilter(condition, this.getPageNo(), this.getPageSize(), this.request.getSession().getId(), this.getLimitCount());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"pos:cardBlance:export"})
    public void exportCardBlance(HttpServletRequest request, HttpServletResponse response) throws InvocationTargetException, IllegalAccessException {
        PosTransactionRecordCardBlanceItem posTransactionRecordCardBlanceItem = new PosTransactionRecordCardBlanceItem();
        this.setConditionValue((BaseItem)posTransactionRecordCardBlanceItem);
        List itemList = this.posTransactionCardService.getCardBlanceItemData(posTransactionRecordCardBlanceItem, this.getBeginIndex(), this.getEndIndex(), request.getSession().getId());
        this.excelExport(itemList, PosTransactionRecordCardBlanceItem.class);
    }

    @RequiresPermissions(value={"pos:cardNoCardBackCard:refresh"})
    public DxGrid getCardNoCardBackList(PosTransactionRecordCardNoCardBackCardItem condition) {
        Pager pager = this.posTransactionCardService.loadPagerByAuthFilter(condition, this.getPageNo(), this.getPageSize(), this.request.getSession().getId(), this.getLimitCount());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"pos:cardNoCardBackCard:export"})
    public void exportCardNoCardBack(HttpServletRequest request, HttpServletResponse response) throws InvocationTargetException, IllegalAccessException {
        PosTransactionRecordCardNoCardBackCardItem posTransactionRecordCardNoCardBackCardItem = new PosTransactionRecordCardNoCardBackCardItem();
        this.setConditionValue((BaseItem)posTransactionRecordCardNoCardBackCardItem);
        List itemList = this.posTransactionCardService.getCardNoCardBackItemData(posTransactionRecordCardNoCardBackCardItem, this.getBeginIndex(), this.getEndIndex(), request.getSession().getId());
        this.excelExport(itemList, PosTransactionRecordCardNoCardBackCardItem.class);
    }

    @RequiresPermissions(value={"pos:loseUniteCard:refresh"})
    public DxGrid getLoseUniteCardList(PosTransactionRecordLoseUniteCardItem condition) {
        Pager pager = this.posTransactionCardService.loadPagerByAuthFilter(condition, this.getPageNo(), this.getPageSize(), this.request.getSession().getId(), this.getLimitCount());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"pos:loseUniteCard:export"})
    public void exportLoseUniteCard(HttpServletRequest request, HttpServletResponse response) throws InvocationTargetException, IllegalAccessException {
        PosTransactionRecordLoseUniteCardItem posTransactionRecordLoseUniteCardItem = new PosTransactionRecordLoseUniteCardItem();
        this.setConditionValue((BaseItem)posTransactionRecordLoseUniteCardItem);
        List itemList = this.posTransactionCardService.getLoseUniteCardItemData(posTransactionRecordLoseUniteCardItem, this.getBeginIndex(), this.getEndIndex(), request.getSession().getId());
        this.excelExport(itemList, PosTransactionRecordLoseUniteCardItem.class);
    }
}

