/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pos.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.pos.remote.PosTransactionCardRemote;
import com.zkteco.zkbiosecurity.pos.service.PosSystemParamService;
import com.zkteco.zkbiosecurity.pos.service.PosTransactionCardService;
import com.zkteco.zkbiosecurity.pos.vo.PosTransactionCardItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PosTransactionCardController
extends ExportController
implements PosTransactionCardRemote {
    @Autowired
    private PosTransactionCardService posTransactionCardService;
    @Autowired
    private PosSystemParamService posSystemParamService;

    @RequiresPermissions(value={"pos:transactionCard"})
    public ModelAndView index() {
        HashMap<String, String> param = new HashMap<String, String>();
        Integer cardModel = this.posSystemParamService.getDoubleCash();
        param.put("cardModel", cardModel.toString());
        return new ModelAndView("pos/transactionCard/posTransactionCard", param);
    }

    @RequiresPermissions(value={"pos:transactionCard:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.posTransactionCardService.getItemById(id));
        }
        return new ModelAndView("pos/transactionCard/editPosTransactionCard");
    }

    @RequiresPermissions(value={"pos:transactionCard:edit"})
    @LogRequest(module="pos_module", object="pos_transactionCard", opType="common_op_new", requestParams={"personPin"}, opContent="pos_card_personNum")
    public ZKResultMsg save(PosTransactionCardItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.posTransactionCardService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"pos:transactionCard:refresh"})
    public DxGrid list(PosTransactionCardItem codition) {
        Pager pager = this.posTransactionCardService.loadPagerByAuthFilter(codition, this.getPageNo(), this.getPageSize(), this.request.getSession().getId(), this.getLimitCount());
        return GridUtil.convert((Pager)pager, codition.getClass(), (boolean)this.getPageList());
    }

    @RequiresPermissions(value={"pos:transactionCard:del"})
    @LogRequest(module="pos_module", object="pos_transactionCard", opType="common_op_del", requestParams={"ids"}, opContent="pos_common_id")
    public ZKResultMsg delete(String ids) {
        this.posTransactionCardService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"pos:transactionCard:export"})
    public void export(HttpServletRequest request, HttpServletResponse response) throws IllegalAccessException, InvocationTargetException {
        String queryCondition = request.getParameter("queryConditions");
        String[] conditionAry = queryCondition.replaceAll("%20", " ").split("&");
        PosTransactionCardItem posTransactionCardItem = new PosTransactionCardItem();
        this.setConditionValue((BaseItem)posTransactionCardItem);
        for (String condition : conditionAry) {
            Date date;
            if (StringUtils.isBlank((CharSequence)condition)) continue;
            String[] strAry = condition.split("=");
            if ("checkTime".equals(strAry[0])) {
                date = DateUtil.stringToDate((String)strAry[1], (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD_HH_MM_SS);
                posTransactionCardItem.setCheckTime(date);
                continue;
            }
            if (!"conveyTime".equals(strAry[0])) continue;
            date = DateUtil.stringToDate((String)strAry[1], (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD_HH_MM_SS);
            posTransactionCardItem.setConveyTime(date);
        }
        List intemList = this.posTransactionCardService.loadListByAuthFilter(posTransactionCardItem, this.getBeginIndex(), this.getEndIndex(), request.getSession().getId());
        if (intemList.size() > 1) {
            intemList.remove(intemList.size() - 1);
        }
        this.excelExport(intemList, PosTransactionCardItem.class);
    }
}

