/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pos.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.pos.remote.PosTransactionBakRemote;
import com.zkteco.zkbiosecurity.pos.service.PosSystemParamService;
import com.zkteco.zkbiosecurity.pos.service.PosTransactionBakService;
import com.zkteco.zkbiosecurity.pos.vo.PosTransactionBakItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PosTransactionBakController
extends ExportController
implements PosTransactionBakRemote {
    @Autowired
    private PosTransactionBakService posTransactionBakService;
    @Autowired
    private PosSystemParamService posSystemParamService;

    @RequiresPermissions(value={"pos:transactionBak"})
    public ModelAndView index() {
        HashMap<String, String> param = new HashMap<String, String>();
        Integer cardModel = this.posSystemParamService.getDoubleCash();
        param.put("cardModel", cardModel.toString());
        return new ModelAndView("pos/transactionBak/posTransactionBak", param);
    }

    @RequiresPermissions(value={"pos:transactionBak:refresh"})
    public DxGrid list(PosTransactionBakItem codition) {
        Pager pager = this.posTransactionBakService.loadPagerByAuthFilter(codition, this.getPageNo(), this.getPageSize(), this.request.getSession().getId());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"pos:transaction:export"})
    public void export(HttpServletRequest request, HttpServletResponse response) {
        PosTransactionBakItem posTransactionBakItem = new PosTransactionBakItem();
        this.setConditionValue((BaseItem)posTransactionBakItem);
        List itemList = this.posTransactionBakService.loadListByAuthFilter(posTransactionBakItem, this.getBeginIndex(), this.getEndIndex(), request.getSession().getId());
        this.excelExport(itemList, PosTransactionBakItem.class);
    }

    @RequiresPermissions(value={"pos:transactionBak:correct"})
    public ZKResultMsg correct(String ids) {
        return this.posTransactionBakService.correct(ids);
    }
}

