/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pos.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.pos.remote.PosModifiedDataRemote;
import com.zkteco.zkbiosecurity.pos.service.PosCardKindService;
import com.zkteco.zkbiosecurity.pos.service.PosSystemParamService;
import com.zkteco.zkbiosecurity.pos.vo.PosCardKindItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PosModifiedDataController
extends BaseController
implements PosModifiedDataRemote {
    @Autowired
    private PosCardKindService posCardKindService;
    @Autowired
    private PosSystemParamService posSystemParamService;

    @RequiresPermissions(value={"pos:modifiedData"})
    public ModelAndView index() {
        return new ModelAndView("pos/modifiedData/posModifiedData");
    }

    @RequiresPermissions(value={"pos:modifiedData:edit"})
    public ModelAndView edit(String id) {
        HashMap<String, String> param = new HashMap<String, String>();
        String cardKindId = ((PosCardKindItem)this.posCardKindService.getByCondition(new PosCardKindItem()).get(0)).getId();
        Integer cardModel = this.posSystemParamService.getDoubleCash();
        param.put("posCardKindId", cardKindId);
        param.put("cardModel", cardModel.toString());
        return new ModelAndView("pos/modifiedData/editPosModifiedData", param);
    }

    @RequiresPermissions(value={"pos:modifiedData:del"})
    @LogRequest(module="pos_module", object="pos_op_modifiedData", opType="common_op_del", requestParams={"ids"}, opContent="pos_common_id")
    public ZKResultMsg delete(String ids) {
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }
}

