/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pos.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.ProcessBean;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.pos.remote.PosDeviceRemote;
import com.zkteco.zkbiosecurity.pos.service.PosDeviceService;
import com.zkteco.zkbiosecurity.pos.service.PosDiningHallService;
import com.zkteco.zkbiosecurity.pos.service.PosSystemParamService;
import com.zkteco.zkbiosecurity.pos.vo.PosDeviceItem;
import com.zkteco.zkbiosecurity.pos.vo.PosDiningHallItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PosDeviceController
extends BaseController
implements PosDeviceRemote {
    private static final Logger log = LoggerFactory.getLogger(PosDeviceController.class);
    @Autowired
    private PosDeviceService posDeviceService;
    @Autowired
    private ProgressCache progressCache;
    @Autowired
    private PosDiningHallService posDiningHallService;
    @Autowired
    private PosSystemParamService posSystemParamService;
    @Value(value="${adms.push.port:8088}")
    private int hostPort;

    @RequiresPermissions(value={"pos:device"})
    public ModelAndView index() {
        return new ModelAndView("pos/device/posDevice");
    }

    @RequiresPermissions(value={"pos:device:edit"})
    public ModelAndView edit(String id) {
        HashMap<String, String> param = new HashMap<String, String>();
        String cardModel = this.posSystemParamService.getValByName("pos.cardModel");
        String diningHallId = ((PosDiningHallItem)this.posDiningHallService.getByCondition(new PosDiningHallItem()).get(0)).getId();
        param.put("diningHallId", diningHallId);
        param.put("cardModel", cardModel);
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("doubleCashModel", (Object)this.posDeviceService.getDoubleCash());
            this.request.setAttribute("item", (Object)this.posDeviceService.getItemById(id));
        }
        return new ModelAndView("pos/device/editPosDevice", param);
    }

    public ModelAndView devAdd() {
        String ipAddress = this.request.getParameter("ipAddress");
        String devSn = this.request.getParameter("devSn");
        String devType = this.request.getParameter("devType");
        this.request.setAttribute("ipAddress", (Object)ipAddress);
        this.request.setAttribute("sn", (Object)devSn);
        this.request.setAttribute("devType", (Object)devType);
        PosDeviceItem posDeviceItem = null;
        posDeviceItem = new PosDeviceItem();
        posDeviceItem.setDevAlias(devSn);
        posDeviceItem.setSn(devSn);
        posDeviceItem.setIpAddress(ipAddress);
        String cardModel = this.posSystemParamService.getValByName("pos.cardModel");
        this.request.setAttribute("item", (Object)posDeviceItem);
        this.request.setAttribute("cardModel", (Object)cardModel);
        this.request.setAttribute("hallDefaultValue", (Object)this.posDeviceService.getDiningHallDefaultValue());
        return new ModelAndView("pos/device/addPosDevice");
    }

    @RequiresPermissions(value={"pos:device:edit"})
    public ZKResultMsg auth(PosDeviceItem item) {
        ZKResultMsg res = new ZKResultMsg();
        res = this.posDeviceService.authDevice(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"pos:device:edit"})
    @LogRequest(module="pos_module", object="common_leftMenu_device", opType="common_op_edit", requestParams={"devAlias"}, opContent="common_dev_name")
    public ZKResultMsg save(PosDeviceItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.posDeviceService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"pos:device:refresh"})
    public DxGrid list(PosDeviceItem codition) {
        Pager pager = this.posDeviceService.loadPagerByAuthFilter(this.request.getSession().getId(), codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"pos:device:del"})
    @LogRequest(module="pos_module", object="common_leftMenu_device", opType="common_op_del", requestParams={"devAlias"}, opContent="common_dev_name")
    public ZKResultMsg delete(String ids) {
        this.posDeviceService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"pos:device:clearCardData"})
    public ModelAndView clearCardData(String ids) {
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            List list = this.posDeviceService.getItemByIds(ids);
            StringBuffer devName = new StringBuffer("");
            PosDeviceItem dev = null;
            StringBuffer retIds = new StringBuffer();
            HashMap<String, StringBuffer> devNameMap = new HashMap<String, StringBuffer>();
            int len = list.size();
            for (int i = 0; i < len; ++i) {
                dev = (PosDeviceItem)list.get(i);
                retIds.append(dev.getId()).append(",");
                StringBuffer devNameBuf = new StringBuffer(dev.getUseType() + "-" + dev.getDevAlias() + ":" + dev.getSn() + "&" + dev.getId());
                devNameMap.put(dev.getSn(), devNameBuf);
            }
            for (StringBuffer nameBuf : devNameMap.values()) {
                devName.append(nameBuf + ";");
            }
            this.request.setAttribute("devIds", retIds.length() > 0 ? retIds.substring(0, retIds.length() - 1) : null);
            this.request.setAttribute("devicesName", devName.length() > 0 ? devName.substring(0, devName.length() - 1) : null);
        }
        return new ModelAndView("pos/device/clearCardData");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermissions(value={"pos:device:clearCardData"})
    @LogRequest(module="pos_module", object="common_leftMenu_device", opType="pos_op_clearCardData", requestParams={"devAlias"}, opContent="common_dev_name")
    public ZKResultMsg requestData(String devIds, String optBoxValue) {
        try {
            String[] optBox = optBoxValue.split(",");
            this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_processing", (Object[])new Object[0]) + "...<br/>");
            List devList = this.posDeviceService.getItemByIds(devIds);
            if (devList.size() > 0) {
                PosDeviceItem dev = (PosDeviceItem)devList.get(0);
                this.posDeviceService.clearPosData(dev, optBox);
                for (int i = 1; i <= 100; i += 34) {
                    this.progressCache.setProcess(new ProcessBean(i, i, dev.getDevAlias() + ":" + I18nUtil.i18nCode((String)"pos_dev_clearPosDataSuccess", (Object[])new Object[0]) + i + "%<br/>"));
                    Thread.sleep(500L);
                }
            }
        }
        catch (Exception e) {
            log.error("exception", (Throwable)e);
        }
        finally {
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]));
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"pos:device:clearConsumerSettings"})
    @LogRequest(module="pos_module", object="common_leftMenu_device", opType="pos_op_clearConsumerSettings", requestParams={"devAlias"}, opContent="common_dev_name")
    public ZKResultMsg clearConsumerSettings(String ids) {
        ZKResultMsg zKResultMsg = this.posDeviceService.clearConsumerSettings(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)zKResultMsg);
    }

    @RequiresPermissions(value={"pos:device:deleteCmd"})
    @LogRequest(module="pos_module", object="common_leftMenu_device", opType="pos_op_deleteCmd", requestParams={"devAlias"}, opContent="common_dev_name")
    public ZKResultMsg deleteCmd(String ids) {
        ZKResultMsg ret = this.posDeviceService.deleteCmd(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)ret);
    }

    @RequiresPermissions(value={"pos:device:collectDataOnline"})
    public ModelAndView collectDataOnline(String ids) {
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            List list = this.posDeviceService.getItemByIds(ids);
            StringBuffer devName = new StringBuffer("");
            PosDeviceItem dev = null;
            StringBuffer retIds = new StringBuffer();
            HashMap<String, StringBuffer> devNameMap = new HashMap<String, StringBuffer>();
            int len = list.size();
            for (int i = 0; i < len; ++i) {
                dev = (PosDeviceItem)list.get(i);
                retIds.append(dev.getId()).append(",");
                StringBuffer devNameBuf = new StringBuffer(dev.getUseType() + "-" + dev.getDevAlias() + ":" + dev.getSn() + "&" + dev.getId());
                devNameMap.put(dev.getSn(), devNameBuf);
            }
            for (StringBuffer nameBuf : devNameMap.values()) {
                devName.append(nameBuf + ";");
            }
            this.request.setAttribute("devIds", retIds.length() > 0 ? retIds.substring(0, retIds.length() - 1) : null);
            this.request.setAttribute("devicesName", devName.length() > 0 ? devName.substring(0, devName.length() - 1) : null);
        }
        return new ModelAndView("pos/device/collectDataOnline");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermissions(value={"pos:device:collectDataOnline"})
    @LogRequest(module="pos_module", object="common_leftMenu_device", opType="pos_op_collectDataOnline", requestParams={"devAlias"}, opContent="common_dev_name")
    public ZKResultMsg requestCollectData(String devIds, String optBoxValue) {
        try {
            this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_processing", (Object[])new Object[0]) + "...<br/>");
            List devList = this.posDeviceService.getItemByIds(devIds);
            if (devList.size() > 0) {
                PosDeviceItem dev = (PosDeviceItem)devList.get(0);
                this.posDeviceService.requestCollectData(devIds, optBoxValue);
                for (int i = 0; i <= 100; i += 10) {
                    this.progressCache.setProcess(new ProcessBean(i, i, dev.getDevAlias() + ":" + I18nUtil.i18nCode((String)"pos_dev_cmdSendSucceed", (Object[])new Object[0]) + i + "%<br/>"));
                    Thread.sleep(500L);
                }
            }
        }
        catch (Exception e) {
            log.error("exception", (Throwable)e);
        }
        finally {
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]));
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"pos:device:reboot"})
    @LogRequest(module="pos_module", object="common_leftMenu_device", opType="pos_op_reboot", requestParams={"devAlias"}, opContent="common_dev_name")
    public ZKResultMsg reboot(String ids) {
        ZKResultMsg zKResultMsg = this.posDeviceService.reboot(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)zKResultMsg);
    }

    @RequiresPermissions(value={"pos:device:syncAllDataToDev"})
    @LogRequest(module="pos_module", object="common_leftMenu_device", opType="pos_op_syncallDataToDev", requestParams={"devAlias"}, opContent="common_dev_name")
    public ZKResultMsg syncAllDataToDev(String ids) {
        ZKResultMsg zKResultMsg = this.posDeviceService.syncAllDataToDev(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)zKResultMsg);
    }

    public TreeItem tree() {
        List items = this.posDeviceService.getByCondition(new PosDeviceItem());
        ArrayList<TreeItem> tempItems = new ArrayList<TreeItem>();
        TreeItem item = null;
        TreeItem pItem = null;
        for (PosDeviceItem depart : items) {
            item = new TreeItem();
            item.setId(depart.getId());
            item.setText(depart.getSn() + "(" + depart.getDevAlias() + ")");
            pItem = new TreeItem("0");
            item.setParent(pItem);
            tempItems.add(item);
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(tempItems);
        return new TreeItem("0", treeItems);
    }

    public TreeItem handConsumeTree() {
        PosDeviceItem posDeviceItem = new PosDeviceItem();
        List items = this.posDeviceService.loadListByAuthFilter(this.request.getSession().getId(), posDeviceItem);
        ArrayList<TreeItem> tempItems = new ArrayList<TreeItem>();
        TreeItem item = null;
        TreeItem pItem = null;
        for (PosDeviceItem depart : items) {
            item = new TreeItem();
            item.setId(depart.getId());
            item.setText(depart.getSn() + "(" + depart.getDevAlias() + ")");
            pItem = new TreeItem("0");
            item.setParent(pItem);
            tempItems.add(item);
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(tempItems);
        return new TreeItem("0", treeItems);
    }

    public ZKResultMsg getDevSnList() {
        return new ZKResultMsg((Object)this.posDeviceService.getDevSnList());
    }

    @RequiresPermissions(value={"pos:device:search"})
    public ZKResultMsg searchDev(Long nowTime) {
        JSONObject devInfoJson = new JSONObject();
        try {
            List devcieItems = this.posDeviceService.searchDeviceList();
            devInfoJson.put("ret", (Object)"ok");
            devInfoJson.put("devCount", (Object)devcieItems.size());
            JSONArray jsonArray = new JSONArray();
            devcieItems.forEach(item -> {
                JSONObject rowData = new JSONObject();
                rowData.put("IP", (Object)item.getIp());
                rowData.put("SN", (Object)item.getSn());
                rowData.put("Device", (Object)item.getDeviceName());
                jsonArray.add((Object)rowData);
            });
            devInfoJson.put("devData", (Object)jsonArray);
            devInfoJson.put("nowTime", (Object)nowTime);
        }
        catch (Exception e) {
            throw new ZKBusinessException((Throwable)e);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)devInfoJson));
    }

    public ZKResultMsg getAllIPSn() {
        JSONObject devInfoJson = new JSONObject();
        List posDeviceItemList = this.posDeviceService.getByCondition(new PosDeviceItem());
        JSONArray ipArray = new JSONArray();
        JSONArray snArray = new JSONArray();
        posDeviceItemList.stream().forEach(item -> {
            ipArray.add((Object)item.getIpAddress());
            snArray.add((Object)item.getSn());
        });
        devInfoJson.put("ipAddress", (Object)ipArray);
        devInfoJson.put("sn", (Object)snArray);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)devInfoJson));
    }

    public ZKResultMsg convertRecordComplete(String value) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        String data = this.posDeviceService.getRecordComplete(value);
        zkResultMsg.setData((Object)data);
        return zkResultMsg;
    }

    public ZKResultMsg convertParsedCmdCount(String value) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        String data = this.posDeviceService.getCmdCount(value);
        zkResultMsg.setData((Object)data);
        return zkResultMsg;
    }

    public ZKResultMsg convertUseType(Integer value) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        String data = this.posDeviceService.getUseType(value);
        zkResultMsg.setData((Object)data);
        return zkResultMsg;
    }

    public boolean isExistIpAddress(String ipAddress) {
        return this.posDeviceService.isExistIpAddress(ipAddress);
    }

    public boolean isExistAlias(String alias) {
        return this.posDeviceService.isExistAlias(alias);
    }

    @RequiresPermissions(value={"pos:device:search"})
    public ModelAndView getSearchDevInfo() {
        this.request.setAttribute("hostPort", (Object)this.hostPort);
        return new ModelAndView("pos/device/opPosSearchDev");
    }
}

