/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pos.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.pos.constants.PosConstants;
import com.zkteco.zkbiosecurity.pos.remote.PosCardManageRemote;
import com.zkteco.zkbiosecurity.pos.service.PosCardManageService;
import com.zkteco.zkbiosecurity.pos.service.PosSystemParamService;
import com.zkteco.zkbiosecurity.pos.vo.PosCardManageItem;
import com.zkteco.zkbiosecurity.pos.vo.PosCardSelectItem;
import com.zkteco.zkbiosecurity.pos.vo.PosPersonSelectItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PosCardManageController
extends ExportController
implements PosCardManageRemote {
    @Autowired
    private PosCardManageService posCardManageService;
    @Autowired
    private PosSystemParamService posSystemParamService;
    @Value(value="${system.language}")
    private String language;

    @RequiresPermissions(value={"pos:cardManage"})
    public ModelAndView index() {
        HashMap<String, String> param = new HashMap<String, String>();
        Integer cardModel = this.posSystemParamService.getDoubleCash();
        param.put("cardModel", cardModel.toString());
        return new ModelAndView("pos/cardManage/posCardManage", param);
    }

    @RequiresPermissions(value={"pos:cardManage:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.posCardManageService.getItemById(id));
        }
        return new ModelAndView("pos/cardManage/editPosCardManage");
    }

    @RequiresPermissions(value={"pos:cardManage:edit"})
    @LogRequest(module="pos_module", object="pos_leftMenu_cardManage", opType="common_op_new", requestParams={"deptName"}, opContent="pos_card_personNum")
    public ZKResultMsg save(PosCardManageItem item) {
        ZKResultMsg res = new ZKResultMsg();
        String subBalance = this.request.getParameter("subBalance");
        Double subBal = subBalance != null ? Double.parseDouble(subBalance) : 0.0;
        this.posCardManageService.saveItem(item, "0", subBal);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public String isExist(@RequestParam(value="sysCardNo") String sysCardNo) {
        return String.valueOf(this.posCardManageService.isExist(sysCardNo));
    }

    public String isPersPersonExist(@RequestParam(value="personId") String personId) {
        return String.valueOf(this.posCardManageService.isPersPersonExist(personId));
    }

    @RequiresPermissions(value={"pos:cardManage:refresh"})
    public DxGrid list(PosCardManageItem codition) {
        Pager pager = this.posCardManageService.loadPagerByAuthFilter(codition, this.getPageNo(), this.getPageSize(), this.request.getSession().getId());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"pos:cardManage:del"})
    @LogRequest(module="pos_module", object="pos_leftMenu_cardManage", opType="common_op_del", requestParams={"ids"}, opContent="pos_common_id")
    public ZKResultMsg delete(String ids) {
        this.posCardManageService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"pos:cardManage:logout"})
    @LogRequest(module="pos_module", object="pos_leftMenu_cardManage", opType="pos_op_manage_card_logout", requestParams={"personPin"}, opContent="pos_card_personNum")
    public ZKResultMsg logout(String ids) {
        ZKResultMsg zKResultMsg = this.posCardManageService.logout(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)zKResultMsg);
    }

    @RequiresPermissions(value={"pos:cardManage:noneRetreatCard"})
    public ModelAndView noneRetreatCard(String ids) {
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            PosCardManageItem item = this.posCardManageService.getItemById(ids);
            this.request.setAttribute("balance", (Object)item.getBalance());
            this.request.setAttribute("sysCardNo", (Object)item.getSysCardNo());
            this.request.setAttribute("id", (Object)ids);
        }
        return new ModelAndView("pos/cardManage/noneRetreatCard");
    }

    @LogRequest(module="pos_module", object="pos_leftMenu_cardManage", opType="pos_op_noneRetreatCard", requestParams={"sysCardNo"}, opContent="pos_card_accountNum")
    public ZKResultMsg opNoneRetreatCard() {
        ZKResultMsg zKResultMsg = new ZKResultMsg();
        String id = this.request.getParameter("id");
        String isRefund = this.request.getParameter("selectRefund");
        this.posCardManageService.opNoneRetreat(id, isRefund);
        return I18nUtil.i18nMsg((ZKResultMsg)zKResultMsg);
    }

    @RequiresPermissions(value={"pos:cardManage:export"})
    public void export(HttpServletRequest request, HttpServletResponse response) throws IllegalAccessException, InvocationTargetException {
        PosCardManageItem posCardManageItem = new PosCardManageItem();
        this.setConditionValue((BaseItem)posCardManageItem);
        List intemList = this.posCardManageService.loadListByAuthFilter(posCardManageItem, this.getBeginIndex(), this.getEndIndex(), request.getSession().getId());
        this.excelExport(intemList, PosCardManageItem.class);
    }

    public DxGrid selectList(PosPersonSelectItem condition) {
        Pager pager = new Pager();
        if ("noSelected".equals(condition.getType())) {
            pager = this.posCardManageService.getNoExistPerson(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        } else if ("selected".equals(condition.getType())) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public DxGrid selectLossCardList(PosCardSelectItem condition) {
        Pager pager = new Pager();
        if ("noSelected".equals(condition.getType())) {
            pager = this.posCardManageService.getNoExistCard(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        } else if ("selected".equals(condition.getType())) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public DxGrid selectAllowanceCardList(PosCardSelectItem condition) {
        Pager pager = new Pager();
        if ("noSelected".equals(condition.getType())) {
            pager = this.posCardManageService.selectAllowanceCardList(condition, this.getPageNo(), this.getPageSize(), this.request.getSession().getId());
        } else if ("selected".equals(condition.getType())) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg getLoadCardData() {
        String cardPwd = this.request.getParameter("cardPwd");
        return this.posCardManageService.getLoadCardData(cardPwd);
    }

    public ZKResultMsg checkNewCardNo() {
        String cardNo = this.request.getParameter("cardNo").replace("\t", "");
        String personId = this.request.getParameter("personId");
        boolean isRecharge = false;
        return this.posCardManageService.checkNewCardNo(cardNo, personId, isRecharge);
    }

    public ZKResultMsg checkPwd() {
        boolean isSame = true;
        String rawPassword = this.request.getParameter("rawPassword");
        isSame = this.posCardManageService.checkPwd(rawPassword);
        return new ZKResultMsg((Object)isSame);
    }

    public ZKResultMsg getUpdatePwdData() {
        String cardPwd = this.request.getParameter("cardPwd");
        return this.posCardManageService.getUpdatePwdData(cardPwd);
    }

    public ZKResultMsg getInitCardData() {
        return this.posCardManageService.getInitCardData();
    }

    public ZKResultMsg getEditCardData() {
        String cardPrivage = this.request.getParameter("cardPrivage");
        String passWord = this.request.getParameter("passWord");
        String sysCardNo = this.request.getParameter("cardNo");
        String balance = this.request.getParameter("balance");
        String subBalance = this.request.getParameter("subBalance");
        String cardTypeId = this.request.getParameter("cardType");
        String SubsidyBatch = this.request.getParameter("maxBatch");
        PosCardManageItem posCardManage = new PosCardManageItem();
        posCardManage.setIssueDate(new Date());
        posCardManage.setPassword(passWord);
        posCardManage.setSysCardNo(Integer.valueOf(Integer.parseInt(sysCardNo)));
        posCardManage.setBalance(Double.valueOf(Double.parseDouble(balance)));
        if ("0".equals(cardPrivage)) {
            return this.posCardManageService.editCard(posCardManage, subBalance, cardTypeId, SubsidyBatch);
        }
        return this.posCardManageService.editManageCard(posCardManage);
    }

    public ZKResultMsg loadCard() {
        JSONObject resultJson = new JSONObject();
        String cardNo = this.request.getParameter("CardSerial").replace("\t", "");
        String sysCardNo = this.request.getParameter("SysID");
        String cardCode = this.request.getParameter("CardType");
        if (!"255".equals(cardCode)) {
            String cardSolde = this.request.getParameter("Banlance");
            String subBalance = this.request.getParameter("PosMoney_Sub");
            String password = this.request.getParameter("UserPwd");
            String issueDate = this.request.getParameter("StartDate");
            String cardSerialNum = this.request.getParameter("CardMark");
            List cardManageList = this.posCardManageService.getItemBySysCardNo(sysCardNo);
            Long cardSoldeMax = "zh_CN".equals(this.language) ? PosConstants.CARD_SOLDE_MAX : PosConstants.OVERSEA_CARD_SOLDE_MAX;
            if (Long.parseLong(cardSolde) <= cardSoldeMax) {
                if (cardManageList != null) {
                    PosCardManageItem cardManage = (PosCardManageItem)cardManageList.get(0);
                    this.posCardManageService.buildPersonDept(cardManage);
                    if (!"3".equals(cardManage.getCardStatus())) {
                        resultJson.put("id", (Object)cardManage.getId().toString());
                        resultJson.put("sysCardNo", (Object)sysCardNo);
                        resultJson.put("pin", (Object)cardManage.getPersonPin());
                        resultJson.put("name", (Object)cardManage.getPersonName());
                        resultJson.put("lastName", (Object)cardManage.getPersonLastName());
                        resultJson.put("dept", (Object)cardManage.getDeptName());
                        Double cardSoldeDoubleValue = new BigDecimal(cardSolde).divide(BigDecimal.valueOf(100L)).setScale(2, 4).doubleValue();
                        resultJson.put("cardSolde", (Object)cardSoldeDoubleValue);
                        resultJson.put("subBalance", subBalance == null ? "0" : Double.valueOf(Double.parseDouble(subBalance) / 100.0));
                        Double cardSumMoneyDoubleValue = new BigDecimal(cardSolde).divide(BigDecimal.valueOf(100L)).add(subBalance == null ? BigDecimal.valueOf(0L) : new BigDecimal(subBalance).divide(BigDecimal.valueOf(100L))).setScale(2, 4).doubleValue();
                        resultJson.put("cardSumMoney", (Object)cardSumMoneyDoubleValue);
                        resultJson.put("balance", (Object)cardManage.getBalance());
                        Double allBalanceDoubleValue = BigDecimal.valueOf(cardManage.getBalance()).add(BigDecimal.valueOf(cardManage.getSubBalance())).setScale(2, 4).doubleValue();
                        resultJson.put("allBalance", (Object)allBalanceDoubleValue);
                        resultJson.put("dbSubBalance", (Object)cardManage.getSubBalance());
                        resultJson.put("cardCost", (Object)cardManage.getCardCost());
                        resultJson.put("serialNum", (Object)cardSerialNum);
                        resultJson.put("password", (Object)password);
                        resultJson.put("overpwd", (Object)cardManage.getPassword());
                        resultJson.put("issueDate", (Object)issueDate);
                        resultJson.put("startDate", (Object)new SimpleDateFormat("yyyy-MM-dd").format(cardManage.getIssueDate()));
                        resultJson.put("cardICcard", (Object)cardManage.getName());
                        resultJson.put("cardType", (Object)cardManage.getPosCardKindId());
                        resultJson.put("isValid", (Object)cardManage.getIsValid());
                        resultJson.put("cardStatus", (Object)cardManage.getCardStatus());
                        resultJson.put("cardNo", (Object)cardNo);
                    } else {
                        resultJson.put("msgStr", (Object)I18nUtil.i18nCode((String)"pos_error_message_lost", (Object[])new Object[0]));
                    }
                } else {
                    resultJson.put("msgStr", (Object)I18nUtil.i18nCode((String)"pos_error_message_notInDB", (Object[])new Object[0]));
                }
            } else {
                resultJson.put("msgStr", (Object)I18nUtil.i18nCode((String)"pos_error_message_loadMoneyError", (Object[])new Object[0]));
            }
        } else if (this.posCardManageService.getItemBySysCardNo(sysCardNo) == null) {
            resultJson.put("msgStr", (Object)I18nUtil.i18nCode((String)"pos_error_message_notInDB", (Object[])new Object[0]));
        } else {
            resultJson.put("msgStr", (Object)I18nUtil.i18nCode((String)"pos_error_message_isManageCard", (Object[])new Object[0]));
        }
        return new ZKResultMsg((Object)resultJson);
    }

    public ZKResultMsg getRefundData() {
        String needMoney = this.request.getParameter("money");
        Double balanceCard = Double.parseDouble(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.request.getParameter("balanceCard")}) ? this.request.getParameter("balanceCard") : "0") / 100.0;
        Double subBalanceCard = Double.parseDouble(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.request.getParameter("subBalanceCard")}) ? this.request.getParameter("subBalanceCard") : "0") / 100.0;
        String date = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.request.getParameter("dateTime")}) ? this.request.getParameter("dateTime") : "";
        String batchNo = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.request.getParameter("batchNo")}) ? this.request.getParameter("batchNo") : "";
        String model = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.request.getParameter("model")}) ? this.request.getParameter("model") : "";
        return this.posCardManageService.getRefundData(needMoney, balanceCard, subBalanceCard, date, batchNo, model);
    }

    @LogRequest(module="pos_module", object="pos_op_retreatCard", opType="pos_op_retreatCard", requestParams={"SysID"}, opContent="pos_card_accountNum")
    public ZKResultMsg retreatCard() {
        String sysCardNo = this.request.getParameter("SysID");
        String refundMoney = this.request.getParameter("refundMoney");
        String cardSerialNum = this.request.getParameter("cardSerialNum");
        return this.posCardManageService.retreatCard(sysCardNo, refundMoney, cardSerialNum);
    }

    public ZKResultMsg checkForRecharge() {
        String cardNo = this.request.getParameter("cardNo");
        String posCardManageId = this.request.getParameter("posCardManageId");
        String personId = this.posCardManageService.getItemById(posCardManageId).getPersonId();
        boolean isRecharge = true;
        return this.posCardManageService.checkNewCardNo(cardNo, personId, isRecharge);
    }

    public ZKResultMsg getToUpData() {
        String subMoney = StringUtils.isNotBlank((CharSequence)this.request.getParameter("subMoney")) ? this.request.getParameter("subMoney") : "0";
        return this.posCardManageService.getToUpData(this.request.getParameter("money"), subMoney);
    }

    public ZKResultMsg getModifyData() {
        String password = this.request.getParameter("password");
        String date = this.request.getParameter("issueDate");
        String posCardKind = this.request.getParameter("cardType");
        return this.posCardManageService.getModifyData(password, date, posCardKind);
    }

    public ZKResultMsg checkTopUp() {
        String sysCardNo = this.request.getParameter("SysID");
        String mode = this.request.getParameter("mode");
        String target = this.request.getParameter("sysCardNo");
        Double money = Double.parseDouble(this.request.getParameter("money"));
        Double balance = Double.parseDouble(this.request.getParameter("Banlance"));
        Double subBalance = Double.parseDouble(this.request.getParameter("SubBanlance") != null ? this.request.getParameter("SubBanlance") : "0.0");
        return this.posCardManageService.checkTopUp(target, sysCardNo, mode, money, balance, subBalance);
    }

    @LogRequest(module="pos_module", object="pos_op_topUp", opType="pos_op_topUp", requestParams={"SysID"}, opContent="pos_card_accountNum")
    public ZKResultMsg topUp() {
        Double money = Double.parseDouble(this.request.getParameter("money"));
        String sysCardNo = this.request.getParameter("SysID");
        String cardSerial = this.request.getParameter("CardMark");
        String cardBlance = this.request.getParameter("Banlance");
        String subBalance = this.request.getParameter("PosMoney_Sub");
        String mode = this.request.getParameter("mode");
        return this.posCardManageService.topUp(money, sysCardNo, cardSerial, cardBlance, subBalance, mode);
    }

    @LogRequest(module="pos_module", object="pos_op_refund", opType="pos_op_refund", requestParams={"SysID"}, opContent="pos_card_accountNum")
    public ZKResultMsg refund() {
        Double money = Double.parseDouble(this.request.getParameter("money"));
        String sysCardNo = this.request.getParameter("SysID");
        String cardSerial = this.request.getParameter("CardMark");
        String cardBlance = this.request.getParameter("Banlance");
        String subBalance = this.request.getParameter("PosMoney_Sub");
        String mode = this.request.getParameter("mode");
        return this.posCardManageService.refund(money, sysCardNo, cardSerial, cardBlance, subBalance, mode);
    }

    public ZKResultMsg modify() {
        String sysCardNo = this.request.getParameter("sysCardNo");
        String password = this.request.getParameter("password");
        String date = this.request.getParameter("issueDate");
        String issueDate = date + " " + new SimpleDateFormat("HH:mm:ss").format(new Date());
        String posCardKind = this.request.getParameter("cardType");
        return this.posCardManageService.modify(sysCardNo, password, issueDate, posCardKind);
    }

    public String moneyLimit() {
        Double balance = 0.0;
        Double subBalance = 0.0;
        if ("allowance".equals(this.request.getParameter("type"))) {
            if (!"".equals(this.request.getParameter("sysCardNo")) && this.request.getParameter("sysCardNo") != null) {
                String money = this.request.getParameter("money");
                balance = Double.parseDouble(money);
            }
        } else {
            if (!"".equals(this.request.getParameter("balance")) && this.request.getParameter("balance") != null) {
                balance = Double.parseDouble(this.request.getParameter("balance"));
            }
            if (!"".equals(this.request.getParameter("subBalance")) && this.request.getParameter("subBalance") != null) {
                subBalance = Double.parseDouble(this.request.getParameter("subBalance"));
            }
        }
        String cardId = this.request.getParameter("cardId");
        return String.valueOf(this.posCardManageService.moneyLimit(balance, cardId, subBalance));
    }

    public ZKResultMsg checkedNoReceice() {
        String posCardManageId = this.request.getParameter("posCardManageId");
        boolean isExsistCheckedNoReceice = this.posCardManageService.checkedNoReceice(posCardManageId);
        return new ZKResultMsg((Object)isExsistCheckedNoReceice);
    }
}

