/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pos.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.ProcessBean;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.LocaleMessageSourceUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.pos.remote.PosAllowanceLogRecordRemote;
import com.zkteco.zkbiosecurity.pos.service.PosAllowanceLogRecordService;
import com.zkteco.zkbiosecurity.pos.service.PosSystemParamService;
import com.zkteco.zkbiosecurity.pos.vo.PosAllowanceLogRecordItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PosAllowanceLogRecordController
extends ExportController
implements PosAllowanceLogRecordRemote {
    @Autowired
    private PosAllowanceLogRecordService posAllowanceLogRecordService;
    @Autowired
    private PosSystemParamService posSystemParamService;
    @Autowired
    private ProgressCache progressCache;

    @RequiresPermissions(value={"pos:allowanceLogRecord"})
    public ModelAndView index() {
        HashMap<String, String> param = new HashMap<String, String>();
        Integer cardModel = this.posSystemParamService.getDoubleCash();
        param.put("cardModel", cardModel.toString());
        return new ModelAndView("pos/allowanceLogRecord/posAllowanceLogRecord", param);
    }

    @RequiresPermissions(value={"pos:allowanceLogRecord:edit"})
    public ModelAndView edit(String id) {
        HashMap<String, String> param = new HashMap<String, String>();
        Integer cardModel = Integer.valueOf(this.posSystemParamService.getValByName("pos.cardModel"));
        param.put("cardModel", cardModel.toString());
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.posAllowanceLogRecordService.getItemById(id));
        }
        this.request.setAttribute("param", param);
        return new ModelAndView("pos/allowanceLogRecord/editPosAllowanceLogRecord");
    }

    @RequiresPermissions(value={"pos:allowanceLogRecord:edit"})
    @LogRequest(module="pos_module", object="pos_leftMenu_allowance", opType="common_op_new", requestParams={"personPin"}, opContent="pos_card_personNum")
    public ZKResultMsg save(PosAllowanceLogRecordItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.posAllowanceLogRecordService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"pos:allowanceLogRecord:refresh"})
    public DxGrid list(PosAllowanceLogRecordItem codition) {
        Pager pager = this.posAllowanceLogRecordService.loadPagerByAuthFilter(codition, this.getPageNo(), this.getPageSize(), this.request.getSession().getId());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"pos:allowanceLogRecord:del"})
    @LogRequest(module="pos_module", object="pos_leftMenu_allowance", opType="common_op_del", requestParams={"pins"}, opContent="pos_card_personNum")
    public ZKResultMsg delete(String ids) {
        this.posAllowanceLogRecordService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"pos:allowanceLogRecord:setCheck"})
    public ModelAndView setCheck(String ids) {
        StringBuffer pinStringBuffer = new StringBuffer();
        StringBuffer nameStringBuffer = new StringBuffer();
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            PosAllowanceLogRecordItem condition = new PosAllowanceLogRecordItem();
            condition.setInId(ids);
            List temPosAllowanceLogRecords = this.posAllowanceLogRecordService.getByCondition(condition);
            for (int i = 0; i < temPosAllowanceLogRecords.size(); ++i) {
                PosAllowanceLogRecordItem temPosAllowanceLogRecord = (PosAllowanceLogRecordItem)temPosAllowanceLogRecords.get(i);
                StringBuffer personName = new StringBuffer();
                personName.append(StringUtils.isNotBlank((CharSequence)temPosAllowanceLogRecord.getPersonName()) ? temPosAllowanceLogRecord.getPersonName() : " ");
                if (!"zh_CN".equals(LocaleMessageSourceUtil.language) && StringUtils.isNotBlank((CharSequence)temPosAllowanceLogRecord.getPersonLastName())) {
                    personName.append(".");
                    personName.append(temPosAllowanceLogRecord.getPersonLastName());
                }
                if (i != temPosAllowanceLogRecords.size() - 1) {
                    pinStringBuffer.append(temPosAllowanceLogRecord.getPersonPin() + ",");
                    nameStringBuffer.append(personName.toString() + ",");
                } else {
                    pinStringBuffer.append(temPosAllowanceLogRecord.getPersonPin());
                    nameStringBuffer.append(StringUtils.isNotBlank((CharSequence)personName.toString()) ? personName.toString() : "");
                }
                this.posAllowanceLogRecordService.buildPersonDept(temPosAllowanceLogRecord);
            }
            this.request.setAttribute("ids", (Object)ids);
            this.request.setAttribute("selectedPin", (Object)pinStringBuffer.toString());
            this.request.setAttribute("selectedName", (Object)nameStringBuffer.toString());
            this.request.setAttribute("ids", (Object)ids);
        }
        return new ModelAndView("pos/allowanceLogRecord/setCheck");
    }

    @RequiresPermissions(value={"pos:allowanceLogRecord:setCheck"})
    @LogRequest(module="pos_module", object="pos_leftMenu_allowance", opType="pos_allowance_check", requestParams={"pins"}, opContent="pos_card_personNum")
    public ZKResultMsg check(String id) {
        String[] ids = this.request.getParameter("ids").split(",");
        ZKResultMsg zKResultMsg = this.posAllowanceLogRecordService.check(ids, false, this.request.getSession().getId());
        return I18nUtil.i18nMsg((ZKResultMsg)zKResultMsg);
    }

    @RequiresPermissions(value={"pos:allowanceLogRecord:enable"})
    @LogRequest(module="pos_module", object="pos_leftMenu_allowance", opType="pos_allowance_checkAll", opContent="pos_allowance_checkAll")
    public ZKResultMsg enable() {
        ZKResultMsg zKResultMsg = this.posAllowanceLogRecordService.enable(this.request.getSession().getId());
        return I18nUtil.i18nMsg((ZKResultMsg)zKResultMsg);
    }

    @RequiresPermissions(value={"pos:allowanceLogRecord:setReCheck"})
    public ModelAndView setReCheck(String ids) {
        StringBuffer pinStringBuffer = new StringBuffer();
        StringBuffer nameStringBuffer = new StringBuffer();
        String[] allowanceLogRecordIds = ids.split(",");
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            for (int i = 0; i < allowanceLogRecordIds.length; ++i) {
                PosAllowanceLogRecordItem temPosAllowanceLogRecord = this.posAllowanceLogRecordService.getItemById(allowanceLogRecordIds[i]);
                if (i != allowanceLogRecordIds.length - 1) {
                    pinStringBuffer.append(temPosAllowanceLogRecord.getPersonPin() + ",");
                    nameStringBuffer.append(temPosAllowanceLogRecord.getPersonName() + ",");
                    continue;
                }
                pinStringBuffer.append(temPosAllowanceLogRecord.getPersonPin());
                nameStringBuffer.append(temPosAllowanceLogRecord.getPersonName() == null ? "" : temPosAllowanceLogRecord.getPersonName());
            }
            this.request.setAttribute("ids", (Object)ids);
            this.request.setAttribute("selectedPin", (Object)pinStringBuffer.toString());
            this.request.setAttribute("selectedName", (Object)nameStringBuffer.toString());
            this.request.setAttribute("ids", (Object)ids);
        }
        return new ModelAndView("pos/allowanceLogRecord/setReCheck");
    }

    @RequiresPermissions(value={"pos:allowanceLogRecord:setReCheck"})
    @LogRequest(module="pos_module", object="pos_leftMenu_allowance", opType="pos_allowance_reCheck", requestParams={"pins"}, opContent="pos_card_personNum")
    public ZKResultMsg recheck(String id) {
        String ids = this.request.getParameter("ids");
        ZKResultMsg zKResultMsg = this.posAllowanceLogRecordService.recheck(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)zKResultMsg);
    }

    @RequiresPermissions(value={"pos:allowanceLogRecord:export"})
    public void export(HttpServletRequest request, HttpServletResponse response) throws IllegalAccessException, InvocationTargetException {
        String queryCondition = request.getParameter("queryConditions");
        String[] conditionAry = queryCondition.replaceAll("%20", " ").split("&");
        PosAllowanceLogRecordItem posAllowanceLogRecordItem = new PosAllowanceLogRecordItem();
        this.setConditionValue((BaseItem)posAllowanceLogRecordItem);
        for (String condition : conditionAry) {
            Date date;
            if (StringUtils.isBlank((CharSequence)condition)) continue;
            String[] strAry = condition.split("=");
            if ("receiveDate".equals(strAry[0])) {
                date = DateUtil.stringToDate((String)strAry[1], (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD_HH_MM_SS);
                posAllowanceLogRecordItem.setReceiveDate(date);
                continue;
            }
            if (!"validDate".equals(strAry[0])) continue;
            date = DateUtil.stringToDate((String)strAry[1], (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD_HH_MM_SS);
            posAllowanceLogRecordItem.setValidDate(date);
        }
        List intemList = this.posAllowanceLogRecordService.loadListByAuthFilter(posAllowanceLogRecordItem, this.getBeginIndex(), this.getEndIndex(), request.getSession().getId());
        this.excelExport(intemList, PosAllowanceLogRecordItem.class);
    }

    @RequiresPermissions(value={"pos:allowanceLogRecord:export"})
    public void exportTemplet(HttpServletRequest request, HttpServletResponse response) throws IllegalAccessException, InvocationTargetException {
        Integer cardModel = Integer.valueOf(this.posSystemParamService.getValByName("pos.cardModel"));
        HashMap map = new HashMap();
        HashMap<String, String> jsonColumn = new HashMap<String, String>();
        JSONObject json = new JSONObject(true);
        json.put("personPin", (Object)I18nUtil.i18nCode((String)"pos_allowance_userId", (Object[])new Object[0]));
        json.put("money", (Object)I18nUtil.i18nCode((String)"pos_allowance_money", (Object[])new Object[0]));
        if (cardModel == 2) {
            json.put("startDate", (Object)I18nUtil.i18nCode((String)"pos_allowance_startDate", (Object[])new Object[0]));
        }
        json.put("validDate", (Object)I18nUtil.i18nCode((String)"pos_allowance_validDate", (Object[])new Object[0]));
        jsonColumn.put("jsonColumn", json.toJSONString());
        map.put("jsonColumn", jsonColumn);
        ArrayList<PosAllowanceLogRecordItem> itemList = new ArrayList<PosAllowanceLogRecordItem>();
        PosAllowanceLogRecordItem item = new PosAllowanceLogRecordItem();
        item.setPersonPin("9999");
        item.setMoney(Double.valueOf(20.0));
        if (cardModel == 2) {
            item.setStartDate(DateUtil.stringToDate((String)"2030-12-31 00:00:00"));
        }
        item.setValidDate(DateUtil.stringToDate((String)"2030-12-31 00:00:00"));
        itemList.add(item);
        this.excelExport(itemList, PosAllowanceLogRecordItem.class, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZKResultMsg importExcel(MultipartFile upload) throws IOException {
        int progress = 5;
        try {
            this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_processing", (Object[])new Object[0]) + "...<br/>");
            this.progressCache.setProcess(new ProcessBean(progress, progress, I18nUtil.i18nCode((String)"pers_import_uploadFileSuccess", (Object[])new Object[0]) + "<br/>"));
            List itemList = this.excelImport(upload.getInputStream(), PosAllowanceLogRecordItem.class);
            this.progressCache.setProcess(new ProcessBean(progress, progress, I18nUtil.i18nCode((String)"pers_import_resolutionComplete", (Object[])new Object[0]) + "<br/>"));
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)this.posAllowanceLogRecordService.importData(itemList));
            return zKResultMsg;
        }
        catch (Exception e) {
            progress = 99;
            if (e instanceof ZKBusinessException) {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)e.getMessage(), (Object[])((ZKBusinessException)e).objects) + "</font><br/>"));
            } else {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)"common_prompt_dataError", (Object[])new Object[0]) + "</font><br/>"));
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + e.getMessage() + "</font><br/>"));
            }
            this.log.error("Import PosAllowance Exception", (Throwable)e);
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg());
            return zKResultMsg;
        }
        finally {
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_dev_opComplish", (Object[])new Object[0]));
        }
    }
}

