/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pos.api.controller;

import com.zkteco.zkbiosecurity.base.vo.ApiResultMessage;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.pos.service.PosTransactionService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/transaction"})
@Api(tags={"PosTransaction"}, description="pos transaction")
public class PosApiTransactionController {
    @Autowired
    private PosTransactionService posTransactionService;

    @ResponseBody
    @RequestMapping(value={"/listPosTransaction"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiOperation(value="Get Pos Transactions List", notes="Return Pos Transactions List", response=ApiResultMessage.class)
    public ApiResultMessage listPosTransaction(@RequestParam(required=false) String personPin, @RequestParam(required=false) String deptCode, @RequestParam(required=false) String startDate, @RequestParam(required=false) String endDate, @RequestParam Integer pageNo, @RequestParam Integer pageSize) {
        if (pageNo <= 0 || pageSize <= 0) {
            return ApiResultMessage.message((int)-90, (String)I18nUtil.i18nCode((String)"common_api_pageValid", (Object[])new Object[0]));
        }
        if (pageSize > 1000) {
            return ApiResultMessage.message((int)-91, (String)I18nUtil.i18nCode((String)"common_api_pageSizeOver", (Object[])new Object[0]));
        }
        if (StringUtils.isNotBlank((CharSequence)startDate) && StringUtils.isNotBlank((CharSequence)endDate)) {
            Date startTime = DateUtil.stringToDate((String)startDate);
            Date endTime = DateUtil.stringToDate((String)endDate);
            if (startTime == null || endTime == null) {
                return ApiResultMessage.message((int)-100, (String)I18nUtil.i18nCode((String)"common_dsTime_timeValid2", (Object[])new Object[0]));
            }
            if (startTime.getTime() > endTime.getTime()) {
                return ApiResultMessage.message((int)-101, (String)I18nUtil.i18nCode((String)"common_dsTime_timeValid4", (Object[])new Object[0]));
            }
        }
        List posApiTransactionItemList = this.posTransactionService.getApiTransactionList(personPin, deptCode, startDate, endDate, pageNo.intValue(), pageSize.intValue());
        return ApiResultMessage.successMessage((Object)posApiTransactionItemList);
    }
}

