/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.client.service.impl;

import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.message.bean.ZKMessage;
import com.zkteco.zkbiosecurity.park.bean.ParkProcessParameter;
import com.zkteco.zkbiosecurity.park.constants.ParkConstants;
import com.zkteco.zkbiosecurity.park.service.ParkCloudService;
import com.zkteco.zkbiosecurity.park.service.ParkDeviceService;
import com.zkteco.zkbiosecurity.park.service.ParkParamsService;
import com.zkteco.zkbiosecurity.park.service.ParkParkingMeterService;
import com.zkteco.zkbiosecurity.park.service.ParkPavilioService;
import com.zkteco.zkbiosecurity.park.service.ParkRecordinService;
import com.zkteco.zkbiosecurity.park.service.ParkRecordoutService;
import com.zkteco.zkbiosecurity.park.service.ParkTempBillingService;
import com.zkteco.zkbiosecurity.park.service.ParkVoiceViewService;
import com.zkteco.zkbiosecurity.park.vo.ParkDeviceItem;
import com.zkteco.zkbiosecurity.park.vo.ParkParkingMeterItem;
import com.zkteco.zkbiosecurity.park.vo.ParkPavilioItem;
import com.zkteco.zkbiosecurity.park.vo.ParkRecordinItem;
import com.zkteco.zkbiosecurity.park.vo.ParkRecordoutItem;
import com.zkteco.zkbiosecurity.park.vo.ParkTempBillingItem;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.transaction.Transactional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ParkWechatResult {
    private static final Logger log = LoggerFactory.getLogger(ParkWechatResult.class);
    @Autowired
    private ParkParkingMeterService parkingMeterService;
    @Autowired
    private ParkRecordinService parkRecordinService;
    @Autowired
    private ParkTempBillingService parkTempBillingService;
    @Autowired
    private ParkParamsService parkParamsService;
    @Autowired
    private ParkDeviceService parkDeviceService;
    @Autowired
    private ParkCloudService parkCloudService;
    @Autowired
    private ParkRecordoutService parkRecordoutService;
    @Autowired
    private ParkVoiceViewService parkVoiceViewService;
    @Autowired
    private ParkPavilioService parkPavilioService;

    @Transactional
    public ZKResultMsg wechatResult(ZKMessage msg) {
        if (this.parkParamsService.printParkLogger()) {
            log.info("PARK_ONLINE_PAY == Receiving Charge Result Start");
        }
        Map retMap = msg.getContent();
        String recordinId = retMap.get("checkinId").toString();
        String payType = retMap.get("payType").toString();
        String channelId = null;
        if (retMap.containsKey("channelId")) {
            channelId = retMap.get("channelId").toString();
        }
        log.info("PARK_ONLINE_PAY == Receiving Charge Result, RecordinId=" + recordinId + " ChannelId=" + channelId);
        Short eventType = ParkConstants.EVENT_ONLINE_WXPAY;
        Short paymentMethod = ParkConstants.PAY_ONLINE_WXPAY;
        if ("ALIPAY".equalsIgnoreCase(payType)) {
            eventType = ParkConstants.EVENT_ONLINE_ALIPAY;
            paymentMethod = ParkConstants.PAY_ONLINE_ALIPAY;
        }
        ParkTempBillingItem tempBillingItem = this.parkTempBillingService.getByRecordinId(recordinId);
        boolean operationMode = this.parkParamsService.isUnmanned();
        if (operationMode && StringUtils.isNotBlank((CharSequence)channelId)) {
            if (this.parkParamsService.printParkLogger()) {
                log.info("PARK_ONLINE_PAY == Receiving Charge Result Unmanned Start");
            }
            if (Objects.nonNull(tempBillingItem)) {
                this.parkTempBillingService.deleteByIds(tempBillingItem.getId());
            }
            ParkRecordinItem recordinItem = this.parkRecordinService.getItemById(recordinId);
            recordinItem.setStatus(ParkConstants.CAR_STATUS_OUT);
            this.parkRecordinService.saveItem(recordinItem);
            ParkParkingMeterItem parkingMeterItem = Objects.nonNull(tempBillingItem) ? this.parkingMeterService.getItemById(tempBillingItem.getParkingMeterId()) : this.parkingMeterService.getItemById(recordinItem.getParkingMeterId());
            if (Objects.nonNull(parkingMeterItem)) {
                ParkDeviceItem parkDeviceItem;
                int openRet;
                if (this.parkParamsService.printParkLogger()) {
                    log.info("PARK_ONLINE_PAY == Receiving Charge Result Unmanned Meter");
                }
                parkingMeterItem.setPaymentMethod(paymentMethod);
                this.parkingMeterService.saveItem(parkingMeterItem);
                ParkRecordoutItem recordoutItem = this.parkRecordoutService.getItemById(parkingMeterItem.getRecordoutId());
                if (Objects.nonNull(recordoutItem)) {
                    ParkProcessParameter parameter = new ParkProcessParameter();
                    parameter.setLicense(recordoutItem.getCarNumber());
                    parameter.setCheckinTime(recordinItem.getCheckInTime());
                    parameter.setCheckoutTime(recordoutItem.getCheckOutTime());
                    parameter.setParkChannelId(channelId);
                    ParkPavilioItem parkPavilioItem = this.parkPavilioService.getItemById(recordoutItem.getParkPavilioId());
                    if (Objects.nonNull(parkPavilioItem)) {
                        parameter.setPavilioIP(parkPavilioItem.getIpAddress());
                        this.parkRecordoutService.returnFrontResults("carInfo", "", recordoutItem.getCarTypeCode(), recordoutItem.getUserName(), parameter, recordoutItem.getEventType());
                    }
                }
                if (0 != (openRet = this.parkRecordinService.openChannelGate(parkDeviceItem = this.parkDeviceService.getByChannelIdAndPriorities(channelId, ParkConstants.DEVICE_MASTER), null))) {
                    log.info("PARK_ONLINE_PAY == Receiving Charge Result >>> Open Gate failure --- Plate:{} --- ChannelId:{}", (Object)recordoutItem.getCarNumber(), (Object)channelId);
                    if (-2 != openRet && 0 != (openRet = this.parkRecordinService.openChannelGate(parkDeviceItem, null))) {
                        log.info("PARK_ONLINE_PAY == Receiving Charge Result >>> Again Open Gate failure --- Plate:{} --- ChannelId:{}", (Object)recordoutItem.getCarNumber(), (Object)channelId);
                    }
                }
                this.parkVoiceViewService.peace(parkDeviceItem, recordinItem.getCarNumber(), false, null, "tempVehicle");
                this.parkRecordinService.parkingLotIncr(recordinItem.getParkingAreaId());
                this.parkCloudService.sendCheckoutData(parkingMeterItem.getRecordoutId());
                this.parkRecordoutService.insertRecordinToSide(recordinId);
            }
            if (this.parkParamsService.printParkLogger()) {
                log.info("PARK_ONLINE_PAY == Receiving Charge Result Unmanned End");
            }
        } else {
            if (this.parkParamsService.printParkLogger()) {
                log.info("PARK_ONLINE_PAY == Receiving Charge Result Manned Start");
            }
            ParkRecordinItem recordinItem = null;
            if (Objects.nonNull(tempBillingItem)) {
                tempBillingItem.setPaymentMethod(paymentMethod);
                ParkRecordinItem parkRecordinItem = this.parkRecordinService.getItemById(tempBillingItem.getRecordinId());
                tempBillingItem.setEventType(parkRecordinItem.getEventType());
                this.parkTempBillingService.saveItem(tempBillingItem);
                List recordinItemAry = this.parkRecordinService.getByCheckinIdAndStatus(recordinId, ParkConstants.CAR_STATUS_IN);
                recordinItem = CollectionUtils.isNotEmpty((Collection)recordinItemAry) ? (ParkRecordinItem)recordinItemAry.get(0) : parkRecordinItem;
            } else {
                List recordinItemAry = this.parkRecordinService.getByCheckinIdAndStatus(recordinId, ParkConstants.CAR_STATUS_IN);
                if (CollectionUtils.isNotEmpty((Collection)recordinItemAry)) {
                    recordinItem = (ParkRecordinItem)recordinItemAry.get(0);
                }
            }
            if (Objects.nonNull(recordinItem)) {
                recordinItem.setEventType(eventType);
                this.parkRecordinService.saveItem(recordinItem);
                ParkParkingMeterItem parkingMeterItem = this.parkingMeterService.getItemById(recordinItem.getParkingMeterId());
                parkingMeterItem.setPaymentMethod(paymentMethod);
                this.parkingMeterService.saveItem(parkingMeterItem);
            }
            if (this.parkParamsService.printParkLogger()) {
                log.info("PARK_ONLINE_PAY == Receiving Charge Result Manned End");
            }
        }
        if (this.parkParamsService.printParkLogger()) {
            log.info("PARK_ONLINE_PAY == Receiving Charge Result End");
        }
        return ZKResultMsg.successMsg();
    }
}

