/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.client.service.impl;

import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.client.utils.ParkClientCommonUtil;
import com.zkteco.zkbiosecurity.message.bean.ZKMessage;
import com.zkteco.zkbiosecurity.park.bean.ParkWeChatCharge;
import com.zkteco.zkbiosecurity.park.constants.ParkConstants;
import com.zkteco.zkbiosecurity.park.service.ParkParamsService;
import com.zkteco.zkbiosecurity.park.service.ParkParkingMeterService;
import com.zkteco.zkbiosecurity.park.service.ParkRecordinService;
import com.zkteco.zkbiosecurity.park.service.ParkRecordoutService;
import com.zkteco.zkbiosecurity.park.service.ParkTempBillingService;
import com.zkteco.zkbiosecurity.park.vo.ParkParkingMeterItem;
import com.zkteco.zkbiosecurity.park.vo.ParkRecordinItem;
import com.zkteco.zkbiosecurity.park.vo.ParkTempBillingItem;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ParkWechatCharge {
    private static final Logger log = LoggerFactory.getLogger(ParkWechatCharge.class);
    @Autowired
    private ParkTempBillingService parkTempBillingService;
    @Autowired
    private ParkParkingMeterService parkingMeterService;
    @Autowired
    private ParkRecordinService parkRecordinService;
    @Autowired
    private ParkRecordoutService parkRecordoutService;
    @Autowired
    private ParkParamsService parkParamsService;

    public ZKResultMsg wechatCharge(ZKMessage msg) {
        ParkTempBillingItem tempBillingItem;
        String recordinId = msg.getContent().get("recordinId").toString();
        ParkWeChatCharge weChatCharge = new ParkWeChatCharge();
        if (this.parkParamsService.printParkLogger()) {
            log.info("PARK_ONLINE_PAY == Receive Cloud Parking Charge Request, recordinId = " + recordinId);
        }
        if (Objects.nonNull(tempBillingItem = this.parkTempBillingService.getByRecordinId(recordinId))) {
            if (this.parkParamsService.printParkLogger()) {
                log.info("PARK_ONLINE_PAY == Exit Parking Payment ==={}===", (Object)tempBillingItem);
            }
            ParkClientCommonUtil.getCarTypeByEvent(tempBillingItem.getEventType(), weChatCharge);
            if (ParkConstants.PAY_METHOD_CENTERPAY.equals(tempBillingItem.getPaymentMethod())) {
                List recordinList;
                if (this.parkParamsService.printParkLogger()) {
                    log.info("PARK_ONLINE_PAY == Exit Parking Payment ===PAY_METHOD_CENTERPAY===");
                }
                if (CollectionUtils.isNotEmpty((Collection)(recordinList = this.parkRecordinService.getByCheckinIdAndStatus(recordinId, ParkConstants.CAR_STATUS_IN)))) {
                    ParkRecordinItem recordin = (ParkRecordinItem)recordinList.get(0);
                    recordin.setEventType(ParkConstants.EVENT_ONLINE_CHARGE);
                    recordin.setParkingMeterId(tempBillingItem.getParkingMeterId());
                    this.parkRecordinService.saveItem(recordin);
                }
            }
            tempBillingItem.setPaymentMethod(ParkConstants.PAY_ONLINE_CHARGE);
            this.parkTempBillingService.saveItem(tempBillingItem);
            if (this.parkParamsService.printParkLogger()) {
                log.info("PARK_ONLINE_PAY === Save tempBillingService ===");
            }
            weChatCharge.setFinalAmount(String.valueOf(tempBillingItem.getReceiveAmount()));
            weChatCharge.setChargeType("tempCharge");
            weChatCharge.setRecordinId(recordinId);
            ParkRecordinItem parkRecordinItem = this.parkRecordinService.getItemById(tempBillingItem.getRecordinId());
            weChatCharge.setParkingTime(ParkClientCommonUtil.getParkingTime(parkRecordinItem.getCheckInTime(), new Date()));
            if (this.parkParamsService.printParkLogger()) {
                log.info("PARK_ONLINE_PAY ===Recordin {} ===", (Object)parkRecordinItem);
            }
        } else {
            if (this.parkParamsService.printParkLogger()) {
                log.info("PARK_ONLINE_PAY == In Parking Payment");
            }
            ParkRecordinItem recordinItem = this.parkRecordinService.getItemById(recordinId);
            List<Short> statusList = Arrays.asList(ParkConstants.CAR_STATUS_IN, ParkConstants.CAR_STATUS_OUT_IF);
            List recordinAry = this.parkRecordinService.getByCheckinIdAndStatusIn(recordinId, statusList);
            if (Objects.nonNull(recordinItem) && statusList.contains(recordinItem.getStatus()) || CollectionUtils.isNotEmpty((Collection)recordinAry)) {
                if (this.parkParamsService.printParkLogger()) {
                    log.info("PARK_ONLINE_PAY == Start This Charge");
                }
                if (CollectionUtils.isNotEmpty((Collection)recordinAry)) {
                    ParkRecordinItem newRecordinItem = (ParkRecordinItem)recordinAry.get(0);
                    if (ParkConstants.EVENT_ONLINE_CHARGE.equals(newRecordinItem.getEventType())) {
                        ParkParkingMeterItem parkingMeter = this.parkingMeterService.getItemById(newRecordinItem.getParkingMeterId());
                        String recordinIdTemp = parkingMeter.getRecordinId();
                        this.parkRecordinService.deleteByIds(newRecordinItem.getId());
                        this.parkingMeterService.deleteByIds(parkingMeter.getId());
                        this.parkRecordoutService.deleteByIds(parkingMeter.getRecordoutId());
                        newRecordinItem = this.parkRecordinService.getItemById(recordinIdTemp);
                        newRecordinItem.setStatus(ParkConstants.CAR_STATUS_IN);
                        recordinItem = this.parkRecordinService.saveItem(newRecordinItem);
                    } else {
                        recordinItem = (ParkRecordinItem)recordinAry.get(0);
                    }
                }
                weChatCharge.setParkingTime(ParkClientCommonUtil.getParkingTime(recordinItem.getCheckInTime(), new Date()));
                this.parkRecordoutService.weChatCheckoutCharge(recordinItem, weChatCharge);
                if (this.parkParamsService.printParkLogger()) {
                    log.info("PARK_ONLINE_PAY == This Charge=={}", (Object)weChatCharge);
                }
            } else {
                weChatCharge.setFinalAmount(this.parkParamsService.getChargeOpen());
                weChatCharge.setChargeType("noRecordin");
                weChatCharge.setRecordinId(recordinId);
                if (this.parkParamsService.printParkLogger()) {
                    log.info("PARK_ONLINE_PAY == NoRecordin=={}", (Object)weChatCharge);
                }
            }
        }
        return new ZKResultMsg((Object)weChatCharge);
    }
}

