/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.client.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.client.utils.ParkClientCommonUtil;
import com.zkteco.zkbiosecurity.message.bean.ZKMessage;
import com.zkteco.zkbiosecurity.park.service.ParkPersonService;
import com.zkteco.zkbiosecurity.park.service.ParkRecordinService;
import com.zkteco.zkbiosecurity.park.service.ParkRecordinSideService;
import com.zkteco.zkbiosecurity.park.vo.ParkPersonItem;
import com.zkteco.zkbiosecurity.park.vo.ParkRecordinItem;
import com.zkteco.zkbiosecurity.park.vo.ParkRecordinSideItem;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ParkRecordinHandle {
    private static final Logger log = LoggerFactory.getLogger(ParkRecordinHandle.class);
    @Autowired
    private ParkRecordinService parkRecordinService;
    @Autowired
    private ParkRecordinSideService parkRecordinSideService;
    @Autowired
    private ParkPersonService parkPersonService;

    public ZKResultMsg getItemsByPage(ZKMessage msg) {
        log.info("PARK_CLOUD ParkRecordinHandle getItemsByPage msg = {}", (Object)msg);
        Map retMap = msg.getContent();
        int page = ParkClientCommonUtil.getIntValue(retMap, "page");
        int size = ParkClientCommonUtil.getIntValue(retMap, "size");
        JSONObject json = (JSONObject)retMap.get("parkCloudRecordinItem");
        ParkRecordinSideItem parkRecordinSideItem = (ParkRecordinSideItem)JSONObject.toJavaObject((JSON)json, ParkRecordinSideItem.class);
        Pager pager = this.parkRecordinSideService.getItemsByPage((BaseItem)parkRecordinSideItem, page, size);
        return new ZKResultMsg((Object)pager);
    }

    public ZKResultMsg getItemById(ZKMessage msg) {
        log.info("PARK_CLOUD ParkRecordinHandle getItemsByPage msg = {}", (Object)msg);
        Map retMap = msg.getContent();
        String id = ParkClientCommonUtil.getStringValue(retMap, "id");
        ParkRecordinItem parkRecordinItem = this.parkRecordinService.getItemById(id);
        return new ZKResultMsg((Object)parkRecordinItem);
    }

    public ZKResultMsg getItemsByFilter(ZKMessage msg) {
        log.info("PARK_CLOUD ParkRecordinHandle getItemsByFilter msg = {}", (Object)msg);
        Map retMap = msg.getContent();
        String pin = ParkClientCommonUtil.getStringValue(retMap, "pin");
        int page = ParkClientCommonUtil.getIntValue(retMap, "page");
        int size = ParkClientCommonUtil.getIntValue(retMap, "size");
        JSONObject json = (JSONObject)retMap.get("parkCloudRecordinItem");
        ParkRecordinSideItem parkRecordinSideItem = (ParkRecordinSideItem)JSONObject.toJavaObject((JSON)json, ParkRecordinSideItem.class);
        if (StringUtils.isNotBlank((CharSequence)pin)) {
            ParkPersonItem parkPersonItem = this.parkPersonService.getByPin(pin);
            if (Objects.nonNull(parkPersonItem)) {
                parkRecordinSideItem.setUserName(parkPersonItem.getPersPersonName());
            } else {
                return new ZKResultMsg(null);
            }
        }
        Pager pager = this.parkRecordinSideService.getItemsByPage((BaseItem)parkRecordinSideItem, page, size);
        return new ZKResultMsg((Object)pager);
    }

    public ZKResultMsg getPresentItemByFilter(ZKMessage msg) {
        log.info("PARK_CLOUD ParkRecordinHandle getPresentItemByFilter msg = {}", (Object)msg);
        Map retMap = msg.getContent();
        String pin = ParkClientCommonUtil.getStringValue(retMap, "pin");
        int page = ParkClientCommonUtil.getIntValue(retMap, "page");
        int size = ParkClientCommonUtil.getIntValue(retMap, "size");
        JSONObject json = (JSONObject)retMap.get("parkCloudRecordinItem");
        ParkRecordinItem parkRecordinItem = (ParkRecordinItem)JSONObject.toJavaObject((JSON)json, ParkRecordinItem.class);
        if (StringUtils.isNotBlank((CharSequence)pin)) {
            ParkPersonItem parkPersonItem = this.parkPersonService.getByPin(pin);
            if (Objects.nonNull(parkPersonItem)) {
                parkRecordinItem.setUserName(parkPersonItem.getPersPersonName());
            } else {
                return new ZKResultMsg(null);
            }
        }
        Pager pager = this.parkRecordinService.getItemsByPage((BaseItem)parkRecordinItem, page, size);
        return new ZKResultMsg((Object)pager);
    }
}

