/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.client.msg;

import com.zkteco.zkbiosecurity.license.service.BaseLicenseService;
import com.zkteco.zkbiosecurity.park.service.ParkCloudService;
import com.zkteco.zkbiosecurity.park.service.ParkParamsService;
import com.zkteco.zkbiosecurity.park.service.ParkParkingAreaService;
import com.zkteco.zkbiosecurity.park.vo.ParkParkingRemainingSpacesItem;
import com.zkteco.zkbiosecurity.scheduler.ScheduleService;
import java.util.concurrent.ScheduledFuture;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=2021)
public class ParkClientSendDataCloud
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(ParkClientSendDataCloud.class);
    private ScheduledFuture<?> scedulefuture;
    @Autowired
    private ParkParkingAreaService parkParkingAreaService;
    @Autowired
    private ParkCloudService parkCloudService;
    @Autowired
    private ParkParamsService parkParamsService;
    @Autowired
    private ScheduleService scheduleService;
    @Autowired(required=false)
    private BaseLicenseService baseLicenseService;

    public void run(String ... args) throws Exception {
        this.startSendParkingLotMsgTask();
    }

    private void startSendParkingLotMsgTask() {
        log.info("ParkParkingRemainingSpaces Start ... ");
        if (this.scedulefuture != null) {
            this.scedulefuture.cancel(true);
        }
        this.scedulefuture = this.scheduleService.startScheduleTask(() -> {
            String appId = this.baseLicenseService.getAppId();
            if (this.parkParamsService.isSyncDataToCloud() && StringUtils.isNotBlank((CharSequence)appId)) {
                ParkParkingRemainingSpacesItem parkParkingRemainingSpacesItem = this.parkParkingAreaService.parkingAreaAllSpaceNumber();
                this.parkCloudService.sendParkingRemainingSpace(parkParkingRemainingSpacesItem);
            }
        }, "0 0/30 * * * ?");
    }
}

