/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.client.msg;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.license.service.BaseLicenseService;
import com.zkteco.zkbiosecurity.park.constants.ParkConstants;
import com.zkteco.zkbiosecurity.park.service.ParkAuthorizeService;
import com.zkteco.zkbiosecurity.park.service.ParkParamsService;
import com.zkteco.zkbiosecurity.park.service.ParkPersonService;
import com.zkteco.zkbiosecurity.park.service.ParkRecordinService;
import com.zkteco.zkbiosecurity.park.vo.ParkAuthorizeItem;
import com.zkteco.zkbiosecurity.park.vo.ParkPersonItem;
import com.zkteco.zkbiosecurity.park.vo.ParkRecordinItem;
import com.zkteco.zkbiosecurity.scheduler.ScheduleService;
import com.zkteco.zkbiosecurity.system.service.BaseMessageService;
import com.zkteco.zkbiosecurity.system.vo.BaseMessageItem;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=87)
public class ParkClientMsg
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(ParkClientMsg.class);
    @Autowired
    private ScheduleService scheduleService;
    private ScheduledFuture<?> scedulefuture;
    @Autowired
    private ParkRecordinService parkRecordinService;
    @Autowired
    private ParkAuthorizeService parkAuthorizeService;
    @Autowired
    private ParkPersonService parkPersonService;
    @Autowired
    private ParkParamsService parkParamsService;
    @Autowired(required=false)
    private BaseLicenseService baseLicenseService;
    @Autowired(required=false)
    private BaseMessageService baseMessageService;

    public void run(String ... strings) throws Exception {
        this.startTask();
    }

    public void startTask() {
        if (this.scedulefuture != null) {
            this.scedulefuture.cancel(true);
        }
        this.scedulefuture = this.scheduleService.startScheduleTask(() -> this.authAndRecordinMsg(), "0 0 1 * * ?");
    }

    private void authAndRecordinMsg() {
        log.info("PARK_CLOUD authAndRecordinMsg start ... ");
        String appId = this.baseLicenseService.getAppId();
        if (this.parkParamsService.isSyncDataToCloud() && StringUtils.isNotBlank((CharSequence)appId)) {
            Date delayDateEnd;
            ParkAuthorizeItem parkAuthorizeItem = new ParkAuthorizeItem();
            parkAuthorizeItem.setStatus(Short.valueOf((short)1));
            int fixedCarWarningDay = this.parkParamsService.getFixedCarWarningDay();
            Date delayDate = DateUtil.getDateAfter((Date)new Date(), (int)fixedCarWarningDay);
            parkAuthorizeItem.setCarTypeType(ParkConstants.CAR_TYPE_FIX);
            parkAuthorizeItem.setEndTimeLessEqual(delayDate);
            List parkCloudAuthorizeItemList = this.parkAuthorizeService.getByCondition(parkAuthorizeItem);
            if (CollectionUtils.isNotEmpty((Collection)parkCloudAuthorizeItemList)) {
                for (ParkAuthorizeItem item : parkCloudAuthorizeItemList) {
                    BaseMessageItem baseMessageItem = new BaseMessageItem();
                    baseMessageItem.setType("RemindMsg");
                    baseMessageItem.setBusinessId(item.getId());
                    baseMessageItem.setBusinessCode("ParkDelayNotify");
                    baseMessageItem.setReceiverId(item.getPersPersonPin());
                    baseMessageItem.setRemindTime(new Date());
                    baseMessageItem.setStatus("0");
                    baseMessageItem.setTitle("\u8f66\u8f86\u5ef6\u671f\u63d0\u9192");
                    baseMessageItem.setContent(item.getCarNumber());
                    this.baseMessageService.saveAndSendToCloud(baseMessageItem);
                }
            }
            ParkRecordinItem parkRecordinItem = new ParkRecordinItem();
            parkRecordinItem.setStatus(ParkConstants.CAR_STATUS_IN);
            String dayOrHour = this.parkParamsService.getDayOrHour();
            int longTime = this.parkParamsService.getNotAppearDay();
            if ("day".equals(dayOrHour)) {
                delayDateEnd = DateUtil.getDateBefore((Date)new Date(), (int)longTime);
                parkRecordinItem.setTimeEnd(delayDateEnd);
            } else {
                delayDateEnd = DateUtil.addHour((Date)new Date(), (int)(-longTime));
                parkRecordinItem.setTimeEnd(delayDateEnd);
            }
            List parkRecordinItemList = this.parkRecordinService.getByCondition(parkRecordinItem);
            if (parkRecordinItemList != null && !parkRecordinItemList.isEmpty()) {
                for (ParkRecordinItem item : parkRecordinItemList) {
                    ParkPersonItem parkPersonItem = this.parkPersonService.getByCarNumber(item.getCarNumber());
                    if (parkPersonItem == null) continue;
                    JSONObject extendJson = new JSONObject();
                    String personInfo = "";
                    BaseMessageItem baseMessageItem = new BaseMessageItem();
                    baseMessageItem.setType("WarnMsg");
                    baseMessageItem.setBusinessCode("ParkOvertimeWarn");
                    baseMessageItem.setStatus("0");
                    baseMessageItem.setTitle("\u8f66\u8f86\u505c\u7559\u8d85\u65f6\u62a5\u8b66");
                    baseMessageItem.setReceiverId(parkPersonItem.getPersPersonPin());
                    personInfo = String.format("%s(%s)", parkPersonItem.getPersPersonName(), parkPersonItem.getPersPersonPin());
                    baseMessageItem.setRemindTime(new Date());
                    extendJson.put("personInfo", (Object)personInfo);
                    extendJson.put("warnType", (Object)"1000");
                    extendJson.put("warnContent1", (Object)item.getCarNumber());
                    extendJson.put("warnContent2", (Object)DateUtil.dateToString((Date)item.getCheckInTime(), (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD_HH_MM_SS));
                    baseMessageItem.setExtendJson(extendJson.toJSONString());
                    this.baseMessageService.saveAndSendToCloud(baseMessageItem);
                }
            }
        }
        log.info("PARK_CLOUD authAndRecordinMsg end ... ");
    }
}

