/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.init;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.acc.service.AccDSTimeService;
import com.zkteco.zkbiosecurity.acc.service.AccLevelService;
import com.zkteco.zkbiosecurity.acc.service.AccSupportFuncService;
import com.zkteco.zkbiosecurity.acc.service.AccTimeSegService;
import com.zkteco.zkbiosecurity.acc.vo.AccDSTimeItem;
import com.zkteco.zkbiosecurity.acc.vo.AccLevelItem;
import com.zkteco.zkbiosecurity.acc.vo.AccTimeSegItem;
import com.zkteco.zkbiosecurity.auth.service.AuthAreaService;
import com.zkteco.zkbiosecurity.auth.service.AuthPermissionService;
import com.zkteco.zkbiosecurity.auth.vo.AuthAreaItem;
import com.zkteco.zkbiosecurity.auth.vo.AuthPermissionItem;
import com.zkteco.zkbiosecurity.base.utils.VersionUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.system.service.BaseSysParamService;
import com.zkteco.zkbiosecurity.system.vo.BaseSysParamItem;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=30)
public class AccInit
implements CommandLineRunner {
    @Autowired
    private AuthPermissionService authPermissionService;
    @Autowired
    private AccTimeSegService accTimeSegService;
    @Autowired
    private AccDSTimeService accDSTimeService;
    @Autowired
    private AccLevelService accLevelService;
    @Autowired
    private BaseSysParamService baseSysParamService;
    @Autowired
    private AuthAreaService authAreaService;
    @Autowired
    private AccSupportFuncService accSupportFuncService;
    @Value(value="${system.language}")
    private String language;
    @Value(value="${system.isCloud:false}")
    private Boolean isCloud;

    public void run(String ... args) throws Exception {
        boolean alreadyInit = this.baseSysParamService.getAlreadyInitModule("AccInit");
        if (!alreadyInit) {
            this.initAuthPermission();
            this.initAccParams();
            this.initAccDSTime();
            this.initAccTimeSeg();
            this.initAccLevel();
            if (!"zh_CN".equals(this.language) && !this.isCloud.booleanValue()) {
                this.initAppMenus();
            }
            this.initUpgradeVersion();
            this.baseSysParamService.setAlreadyInitModule("AccInit");
        }
    }

    private void initAuthPermission() {
        AuthPermissionItem systemItem = null;
        AuthPermissionItem topMenuItem = null;
        AuthPermissionItem subMenuItem = null;
        AuthPermissionItem subButtonItem = null;
        systemItem = new AuthPermissionItem("Acc", "acc_module", "acc", "system", "true", Integer.valueOf(3));
        systemItem = this.authPermissionService.initData(systemItem);
        topMenuItem = new AuthPermissionItem("AccDeviceManager", "acc_leftMenu_accDev", "acc:device:manager", "menu", "true", Integer.valueOf(1));
        topMenuItem.setParentId(systemItem.getId());
        topMenuItem.setImg("acc_device.png");
        topMenuItem.setImgHover("acc_device_over.png");
        topMenuItem = this.authPermissionService.initData(topMenuItem);
        subMenuItem = new AuthPermissionItem("AccDevice", "common_leftMenu_device", "acc:device", "menu", "true", Integer.valueOf(1));
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("accDevice.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("AccDeviceRefresh", "common_op_refresh", "acc:device:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccDeviceAdd", "common_op_new", "acc:device:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccDeviceEdit", "common_op_edit", "acc:device:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccDeviceDel", "common_op_del", "acc:device:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccDeviceExport", "common_op_export", "acc:device:export", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccDeviceSearchDev", "common_dev_searchDev", "acc:device:searchDev", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccDeviceEnable", "common_enable", "acc:device:enable", "button", "true", Integer.valueOf(7));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccDeviceDisable", "common_disable", "acc:device:disable", "button", "true", Integer.valueOf(8));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccDeviceSyncAllData", "common_dev_syncAllDataToDev", "acc:device:syncAllData", "button", "true", Integer.valueOf(9));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccDeviceUpgradeFirmware", "common_dev_upgradeFirmware", "acc:device:upgradeFirmware", "button", "true", Integer.valueOf(10));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccDeviceRebootDevice", "common_dev_reboot", "acc:device:rebootDevice", "button", "true", Integer.valueOf(11));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccDeviceGetOptFromDev", "common_dev_getDevOpt", "acc:device:getOptFromDev", "button", "true", Integer.valueOf(12));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccDeviceUploadPersonInfo", "common_dev_getPersonInfo", "acc:device:uploadPersonInfo", "button", "true", Integer.valueOf(13));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccDeviceUploadTransaction", "common_dev_getTrans", "acc:device:uploadTransaction", "button", "true", Integer.valueOf(14));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccDeviceSyncTime", "common_dev_syncTime", "acc:device:syncTime", "button", "true", Integer.valueOf(15));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccDeviceIssueBGVerifyParam", "acc_dev_issueVerifyParam", "acc:device:issueBGVerifyParam", "button", "true", Integer.valueOf(16));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccDeviceSetTimeZone", "acc_dev_setTimeZone", "acc:device:setTimeZone", "button", "true", Integer.valueOf(17));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccDeviceSetRegistrationDevice", "acc_dev_setRegistrationDevice", "acc:device:setRegistrationDevice", "button", "true", Integer.valueOf(18));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccDeviceUpdateIpAddr", "common_dev_modifyIPAddress", "acc:device:updateIpAddr", "button", "true", Integer.valueOf(20));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccDeviceUpdateCommPwd", "common_dev_modifyCommPwd", "acc:device:updateCommPwd", "button", "true", Integer.valueOf(21));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccDeviceUpdateMThreshold", "common_dev_modifyFPThreshold", "acc:device:updateMThreshold", "button", "true", Integer.valueOf(23));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccDeviceUpdateNetConnectMode", "acc_dev_updateNetConnectMode", "acc:device:updateNetConnectMode", "button", "true", Integer.valueOf(24));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccDeviceQueryDevRule", "acc_dev_accessRules", "acc:device:queryDevRule", "button", "true", Integer.valueOf(25));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccDeviceQueryDevUsage", "acc_dev_queryDevVolume", "acc:device:queryDevUsage", "button", "true", Integer.valueOf(26));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccDeviceAddChildDevice", "acc_dev_addChildDevice", "acc:device:addChildDevice", "button", "true", Integer.valueOf(27));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccDeviceModParentDevice", "acc_dev_modParentDevice", "acc:device:modParentDevice", "button", "true", Integer.valueOf(28));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccDeviceConfigParentDevice", "acc_dev_configParentDevice", "acc:device:configParentDevice", "button", "true", Integer.valueOf(29));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccDeviceClearAdministrator", "acc_dev_clearAdmin", "acc:device:clearAdministrator", "button", "true", Integer.valueOf(30));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccDeviceSetExtendParam", "acc_dev_setExtendParam", "acc:device:updateDevExtendParam", "button", "true", Integer.valueOf(33));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        if (!"zh_CN".equals(this.language)) {
            subButtonItem = new AuthPermissionItem("AccDeviceSetIntercomServer", "acc_dev_setIntercomServer", "acc:device:setIntercomServer", "button", "true", Integer.valueOf(34));
            subButtonItem.setParentId(subMenuItem.getId());
            this.authPermissionService.initData(subButtonItem);
        }
        subButtonItem = new AuthPermissionItem("AccDeviceSetNTP", "acc_device_setNTPService", "acc:device:setDevNTP", "button", "true", Integer.valueOf(35));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccDeviceExchange", "acc_dev_replace", "acc:device:replace", "button", "true", Integer.valueOf(36));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccDeviceClearCmd", "common_devMonitor_clearCmdCache", "acc:device:clearCmdCache", "button", "true", Integer.valueOf(37));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("AccExtDevice", "acc_leftMenu_extDev", "acc:extDevice", "menu", "true", Integer.valueOf(2));
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("accExtDevice.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("AccExtDeviceRefresh", "common_op_refresh", "acc:extDevice:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccExtDeviceAdd", "common_op_new", "acc:extDevice:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccExtDeviceEdit", "common_op_edit", "acc:extDevice:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccExtDeviceDel", "common_op_del", "acc:extDevice:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("AccDoor", "acc_leftMenu_door", "acc:door", "menu", "true", Integer.valueOf(3));
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("accDoor.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("AccDoorRefresh", "common_op_refresh", "acc:door:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccDoorEdit", "common_op_edit", "acc:door:edit", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccDoorOpenDoor", "acc_eventNo_8", "acc:door:openDoor", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccDoorCloseDoor", "acc_eventNo_9", "acc:door:closeDoor", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccDoorEnable", "common_enable", "acc:door:enable", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccDoorDisable", "common_disable", "acc:door:disable", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccDoorCancelAlarm", "acc_eventNo_7", "acc:door:cancelAlarm", "button", "true", Integer.valueOf(7));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccDoorNormalOpenDoor", "acc_rtMonitor_remoteNormalOpen", "acc:door:normalOpenDoor", "button", "true", Integer.valueOf(8));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccDoorLockDoor", "acc_newEventNo_233", "acc:door:lockDoor", "button", "true", Integer.valueOf(9));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccDoorUnLockDoor", "acc_newEventNo_234", "acc:door:unLockDoor", "button", "true", Integer.valueOf(10));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccDoorEnableNormalOpenDoor", "common_rtMonitor_enableIntradayTZ", "acc:door:enableNormalOpenDoor", "button", "true", Integer.valueOf(11));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccDoorDisableNormalOpenDoor", "common_rtMonitor_disableIntradayTZ", "acc:door:disableNormalOpenDoor", "button", "true", Integer.valueOf(12));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("AccReader", "common_leftMenu_reader", "acc:reader", "menu", "true", Integer.valueOf(4));
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("accReader.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("AccReaderRefresh", "common_op_refresh", "acc:reader:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccReaderEdit", "common_op_edit", "acc:reader:edit", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccReaderBindChannel", "common_vid_bindOrUnbindChannel", "acc:reader:bindChannel", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("AccAuxIn", "common_leftMenu_auxIn", "acc:auxIn", "menu", "true", Integer.valueOf(5));
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("accAuxIn.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("AccAuxInRefresh", "common_op_refresh", "acc:auxIn:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccAuxInEdit", "common_op_edit", "acc:auxIn:edit", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccAuxInBindChannel", "common_vid_bindOrUnbindChannel", "acc:auxIn:bindChannel", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("AccAuxOut", "acc_leftMenu_auxOut", "acc:auxOut", "menu", "true", Integer.valueOf(6));
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("accAuxOut.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("AccAuxOutRefresh", "common_op_refresh", "acc:auxOut:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccAuxOutEdit", "common_op_edit", "acc:auxOut:edit", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccAuxOutOpenAuxOut", "acc_rtMonitor_remoteOpen", "acc:auxOut:openAuxOut", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccAuxOutCloseAuxOut", "acc_rtMonitor_remoteClose", "acc:auxOut:closeAuxOut", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccAuxOutNormalOpen", "acc_rtMonitor_remoteNormalOpen", "acc:auxOut:normalOpen", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("AccDeviceEvent", "common_leftMenu_event", "acc:deviceEvent", "menu", "true", Integer.valueOf(7));
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("accDeviceEvent.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("AccDeviceEventRefresh", "common_op_refresh", "acc:deviceEvent:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccDeviceEventEdit", "common_op_edit", "acc:deviceEvent:edit", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccDeviceEventSetSound", "acc_deviceEvent_batchSet", "acc:deviceEvent:setSound", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("AccDSTime", "acc_leftMenu_dSTime", "acc:dSTime", "menu", "true", Integer.valueOf(8));
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("accDSTime.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("AccDSTimeRefresh", "common_op_refresh", "acc:dSTime:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccDSTimeAdd", "common_op_new", "acc:dSTime:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccDSTimeEdit", "common_op_edit", "acc:dSTime:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccDSTimeDel", "common_op_del", "acc:dSTime:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("AccRTMonitor", "common_leftMenu_rtMonitor", "acc:rtMonitor", "menu", "true", Integer.valueOf(10));
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("accRTMonitor.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("AccRTMonitorBrowse", "common_op_browse", "acc:rtMonitor:browse", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccRTMonitorOpenDoor", "acc_eventNo_8", "acc:rtMonitor:openDoor", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccRTMonitorCloseDoor", "acc_eventNo_9", "acc:rtMonitor:closeDoor", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccRTMonitorCancelAlarm", "acc_eventNo_7", "acc:rtMonitor:cancelAlarm", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccRTMonitorLockDoor", "acc_newEventNo_233", "acc:rtMonitor:lockDoor", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccRTMonitorUnLockDoor", "acc_newEventNo_234", "acc:rtMonitor:unLockDoor", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccRTMonitorNormalOpenDoor", "acc_rtMonitor_remoteNormalOpen", "acc:rtMonitor:normalOpenDoor", "button", "true", Integer.valueOf(7));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccRTMonitorLcdRTMonitor", "acc_leftMenu_LCDRTMonitor", "acc:rtMonitor:lcdRTMonitor", "button", "true", Integer.valueOf(8));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccRTMonitorEnableNormalOpenDoor", "common_rtMonitor_enableIntradayTZ", "acc:rtMonitor:enableNormalOpenDoor", "button", "true", Integer.valueOf(9));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccRTMonitorDisableNormalOpenDoor", "common_rtMonitor_disableIntradayTZ", "acc:rtMonitor:disableNormalOpenDoor", "button", "true", Integer.valueOf(10));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccRTMonitorTransactionTodayHappen", "acc_doorEventLatestHappen", "acc:rtMonitor:transactionTodayHappen", "button", "true", Integer.valueOf(11));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccRTMonitorOpenAuxOut", "acc_rtMonitor_remoteOpen", "acc:rtMonitor:openAuxOut", "button", "true", Integer.valueOf(12));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccRTMonitorCloseAuxOut", "acc_rtMonitor_remoteClose", "acc:rtMonitor:closeAuxOut", "button", "true", Integer.valueOf(13));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccRTMonitorAuxOutNormalOpen", "acc_rtMonitor_remoteNormalOpen", "acc:rtMonitor:auxOutNormalOpen", "button", "true", Integer.valueOf(14));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccRTMonitorLiveView", "system_module_videoPreview", "acc:rtMonitor:liveView", "button", "true", Integer.valueOf(15));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("AccAlarmMonitor", "acc_rtMonitor_alarmMonitor", "acc:alarmMonitor", "menu", "true", Integer.valueOf(10));
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("accAlarmMonitor.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("AccAlarmMonitorAckAlarm", "acc_rtMonitor_ackAlarm", "acc:alarmMonitor:ackAlarm", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccAlarmMonitorHistory", "acc_alarm_history", "acc:alarmMonitor:history", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("AccMap", "acc_leftMenu_electronicMap", "acc:map", "menu", "true", Integer.valueOf(11));
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("accMap.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("AccMapRefresh", "common_op_refresh", "acc:map:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccMapAdd", "common_op_new", "acc:map:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccMapEdit", "common_op_edit", "acc:map:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccMapDel", "common_op_del", "acc:map:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccMapSaveMapPos", "common_op_savePositon", "acc:map:saveMapPos", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccMapAddDoorToMap", "acc_map_addDoor", "acc:map:addDoorToMap", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccMapAddChannelToMap", "acc_map_addChannel", "acc:map:addChannelToMap", "button", "true", Integer.valueOf(7));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccMapDelEntity", "base_map_delEntity", "acc:map:delEntity", "button", "true", Integer.valueOf(8));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        topMenuItem = new AuthPermissionItem("AccAccessManager", "acc_leftMenu_accRule", "acc:access:manager", "menu", "true", Integer.valueOf(2));
        topMenuItem.setParentId(systemItem.getId());
        topMenuItem.setImg("acc_control.png");
        topMenuItem.setImgHover("acc_control_over.png");
        topMenuItem = this.authPermissionService.initData(topMenuItem);
        subMenuItem = new AuthPermissionItem("AccTimeSeg", "common_leftMenu_timeZone", "acc:timeSeg", "menu", "true", Integer.valueOf(1));
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("accTimeSeg.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("AccTimeSegRefresh", "common_op_refresh", "acc:timeSeg:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccTimeSegAdd", "common_op_new", "acc:timeSeg:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccTimeSegEdit", "common_op_edit", "acc:timeSeg:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccTimeSegDel", "common_op_del", "acc:timeSeg:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("AccHoliday", "common_leftMenu_holiday", "acc:holiday", "menu", "true", Integer.valueOf(2));
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("accHoliday.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("AccHolidayRefresh", "common_op_refresh", "acc:holiday:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccHolidayAdd", "common_op_new", "acc:holiday:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccHolidayEdit", "common_op_edit", "acc:holiday:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccHolidayDel", "common_op_del", "acc:holiday:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("AccLevel", "acc_leftMenu_level", "acc:level", "menu", "true", Integer.valueOf(3));
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("accLevel.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("AccLevelRefresh", "common_op_refresh", "acc:level:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccLevelAdd", "common_op_new", "acc:level:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccLevelEdit", "common_op_edit", "acc:level:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccLevelDel", "common_op_del", "acc:level:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccLevelOpenDoor", "acc_eventNo_8", "acc:level:openDoor", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccLevelCloseDoor", "acc_eventNo_9", "acc:level:closeDoor", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccLevelCancelAlarmDoor", "acc_eventNo_7", "acc:level:cancelAlarmDoor", "button", "true", Integer.valueOf(7));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccLevelNormalOpenDoor", "acc_rtMonitor_remoteNormalOpen", "acc:level:normalOpenDoor", "button", "true", Integer.valueOf(8));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccLevelLockDoor", "acc_newEventNo_233", "acc:level:lockDoor", "button", "true", Integer.valueOf(11));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccLevelUnLockDoor", "acc_newEventNo_234", "acc:level:unLockDoor", "button", "true", Integer.valueOf(12));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccLevelEnableNormalOpenDoor", "common_rtMonitor_enableIntradayTZ", "acc:level:enableNormalOpenDoor", "button", "true", Integer.valueOf(13));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccLevelDisableNormalOpenDoor", "common_rtMonitor_disableIntradayTZ", "acc:level:disableNormalOpenDoor", "button", "true", Integer.valueOf(14));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccLevelAddDoor", "acc_map_addDoor", "acc:level:addDoor", "button", "true", Integer.valueOf(15));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccLevelDelDoor", "acc_level_doorDelete", "acc:level:delDoor", "button", "true", Integer.valueOf(16));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccLevelExport", "acc_level_exportLevel", "acc:level:export", "button", "true", Integer.valueOf(17));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccLevelDoorExport", "acc_level_exportLevelDoor", "acc:levelDoor:export", "button", "true", Integer.valueOf(18));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccLevelImport", "acc_level_importLevel", "acc:level:import", "button", "true", Integer.valueOf(19));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccLevelDoorImport", "acc_level_importLevelDoor", "acc:levelDoor:import", "button", "true", Integer.valueOf(20));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("AccPersonLevelByLevel", "common_leftMenu_levelSetByLevel", "acc:personLevelByLevel", "menu", "true", Integer.valueOf(4));
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("accPersonLevelByLevel.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("AccPersonLevelByLevelRefresh", "common_op_refresh", "acc:personLevelByLevel:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccPersonLevelByLevelAddPerson", "pers_common_addPerson", "acc:personLevelByLevel:addPerson", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccPersonLevelByLevelDelPerson", "pers_common_delPerson", "acc:personLevelByLevel:delPerson", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccPersonLevelByLevelExport", "acc_level_exportLevelPerson", "acc:personLevelByLevel:export", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccPersonLevelByLevelImport", "acc_level_importLevelPerson", "acc:personLevelByLevel:import", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("AccPersonLevelByPerson", "common_leftMenu_levelSetByPerson", "acc:personLevelByPerson", "menu", "true", Integer.valueOf(5));
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("accPersonLevelByPerson.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("AccPersonLevelByPersonRefresh", "common_op_refresh", "acc:personLevelByPerson:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccPersonLevelByPersonSetAccParams", "pers_person_accSetting", "acc:personLevelByPerson:setAccParams", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccPersonLevelByPersonAddLevel", "common_level_addPersonLevel", "acc:personLevelByPerson:addLevel", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccPersonLevelByPersonDelLevel", "common_level_delPersonLevel", "acc:personLevelByPerson:delLevel", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccPersonLevelByPersonExport", "common_op_export", "acc:personLevelByPerson:export", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccPersonLevelByPersonSync", "acc_personLevelByPerson_syncLevel", "acc:personLevelByPerson:sync", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("AccInterlock", "acc_leftMenu_interlock", "acc:interlock", "menu", "true", Integer.valueOf(7));
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("accInterlock.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("AccInterlockRefresh", "common_op_refresh", "acc:interlock:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccInterlockAdd", "common_op_new", "acc:interlock:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccInterlockEdit", "common_op_edit", "acc:interlock:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccInterlockDel", "common_op_del", "acc:interlock:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("AccLinkage", "common_leftMenu_linkage", "acc:linkage", "menu", "true", Integer.valueOf(8));
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("accLinkage.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("AccLinkageRefresh", "common_op_refresh", "acc:linkage:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccLinkageAdd", "common_op_new", "acc:linkage:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccLinkageEdit", "common_op_edit", "acc:linkage:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccLinkageDel", "common_op_del", "acc:linkage:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("AccAntiPassback", "acc_leftMenu_antiPassback", "acc:antiPassback", "menu", "true", Integer.valueOf(9));
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("accAntiPassback.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("AccAntiPassbackRefresh", "common_op_refresh", "acc:antiPassback:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccAntiPassbackAdd", "common_op_new", "acc:antiPassback:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccAntiPassbackEdit", "common_op_edit", "acc:antiPassback:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccAntiPassbackDel", "common_op_del", "acc:antiPassback:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("AccFirstOpen", "acc_leftMenu_firstOpen", "acc:firstOpen", "menu", "true", Integer.valueOf(10));
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("accFirstOpen.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("AccFirstOpenRefresh", "common_op_refresh", "acc:firstOpen:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccFirstOpenAdd", "common_op_new", "acc:firstOpen:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccFirstOpenEdit", "common_op_edit", "acc:firstOpen:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccFirstOpenDel", "common_op_del", "acc:firstOpen:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccFirstOpenAddPerson", "pers_common_addPerson", "acc:firstOpen:addPerson", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccFirstOpenDelPerson", "pers_common_delPerson", "acc:firstOpen:delPerson", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("AccCombOpenPerson", "acc_leftMenu_personGroup", "acc:combOpenPerson", "menu", "true", Integer.valueOf(11));
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("accCombOpenPerson.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("AccCombOpenPersonRefresh", "common_op_refresh", "acc:combOpenPerson:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccCombOpenPersonAdd", "common_op_new", "acc:combOpenPerson:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccCombOpenPersonEdit", "common_op_edit", "acc:combOpenPerson:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccCombOpenPersonDel", "common_op_del", "acc:combOpenPerson:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccCombOpenPersonAddPerson", "pers_common_addPerson", "acc:combOpenPerson:addPerson", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccCombOpenPersonDelPerson", "pers_common_delPerson", "acc:combOpenPerson:delPerson", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("AccCombOpenDoor", "acc_leftMenu_combOpen", "acc:combOpenDoor", "menu", "true", Integer.valueOf(12));
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("accCombOpenDoor.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("AccCombOpenDoorRefresh", "common_op_refresh", "acc:combOpenDoor:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccCombOpenDoorAdd", "common_op_new", "acc:combOpenDoor:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccCombOpenDoorEdit", "common_op_edit", "acc:combOpenDoor:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccCombOpenDoorDel", "common_op_del", "acc:combOpenDoor:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("AccVerifyModeRule", "acc_leftMenu_verifyModeRule", "acc:verifyModeRule", "menu", "true", Integer.valueOf(13));
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("accVerifyModeRule.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("AccVerifyModeRuleRefresh", "common_op_refresh", "acc:verifyModeRule:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccVerifyModeRuleAdd", "common_op_new", "acc:verifyModeRule:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccVerifyModeRuleEdit", "common_op_edit", "acc:verifyModeRule:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccVerifyModeRuleDel", "common_op_del", "acc:verifyModeRule:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccVerifyModeRuleAddDoor", "acc_map_addDoor", "acc:verifyModeRule:addDoor", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccVerifyModeRuleDelDoor", "acc_level_doorDelete", "acc:verifyModeRule:delDoor", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("AccVerifyModeRulePersonGroup", "acc_leftMenu_verifyModeRulePersonGroup", "acc:verifyModeRulePersonGroup", "menu", "true", Integer.valueOf(14));
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("accVerifyModeRulePersonGroup.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("AccVerifyModeRulePersonGroupRefresh", "common_op_refresh", "acc:verifyModeRulePersonGroup:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccVerifyModeRulePersonGroupAddPerson", "pers_common_addPerson", "acc:verifyModeRulePersonGroup:addPerson", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccVerifyModeRulePersonGroupDelPerson", "pers_common_delPerson", "acc:verifyModeRulePersonGroup:delPerson", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("AccParam", "common_leftMenu_paramSet", "acc:param", "menu", "true", Integer.valueOf(15));
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("accParam.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("AccParamRefresh", "common_op_refresh", "acc:param:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccParamEdit", "common_op_edit", "acc:param:edit", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        topMenuItem = new AuthPermissionItem("AccReports", "acc_leftMenu_accReports", "acc:transaction:manager", "menu", "true", Integer.valueOf(4));
        topMenuItem.setParentId(systemItem.getId());
        topMenuItem.setImg("comm_reports.png");
        topMenuItem.setImgHover("comm_reports_over.png");
        topMenuItem = this.authPermissionService.initData(topMenuItem);
        subMenuItem = new AuthPermissionItem("AccTransaction", "common_leftMenu_transaction", "acc:transaction", "menu", "true", Integer.valueOf(1));
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("accTransaction.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("AccTransactionRefresh", "common_op_refresh", "acc:transaction:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccTransactionDel", "common_op_clearData", "acc:transaction:del", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccTransactionExport", "common_op_export", "acc:transaction:export", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccTransactionExportPhoto", "acc_trans_exportPhoto", "acc:transaction:exportPhoto", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("AccTransactionToday", "acc_trans_today", "acc:transactionToday", "menu", "true", Integer.valueOf(2));
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("accTransactionToday.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("AccTransactionTodayRefresh", "common_op_refresh", "acc:transactionToday:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccTransactionTodayDel", "common_op_clearData", "acc:transactionToday:del", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccTransactionTodayExport", "common_op_export", "acc:transactionToday:export", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("AccAlarmTransaction", "common_leftMenu_exceptTransaction", "acc:alarmTransaction", "menu", "true", Integer.valueOf(4));
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("accAlarmTransaction.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("AccAlarmTransactionRefresh", "common_op_refresh", "acc:alarmTransaction:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccAlarmTransactionDel", "common_op_del", "acc:alarmTransaction:del", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccAlarmTransactionExport", "common_op_export", "acc:alarmTransaction:export", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("AccAlarmReport", "acc_alarm_list", "acc:alarmReport", "menu", "true", Integer.valueOf(5));
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("accAlarmMonitorReport.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("AccAlarmReportRefresh", "common_op_refresh", "acc:alarmReport:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccAlarmReportExport", "common_op_export", "acc:alarmReport:export", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("AccAlarmHistory", "acc_alarm_history", "acc:alarmHistory", "menu", "true", Integer.valueOf(6));
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("accAlarmMonitor.do?history");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("AccAlarmHistoryRefresh", "common_op_refresh", "acc:alarmHistory:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccAlarmHistoryExport", "common_op_export", "acc:alarmHistory:export", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("AccTransactionByDoor", "acc_leftMenu_searchByDoor", "acc:transactionByDoor", "menu", "true", Integer.valueOf(7));
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("accTransactionByDoor.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("AccTransactionByDoorRefresh", "common_op_refresh", "acc:transactionByDoor:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccTransactionByDoorExport", "common_op_export", "acc:transactionByDoor:export", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("AccTransactionByPerson", "common_leftMenu_searchByPerson", "acc:transactionByPerson", "menu", "true", Integer.valueOf(8));
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("accTransactionByPerson.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("AccTransactionByPersonRefresh", "common_op_refresh", "acc:transactionByPerson:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccTransactionByPersonExport", "common_op_export", "acc:transactionByPerson:export", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = this.authPermissionService.getItemByCode("PersPerson");
        if (subMenuItem != null) {
            subButtonItem = new AuthPermissionItem("PersPersonAccEdit", "pers_person_accSet", "pers:person:accEdit", "button", "true", Integer.valueOf(100));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
        }
        subMenuItem = new AuthPermissionItem("AccFirstInLastOut", "acc_leftMenu_firstInLastOut", "acc:firstInLastOut", "menu", "true", Integer.valueOf(9));
        subMenuItem.setParentId(topMenuItem.getId());
        subMenuItem.setActionLink("accFirstInLastOut.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("AccFirstInLastOutRefresh", "common_op_refresh", "acc:firstInLastOut:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccFirstInLastOutClearData", "common_op_clearData", "acc:firstInLastOut:clearData", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("AccFirstInLastOutExport", "common_op_export", "acc:firstInLastOut:export", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
    }

    private void initAccTimeSeg() {
        AccTimeSegItem timeSegItem = new AccTimeSegItem(I18nUtil.i18nCode((String)"common_timeSeg_24HoursAccess", (Object[])new Object[0]), I18nUtil.i18nCode((String)"common_timeSeg_24HoursAccess", (Object[])new Object[0]), Boolean.valueOf(true), "00:00", "23:59", "00:00", "00:00", "00:00", "00:00", "00:00", "23:59", "00:00", "00:00", "00:00", "00:00", "00:00", "23:59", "00:00", "00:00", "00:00", "00:00", "00:00", "23:59", "00:00", "00:00", "00:00", "00:00", "00:00", "23:59", "00:00", "00:00", "00:00", "00:00", "00:00", "23:59", "00:00", "00:00", "00:00", "00:00", "00:00", "23:59", "00:00", "00:00", "00:00", "00:00", "00:00", "23:59", "00:00", "00:00", "00:00", "00:00", "00:00", "23:59", "00:00", "00:00", "00:00", "00:00", "00:00", "23:59", "00:00", "00:00", "00:00", "00:00");
        this.accTimeSegService.initData(timeSegItem);
    }

    private void initAccDSTime() {
        AccDSTimeItem accDSTimeItem = new AccDSTimeItem("acc_dsTimeUtc1000_0", "10010002", "04010003", "+1000", Short.valueOf((short)1), Boolean.valueOf(true));
        this.accDSTimeService.initData(accDSTimeItem);
        accDSTimeItem = new AccDSTimeItem("acc_dsTimeUtc1000_1", "10010002", "04010003", "+1000", Short.valueOf((short)1), Boolean.valueOf(true));
        this.accDSTimeService.initData(accDSTimeItem);
        accDSTimeItem = new AccDSTimeItem("acc_dsTimeUtc_0330_0", "03020002", "11010002", "-0330", Short.valueOf((short)1), Boolean.valueOf(true));
        this.accDSTimeService.initData(accDSTimeItem);
        accDSTimeItem = new AccDSTimeItem("acc_dsTimeUtc_1000_0", "03020002", "11010002", "-1000", Short.valueOf((short)1), Boolean.valueOf(true));
        this.accDSTimeService.initData(accDSTimeItem);
        accDSTimeItem = new AccDSTimeItem("acc_dsTimeUtc_0200_0", "03050002", "09050002", "-0200", Short.valueOf((short)1), Boolean.valueOf(true));
        this.accDSTimeService.initData(accDSTimeItem);
        accDSTimeItem = new AccDSTimeItem("acc_dsTimeUtc0930_0", "10010002", "04010003", "+0930", Short.valueOf((short)1), Boolean.valueOf(true));
        this.accDSTimeService.initData(accDSTimeItem);
        accDSTimeItem = new AccDSTimeItem("acc_dsTimeUtc_0100_0", "03050000", "10050001", "-0100", Short.valueOf((short)1), Boolean.valueOf(true));
        this.accDSTimeService.initData(accDSTimeItem);
        accDSTimeItem = new AccDSTimeItem("acc_dsTimeUtc_0400_0", "03020002", "11010002", "-0400", Short.valueOf((short)1), Boolean.valueOf(true));
        this.accDSTimeService.initData(accDSTimeItem);
        accDSTimeItem = new AccDSTimeItem("acc_dsTimeUtc_0400_1", "09010000", "04010000", "-0400", Short.valueOf((short)1), Boolean.valueOf(true));
        this.accDSTimeService.initData(accDSTimeItem);
        accDSTimeItem = new AccDSTimeItem("acc_dsTimeUtc_0400_2", "10010000", "03050000", "-0400", Short.valueOf((short)1), Boolean.valueOf(true));
        this.accDSTimeService.initData(accDSTimeItem);
        accDSTimeItem = new AccDSTimeItem("acc_dsTimeUtc_0300_0", "03050622", "10050623", "-0300", Short.valueOf((short)1), Boolean.valueOf(true));
        this.accDSTimeService.initData(accDSTimeItem);
        accDSTimeItem = new AccDSTimeItem("acc_dsTimeUtc_0300_1", "03020002", "11010002", "-0300", Short.valueOf((short)1), Boolean.valueOf(true));
        this.accDSTimeService.initData(accDSTimeItem);
        accDSTimeItem = new AccDSTimeItem("acc_dsTimeUtc0200_0", "03050002", "10050003", "+0200", Short.valueOf((short)1), Boolean.valueOf(true));
        this.accDSTimeService.initData(accDSTimeItem);
        accDSTimeItem = new AccDSTimeItem("acc_dsTimeUtc0200_1", "03050003", "10050004", "+0200", Short.valueOf((short)1), Boolean.valueOf(true));
        this.accDSTimeService.initData(accDSTimeItem);
        accDSTimeItem = new AccDSTimeItem("acc_dsTimeUtc0200_2", "03050003", "10050004", "+0200", Short.valueOf((short)1), Boolean.valueOf(true));
        this.accDSTimeService.initData(accDSTimeItem);
        accDSTimeItem = new AccDSTimeItem("acc_dsTimeUtc0200_3", "03050502", "10050002", "+0200", Short.valueOf((short)1), Boolean.valueOf(true));
        this.accDSTimeService.initData(accDSTimeItem);
        accDSTimeItem = new AccDSTimeItem("acc_dsTimeUtc0200_4", "03050500", "10050501", "+0200", Short.valueOf((short)1), Boolean.valueOf(true));
        this.accDSTimeService.initData(accDSTimeItem);
        accDSTimeItem = new AccDSTimeItem("acc_dsTimeUtc0200_5", "03050000", "10050000", "+0200", Short.valueOf((short)1), Boolean.valueOf(true));
        this.accDSTimeService.initData(accDSTimeItem);
        accDSTimeItem = new AccDSTimeItem("acc_dsTimeUtc0200_6", "03050500", "10050500", "+0200", Short.valueOf((short)1), Boolean.valueOf(true));
        this.accDSTimeService.initData(accDSTimeItem);
        accDSTimeItem = new AccDSTimeItem("acc_dsTimeUtc0200_7", "03050600", "10050601", "+0200", Short.valueOf((short)1), Boolean.valueOf(true));
        this.accDSTimeService.initData(accDSTimeItem);
        accDSTimeItem = new AccDSTimeItem("acc_dsTimeUtc_0600_0", "03020002", "11010002", "-0600", Short.valueOf((short)1), Boolean.valueOf(true));
        this.accDSTimeService.initData(accDSTimeItem);
        accDSTimeItem = new AccDSTimeItem("acc_dsTimeUtc_0600_1", "04010002", "10050002", "-0600", Short.valueOf((short)1), Boolean.valueOf(true));
        this.accDSTimeService.initData(accDSTimeItem);
        accDSTimeItem = new AccDSTimeItem("acc_dsTimeUtc_0600_2", "09010622", "04010622", "-0600", Short.valueOf((short)1), Boolean.valueOf(true));
        this.accDSTimeService.initData(accDSTimeItem);
        accDSTimeItem = new AccDSTimeItem("acc_dsTimeUtc1300_0", "09050003", "04010004", "+1300", Short.valueOf((short)1), Boolean.valueOf(true));
        this.accDSTimeService.initData(accDSTimeItem);
        accDSTimeItem = new AccDSTimeItem("acc_dsTimeUtc_0500_0", "03020000", "11010001", "-0500", Short.valueOf((short)1), Boolean.valueOf(true));
        this.accDSTimeService.initData(accDSTimeItem);
        accDSTimeItem = new AccDSTimeItem("acc_dsTimeUtc_0500_1", "03020002", "11010002", "-0500", Short.valueOf((short)1), Boolean.valueOf(true));
        this.accDSTimeService.initData(accDSTimeItem);
        accDSTimeItem = new AccDSTimeItem("acc_dsTimeUtc_0500_2", "03020002", "11010002", "-0500", Short.valueOf((short)1), Boolean.valueOf(true));
        this.accDSTimeService.initData(accDSTimeItem);
        accDSTimeItem = new AccDSTimeItem("acc_dsTimeUtc_0500_3", "03020002", "11010002", "-0500", Short.valueOf((short)1), Boolean.valueOf(true));
        this.accDSTimeService.initData(accDSTimeItem);
        accDSTimeItem = new AccDSTimeItem("acc_dsTimeUtc_0500_4", "03020002", "11010002", "-0500", Short.valueOf((short)1), Boolean.valueOf(true));
        this.accDSTimeService.initData(accDSTimeItem);
        accDSTimeItem = new AccDSTimeItem("acc_dsTimeUtc_0800_0", "03020002", "11010002", "-0800", Short.valueOf((short)1), Boolean.valueOf(true));
        this.accDSTimeService.initData(accDSTimeItem);
        accDSTimeItem = new AccDSTimeItem("acc_dsTimeUtc_0800_1", "03020002", "11010002", "-0800", Short.valueOf((short)1), Boolean.valueOf(true));
        this.accDSTimeService.initData(accDSTimeItem);
        accDSTimeItem = new AccDSTimeItem("acc_dsTimeUtc0330_0", "03040100", "09030300", "+0330", Short.valueOf((short)1), Boolean.valueOf(true));
        this.accDSTimeService.initData(accDSTimeItem);
        accDSTimeItem = new AccDSTimeItem("acc_dsTimeUtc0000_0", "03050001", "10050002", "+0000", Short.valueOf((short)1), Boolean.valueOf(true));
        this.accDSTimeService.initData(accDSTimeItem);
        accDSTimeItem = new AccDSTimeItem("acc_dsTimeUtc1200_0", "11020002", "01030003", "+1200", Short.valueOf((short)1), Boolean.valueOf(true));
        this.accDSTimeService.initData(accDSTimeItem);
        accDSTimeItem = new AccDSTimeItem("acc_dsTimeUtc1200_1", "03050002", "10050003", "+1200", Short.valueOf((short)1), Boolean.valueOf(true));
        this.accDSTimeService.initData(accDSTimeItem);
        accDSTimeItem = new AccDSTimeItem("acc_dsTimeUtc1200_2", "09050002", "04010003", "+1200", Short.valueOf((short)1), Boolean.valueOf(true));
        this.accDSTimeService.initData(accDSTimeItem);
        accDSTimeItem = new AccDSTimeItem("acc_dsTimeUtc1100_0", "10010002", "04010003", "+1100", Short.valueOf((short)1), Boolean.valueOf(true));
        this.accDSTimeService.initData(accDSTimeItem);
        accDSTimeItem = new AccDSTimeItem("acc_dsTimeUtc_0700_0", "04010002", "10050002", "-0700", Short.valueOf((short)1), Boolean.valueOf(true));
        this.accDSTimeService.initData(accDSTimeItem);
        accDSTimeItem = new AccDSTimeItem("acc_dsTimeUtc_0700_1", "03020002", "11010002", "-0700", Short.valueOf((short)1), Boolean.valueOf(true));
        this.accDSTimeService.initData(accDSTimeItem);
        accDSTimeItem = new AccDSTimeItem("acc_dsTimeUtc0100_0", "03050002", "10050003", "+0100", Short.valueOf((short)1), Boolean.valueOf(true));
        this.accDSTimeService.initData(accDSTimeItem);
        accDSTimeItem = new AccDSTimeItem("acc_dsTimeUtc0100_1", "03050002", "10050003", "+0100", Short.valueOf((short)1), Boolean.valueOf(true));
        this.accDSTimeService.initData(accDSTimeItem);
        accDSTimeItem = new AccDSTimeItem("acc_dsTimeUtc0100_2", "05030002", "04020003", "+0100", Short.valueOf((short)1), Boolean.valueOf(true));
        this.accDSTimeService.initData(accDSTimeItem);
        accDSTimeItem = new AccDSTimeItem("acc_dsTimeUtc0100_3", "03050002", "10050003", "+0100", Short.valueOf((short)1), Boolean.valueOf(true));
        this.accDSTimeService.initData(accDSTimeItem);
        accDSTimeItem = new AccDSTimeItem("acc_dsTimeUtc0100_4", "03050002", "10050003", "+0100", Short.valueOf((short)1), Boolean.valueOf(true));
        this.accDSTimeService.initData(accDSTimeItem);
        accDSTimeItem = new AccDSTimeItem("acc_dsTimeUtc_0900_0", "03020002", "11010002", "-0900", Short.valueOf((short)1), Boolean.valueOf(true));
        this.accDSTimeService.initData(accDSTimeItem);
    }

    private void initAccLevel() {
        AccTimeSegItem accTimeSegItem = this.accTimeSegService.getInitTimeSeg();
        AuthAreaItem authAreaItem = this.authAreaService.getItemByCode("1");
        AccLevelItem accLevelItem = new AccLevelItem(I18nUtil.i18nCode((String)"acc_level_master", (Object[])new Object[0]), Boolean.valueOf(true), authAreaItem.getId(), accTimeSegItem.getId());
        this.accLevelService.initData(accLevelItem);
    }

    public void initAccParams() {
        this.baseSysParamService.initData(new BaseSysParamItem("acc.downNewlog", "0", "\u5b9a\u65f6\u4e0b\u8f7d\u65b0\u8bb0\u5f55\u7684\u65f6\u95f4\u70b9"));
        this.baseSysParamService.initData(new BaseSysParamItem("acc.personPhotoMaxHeight", "140", "\u5b9e\u65f6\u76d1\u63a7\u9875\u9762\u5f39\u51fa\u4eba\u5458\u7167\u7247\u5927\u5c0f"));
        this.baseSysParamService.initData(new BaseSysParamItem("acc.downNewLogExpression", "0 0 0 * * ?", "\u5b9a\u65f6\u83b7\u53d6\u4e8b\u4ef6\u8bb0\u5f55"));
        this.baseSysParamService.initData(new BaseSysParamItem("acc.receiver", "", "\u6536\u4ef6\u4eba\u90ae\u7bb1"));
        this.baseSysParamService.initData(new BaseSysParamItem("acc.addDeviceOperKeyword", "xxx", "\u662f\u5426\u9700\u8981\u8fdb\u884c\u6388\u6743\u5bc6\u7801\u6821\u9a8c\u548c\u64cd\u4f5c\u6743\u9650"));
        this.baseSysParamService.initData(new BaseSysParamItem("acc.queryDoorEventLastLimit", "5", "\u83b7\u53d6\u67e5\u8be2\u7684\u6700\u8fd1\u53d1\u751f\u8bb0\u5f55\u6570"));
        this.baseSysParamService.initData(new BaseSysParamItem("acc.smsReceiver", "", "\u77ed\u4fe1\u6536\u4ef6\u4eba\u624b\u673a\u53f7\u7801"));
        this.baseSysParamService.initData(new BaseSysParamItem("acc.autoExportFrequency", "0", "\u81ea\u52a8\u5bfc\u51fa\u7c7b\u578b"));
        this.baseSysParamService.initData(new BaseSysParamItem("acc.monthFrequency", "0", "\u6309\u6708\u5bfc\u51fa\u7c7b\u578b"));
        this.baseSysParamService.initData(new BaseSysParamItem("acc.monthFrequencyDate", "29", "\u6309\u6708\u5bfc\u51fa\u81ea\u5b9a\u4e49\u6708\u4efd"));
        this.baseSysParamService.initData(new BaseSysParamItem("acc.dayFrequencyHour", "24", "\u6bcf\u5929\u5bfc\u51fa\u81ea\u5b9a\u4e49\u5c0f\u65f6"));
        this.baseSysParamService.initData(new BaseSysParamItem("acc.dayFrequencyMinute", "60", "\u6bcf\u5929\u5bfc\u51fa\u81ea\u5b9a\u4e49\u5206\u949f"));
        this.baseSysParamService.initData(new BaseSysParamItem("acc.exportMode", "2", "\u5bfc\u51fa\u6570\u636e\u9009\u9879"));
        this.baseSysParamService.initData(new BaseSysParamItem("acc.autoExportEmail", "", "\u81ea\u52a8\u5bfc\u51fa\u53d1\u9001\u7684\u90ae\u7bb1"));
        this.baseSysParamService.initData(new BaseSysParamItem("acc.autoExportCron", "", "\u81ea\u52a8\u5bfc\u51fa\u5b9a\u65f6\u4efb\u52a1cron\u8868\u8fbe\u5f0f"));
        JSONObject values = new JSONObject();
        values.put("keptMonth", (Object)"15");
        values.put("runtime", (Object)"01:00:00");
        BaseSysParamItem item = new BaseSysParamItem("accReportDataClean", values.toString(), "base_dataClean_accTrans");
        this.baseSysParamService.initData(item);
        JSONObject notificationValues = new JSONObject();
        notificationValues.put("Email", (Object)"1");
        notificationValues.put("SMS", (Object)"1");
        notificationValues.put("Whatsapp", (Object)"1");
        notificationValues.put("Line", (Object)"1");
        item = new BaseSysParamItem("accMessageNotification", notificationValues.toString(), "base_dataClean_accTrans");
        this.baseSysParamService.initData(item);
        if (this.accSupportFuncService.isSupportLcdRTMonitor()) {
            this.baseSysParamService.initData(new BaseSysParamItem("lcd.version", "true", "lcd\u8bb8\u53ef", Boolean.valueOf(true)));
        }
        this.baseSysParamService.initData(new BaseSysParamItem("acc.capturePhoto.encryptProp", "true", "\u4e2a\u4eba\u654f\u611f\u4fe1\u606f\u4fdd\u62a4-\u6293\u62cd\u7167\u7247"));
    }

    private void initAppMenus() {
        AuthPermissionItem appModuleItem = null;
        AuthPermissionItem appMenuItem = null;
        AuthPermissionItem appButtonItem = null;
        appModuleItem = this.authPermissionService.getItemByCode("App");
        if (appModuleItem == null) {
            appModuleItem = new AuthPermissionItem("App", "app_module", "app", "app_system", "true", Integer.valueOf(998));
            this.authPermissionService.initData(appModuleItem);
        }
        appMenuItem = new AuthPermissionItem("AppAcc", "app_acc", "app:APPacc", "app_menu", "true", Integer.valueOf(2));
        appMenuItem.setParentId(appModuleItem.getId());
        appMenuItem = this.authPermissionService.initData(appMenuItem);
        appButtonItem = new AuthPermissionItem("AppAccMonitor", "app_acc_monitor", "app:APPaccMonitor", "app_button", "true", Integer.valueOf(1));
        appButtonItem.setParentId(appMenuItem.getId());
        this.authPermissionService.initData(appButtonItem);
        appButtonItem = new AuthPermissionItem("AppAccDevice", "app_acc_device", "app:APPaccDevice", "app_button", "true", Integer.valueOf(2));
        appButtonItem.setParentId(appMenuItem.getId());
        this.authPermissionService.initData(appButtonItem);
        appButtonItem = new AuthPermissionItem("AppAccAlarm", "app_acc_alarm", "app:APPaccAlarm", "app_button", "true", Integer.valueOf(3));
        appButtonItem.setParentId(appMenuItem.getId());
        this.authPermissionService.initData(appButtonItem);
        appButtonItem = new AuthPermissionItem("AppAccReport", "app_acc_report", "app:APPaccReport", "app_button", "true", Integer.valueOf(4));
        appButtonItem.setParentId(appMenuItem.getId());
        this.authPermissionService.initData(appButtonItem);
        appButtonItem = new AuthPermissionItem("AppAccRemoteControl", "app_acc_remoteControl", "app:APPaccRemoteControl", "app_button", "true", Integer.valueOf(5));
        appButtonItem.setParentId(appMenuItem.getId());
        this.authPermissionService.initData(appButtonItem);
        appButtonItem = new AuthPermissionItem("AppAccLockdown", "app_acc_lockdown", "app:APPaccLockdown", "app_button", "true", Integer.valueOf(6));
        appButtonItem.setParentId(appMenuItem.getId());
        this.authPermissionService.initData(appButtonItem);
    }

    private void initUpgradeVersion() {
        String curVersion = VersionUtil.getReleaseGitTags((String)"acc");
        if (StringUtils.isNotBlank((CharSequence)curVersion)) {
            BaseSysParamItem baseSysParamItem = this.baseSysParamService.findByParamName("AccUpgradeVersion");
            if (StringUtils.isBlank((CharSequence)baseSysParamItem.getId())) {
                baseSysParamItem = new BaseSysParamItem("AccUpgradeVersion", curVersion, "Acc Upgrade Version", Boolean.valueOf(true));
            }
            this.baseSysParamService.saveItem(baseSysParamItem);
        }
    }
}

