/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ui.web.freemarker.util;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.LocaleMessageSourceUtil;
import com.zkteco.zkbiosecurity.core.utils.SpringContextUtil;
import freemarker.template.TemplateDirectiveBody;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.UUID;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.i18n.CookieLocaleResolver;
import org.springframework.web.util.WebUtils;

public class BeanUtil {
    private static final Logger log = LoggerFactory.getLogger(BeanUtil.class);

    public static String getParam(Map params, String paramName, String defValue) {
        if (params == null || params.isEmpty()) {
            return defValue;
        }
        Object param = params.get(paramName);
        return param == null ? defValue : param.toString();
    }

    public static String getParams(Map params, String paramName, String ... defValue) {
        Object param;
        if (params != null && !params.isEmpty() && Objects.nonNull(param = params.get(paramName)) && StringUtils.isNotBlank((CharSequence)param.toString())) {
            return param.toString();
        }
        if (defValue != null && defValue.length > 0) {
            String ret = null;
            int i = 0;
            while (i < defValue.length) {
                if (StringUtils.isNotBlank((CharSequence)defValue[i])) {
                    return defValue[i];
                }
                if (defValue[i] != null && ret == null) {
                    ret = defValue[i];
                }
                ++i;
            }
            return ret;
        }
        return null;
    }

    public static String getUUID() {
        String uuid = UUID.randomUUID().toString();
        return uuid.replace("-", "");
    }

    public static String getBodyContent(TemplateDirectiveBody body) {
        if (body != null) {
            try {
                StringWriter out = new StringWriter();
                body.render((Writer)out);
                return out.toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static void setParamsToJson(JSONObject jsonData, Map params) {
        if (params != null && !params.isEmpty()) {
            for (Object key : params.keySet()) {
                if (BeanUtil.isIllegal(key.toString()) || BeanUtil.isIllegal(params.get(key).toString())) continue;
                if ("title".equals(key.toString()) || "text".equals(key.toString())) {
                    jsonData.put(key.toString(), (Object)I18nUtil.i18nCode((String)params.get(key).toString(), (Object[])new Object[0]));
                    continue;
                }
                jsonData.put("" + key, (Object)params.get(key).toString());
            }
        }
    }

    public static boolean isIllegal(String s) {
        return StringUtils.isNotBlank((CharSequence)s) && s.toLowerCase().contains("<script");
    }

    public static String paramsToString(Map params) {
        StringBuffer str = new StringBuffer();
        if (params != null && !params.isEmpty()) {
            Iterator iterator = params.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry obj;
                Map.Entry entry = obj = iterator.next();
                str.append("\"");
                str.append(entry.getKey());
                if (!BeanUtil.isBaseType(entry.getValue())) {
                    str.append("\":\"");
                    str.append(entry.getValue());
                    str.append("\",");
                    continue;
                }
                str.append("\":");
                str.append(entry.getValue());
                str.append(",");
            }
            str.deleteCharAt(str.length() - 1);
        }
        return str.toString();
    }

    public static StringBuffer appendString(StringBuffer op, String str) {
        if (op.length() > 1) {
            op.append(",");
        }
        op.append(str);
        return op;
    }

    public static StringBuffer appendPair(StringBuffer op, String paramName, String val) {
        if (op.length() > 1) {
            op.append(",");
        }
        op.append("\"");
        op.append(paramName);
        op.append("\":\"");
        op.append(val);
        op.append("\"");
        return op;
    }

    private static HttpServletRequest getCurrentRequest() throws IllegalStateException {
        ServletRequestAttributes attrs = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (attrs == null) {
            return null;
        }
        return attrs.getRequest();
    }

    public static String getCurrentLanguage() {
        Cookie cookie;
        HttpServletRequest request = BeanUtil.getCurrentRequest();
        String lang = "";
        if (request != null && StringUtils.isBlank((CharSequence)(lang = request.getParameter("lang"))) && (cookie = WebUtils.getCookie((HttpServletRequest)request, (String)CookieLocaleResolver.LOCALE_REQUEST_ATTRIBUTE_NAME)) != null && "id-ID".equals(lang = cookie.getValue())) {
            lang = "in_ID";
        }
        if (StringUtils.isBlank((CharSequence)lang)) {
            lang = SpringContextUtil.getApplicationContext().getEnvironment().getProperty("system.language");
        }
        return lang.replace("-", "_");
    }

    public static boolean enableRTL() {
        String enableRTL = SpringContextUtil.getApplicationContext().getEnvironment().getProperty("system.enableRTL");
        if (StringUtils.isNotBlank((CharSequence)enableRTL) && "true".equalsIgnoreCase(enableRTL)) {
            return true;
        }
        String lang = BeanUtil.getCurrentLanguage();
        return StringUtils.isNotBlank((CharSequence)lang) && (lang.startsWith("ar") || lang.startsWith("he") || lang.startsWith("iw") || lang.startsWith("fa") || lang.startsWith("ur"));
    }

    public static String getEnableRTLValue(String align, boolean isRTL) {
        if (isRTL) {
            if ("left".equalsIgnoreCase(align)) {
                return "right";
            }
            if ("right".equalsIgnoreCase(align)) {
                return "left";
            }
        }
        return align;
    }

    public static String getEnableRTLValue(String align) {
        boolean isRTL = BeanUtil.enableRTL();
        return BeanUtil.getEnableRTLValue(align, isRTL);
    }

    public static boolean isShow(String s) {
        if (StringUtils.isNotBlank((CharSequence)s)) {
            try {
                s = s.trim();
                if (s.toLowerCase().equals("true") || s.toLowerCase().equals("false")) {
                    return Boolean.valueOf(s.trim().toLowerCase());
                }
                if (s.startsWith("JAVA#")) {
                    String classMethodName = s.substring(5);
                    int len = classMethodName.lastIndexOf(".");
                    String className = classMethodName.substring(0, len);
                    String methodName = classMethodName.substring(len + 1);
                    Object obj = null;
                    try {
                        obj = SpringContextUtil.getBean((String)className);
                    }
                    catch (Exception ex) {
                        obj = ClassUtils.getClass((String)className).newInstance();
                    }
                    boolean show = (Boolean)MethodUtils.invokeMethod((Object)obj, (String)methodName, null);
                    return show;
                }
                s = BeanUtil.parseExpression(s, "application['", "']");
                SpelExpressionParser parser = new SpelExpressionParser();
                StandardEvaluationContext context = new StandardEvaluationContext();
                context.setVariable("language", (Object)LocaleMessageSourceUtil.language);
                boolean show = (Boolean)parser.parseExpression(s).getValue((EvaluationContext)context, Boolean.class);
                return show;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    private static String parseExpression(String exp, String bTag, String eTag) {
        if (StringUtils.isNotBlank((CharSequence)exp)) {
            int bInd = exp.indexOf(bTag);
            while (bInd != -1) {
                String prop;
                int eInd = exp.indexOf(eTag, bInd);
                if (eInd != -1 && StringUtils.isNotBlank((CharSequence)(prop = exp.substring(bInd + bTag.length(), eInd)))) {
                    String val = SpringContextUtil.getApplicationContext().getEnvironment().getProperty(prop.trim());
                    exp = String.valueOf(exp.substring(0, bInd)) + "'" + val + "'" + exp.substring(eInd + eTag.length());
                }
                bInd = exp.indexOf(bTag, eInd);
            }
        }
        return exp;
    }

    public static boolean isBaseType(Object obj) {
        if (obj instanceof Integer || obj instanceof Long) {
            return true;
        }
        if (obj instanceof Double || obj instanceof Float) {
            return true;
        }
        if (obj instanceof Boolean || obj instanceof Short) {
            return true;
        }
        return obj instanceof Byte;
    }

    public static void addRequestParams(JSONObject opts, String flag) {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        HttpServletRequest request = servletRequestAttributes.getRequest();
        if (StringUtils.isBlank((CharSequence)flag) || StringUtils.isNotBlank((CharSequence)flag) && StringUtils.isNotBlank((CharSequence)request.getParameter(flag))) {
            Enumeration names = request.getParameterNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (BeanUtil.isIllegal(name) || BeanUtil.isIllegal(request.getParameter(name))) continue;
                opts.put(name, (Object)request.getParameter(name));
            }
        }
    }

    public static String getProperty(String key, String def) {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        HttpServletRequest request = servletRequestAttributes.getRequest();
        String value = request.getParameter(key);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return value;
        }
        value = (String)request.getAttribute(key);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return value;
        }
        value = (String)request.getSession().getAttribute(key);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return value;
        }
        value = (String)request.getServletContext().getAttribute(key);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return value;
        }
        value = SpringContextUtil.getApplicationContext().getEnvironment().getProperty(key);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return value;
        }
        return def;
    }

    public static String getProperty(Resource resource, String key) {
        String value = "";
        try {
            Properties properties = new Properties();
            properties.load(resource.getInputStream());
            value = properties.getProperty(key);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return value;
    }
}

