/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ui.web.freemarker.tags;

import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ui.web.freemarker.tags.A;
import com.zkteco.zkbiosecurity.ui.web.freemarker.tags.Button;
import com.zkteco.zkbiosecurity.ui.web.freemarker.tags.DIV;
import com.zkteco.zkbiosecurity.ui.web.freemarker.tags.IMG;
import com.zkteco.zkbiosecurity.ui.web.freemarker.tags.Input;
import com.zkteco.zkbiosecurity.ui.web.freemarker.tags.LI;
import com.zkteco.zkbiosecurity.ui.web.freemarker.tags.Label;
import com.zkteco.zkbiosecurity.ui.web.freemarker.tags.Link;
import com.zkteco.zkbiosecurity.ui.web.freemarker.tags.Option;
import com.zkteco.zkbiosecurity.ui.web.freemarker.tags.Script;
import com.zkteco.zkbiosecurity.ui.web.freemarker.tags.Select;
import com.zkteco.zkbiosecurity.ui.web.freemarker.tags.Span;
import com.zkteco.zkbiosecurity.ui.web.freemarker.tags.Style;
import com.zkteco.zkbiosecurity.ui.web.freemarker.tags.TD;
import com.zkteco.zkbiosecurity.ui.web.freemarker.tags.TH;
import com.zkteco.zkbiosecurity.ui.web.freemarker.tags.TR;
import com.zkteco.zkbiosecurity.ui.web.freemarker.tags.Table;
import com.zkteco.zkbiosecurity.ui.web.freemarker.tags.Tbody;
import com.zkteco.zkbiosecurity.ui.web.freemarker.tags.Thead;
import com.zkteco.zkbiosecurity.ui.web.freemarker.tags.UL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HTMLElement {
    protected HTMLElement _parent;
    protected Map<String, String> _attrs = new HashMap<String, String>();
    protected boolean isSingleTag = false;
    protected String tagName = "";
    protected String cont = "";
    protected Map<String, String> _style = new HashMap<String, String>();
    private static List<String> SUPPORT_ATTR = new ArrayList<String>();
    public List<HTMLElement> children = new ArrayList<HTMLElement>();

    static {
        SUPPORT_ATTR.add("id");
        SUPPORT_ATTR.add("name");
        SUPPORT_ATTR.add("class");
        SUPPORT_ATTR.add("style");
        SUPPORT_ATTR.add("type");
        SUPPORT_ATTR.add("href");
        SUPPORT_ATTR.add("src");
        SUPPORT_ATTR.add("colspan");
        SUPPORT_ATTR.add("align");
        SUPPORT_ATTR.add("rowspan");
        SUPPORT_ATTR.add("title");
        SUPPORT_ATTR.add("valign");
        SUPPORT_ATTR.add("dir");
        SUPPORT_ATTR.add("value");
        SUPPORT_ATTR.add("target");
        SUPPORT_ATTR.add("rel");
        SUPPORT_ATTR.add("lang");
        SUPPORT_ATTR.add("disabled");
        SUPPORT_ATTR.add("accept");
        SUPPORT_ATTR.add("action");
        SUPPORT_ATTR.add("autocomplete");
        SUPPORT_ATTR.add("enctype");
        SUPPORT_ATTR.add("method");
        SUPPORT_ATTR.add("cols");
        SUPPORT_ATTR.add("multiple");
        SUPPORT_ATTR.add("alt");
        SUPPORT_ATTR.add("autofocus");
        SUPPORT_ATTR.add("checked");
        SUPPORT_ATTR.add("form");
        SUPPORT_ATTR.add("formaction");
        SUPPORT_ATTR.add("formenctype");
        SUPPORT_ATTR.add("formmethod");
        SUPPORT_ATTR.add("formnovalidate");
        SUPPORT_ATTR.add("formtarget");
        SUPPORT_ATTR.add("height");
        SUPPORT_ATTR.add("list");
        SUPPORT_ATTR.add("pattern");
        SUPPORT_ATTR.add("placeholder");
        SUPPORT_ATTR.add("required");
        SUPPORT_ATTR.add("size");
        SUPPORT_ATTR.add("step");
        SUPPORT_ATTR.add("readonly");
        SUPPORT_ATTR.add("maxlength");
        SUPPORT_ATTR.add("minlength");
        SUPPORT_ATTR.add("onkeyup");
        SUPPORT_ATTR.add("onkeydown");
        SUPPORT_ATTR.add("onkeypress");
        SUPPORT_ATTR.add("onmouseover");
        SUPPORT_ATTR.add("onmouseout");
        SUPPORT_ATTR.add("onfocus");
        SUPPORT_ATTR.add("onblur");
    }

    public DIV div() {
        DIV div = new DIV();
        div._parent = this;
        div.tagName = "div";
        this.children.add(div);
        return div;
    }

    public HTMLElement width(String w) {
        String s = this._attrs.get("style");
        if (s == null || "".equals(s)) {
            s = "width:" + w + "px";
        } else if (s.indexOf("width") != -1) {
            int ind = s.indexOf("width");
            String ws = s.substring(ind).trim();
            s = String.valueOf(s.substring(0, ind + 5)) + ":" + w + "px;";
            ind = ws.indexOf(";");
            if (ind != -1 && ind != ws.length() - 1) {
                s = String.valueOf(s) + ws.substring(ind + 1);
            }
        } else {
            s = String.valueOf(s) + "width:" + w + "px;";
        }
        this._attrs.put("style", s);
        return this;
    }

    public Table table() {
        Table table = new Table();
        table._parent = this;
        table.tagName = "table";
        this.children.add(table);
        return table;
    }

    public void removeChildren() {
        this.children = new ArrayList<HTMLElement>();
    }

    public Select select() {
        Select select = new Select();
        select._parent = this;
        select.tagName = "select";
        this.children.add(select);
        return select;
    }

    public Option option() {
        Option option = new Option();
        option._parent = this;
        option.tagName = "option";
        this.children.add(option);
        return option;
    }

    public HTMLElement value(String v) {
        this._attrs.put("value", v);
        return this;
    }

    public TR tr() {
        TR tr = new TR();
        tr._parent = this;
        tr.tagName = "tr";
        this.children.add(tr);
        return tr;
    }

    public TD td() {
        TD td = new TD();
        td._parent = this;
        td.tagName = "td";
        this.children.add(td);
        return td;
    }

    public UL ul() {
        UL ul = new UL();
        ul._parent = this;
        ul.tagName = "ul";
        this.children.add(ul);
        return ul;
    }

    public LI li() {
        LI li = new LI();
        li._parent = this;
        li.tagName = "li";
        this.children.add(li);
        return li;
    }

    public TH th() {
        TH th = new TH();
        th._parent = this;
        th.tagName = "th";
        this.children.add(th);
        return th;
    }

    public Tbody tbody() {
        Tbody tbody = new Tbody();
        tbody._parent = this;
        tbody.tagName = "tbody";
        this.children.add(tbody);
        return tbody;
    }

    public Thead thead() {
        Thead thead = new Thead();
        thead._parent = this;
        thead.tagName = "thead";
        this.children.add(thead);
        return thead;
    }

    public HTMLElement appendContent(String c) {
        this.cont = String.valueOf(this.cont) + c;
        return this;
    }

    public HTMLElement appendChild(HTMLElement c) {
        c._parent = this;
        this.children.add(c);
        return this;
    }

    public HTMLElement text(String c) {
        this.cont = c;
        return this;
    }

    public HTMLElement addAttributes(Map p) {
        if (p != null && p.size() > 0) {
            for (Map.Entry obj : p.entrySet()) {
                Map.Entry entry = obj;
                if ("title".equals(entry.getKey().toString())) {
                    this._attrs.put(entry.getKey().toString(), I18nUtil.i18nCode((String)entry.getValue().toString(), (Object[])new Object[0]));
                    continue;
                }
                if ("style".equals(entry.getKey().toString())) {
                    this.style(entry.getValue().toString());
                    continue;
                }
                this._attrs.put(entry.getKey().toString(), entry.getValue().toString());
            }
        }
        return this;
    }

    public HTMLElement addAttributesOnly(Map p) {
        if (p != null && p.size() > 0) {
            for (Map.Entry obj : p.entrySet()) {
                Map.Entry entry = obj;
                if (!SUPPORT_ATTR.contains(entry.getKey().toString().toLowerCase())) continue;
                if ("title".equals(entry.getKey().toString())) {
                    this._attrs.put(entry.getKey().toString(), I18nUtil.i18nCode((String)entry.getValue().toString(), (Object[])new Object[0]));
                    continue;
                }
                if ("style".equals(entry.getKey().toString())) {
                    this.style(entry.getValue().toString());
                    continue;
                }
                this._attrs.put(entry.getKey().toString(), entry.getValue().toString());
            }
        }
        return this;
    }

    public Input input() {
        Input input = new Input();
        input._parent = this;
        input.isSingleTag = true;
        input.tagName = "input";
        this.children.add(input);
        return input;
    }

    public IMG img() {
        IMG img = new IMG();
        img._parent = this;
        img.isSingleTag = true;
        img.tagName = "img";
        this.children.add(img);
        return img;
    }

    public Link link() {
        Link link = new Link();
        link._parent = this;
        link.isSingleTag = true;
        link.tagName = "link";
        this.children.add(link);
        return link;
    }

    public Span span() {
        Span span = new Span();
        span._parent = this;
        span.tagName = "span";
        this.children.add(span);
        return span;
    }

    public Button button() {
        Button button = new Button();
        button._parent = this;
        button.tagName = "button";
        this.children.add(button);
        return button;
    }

    public Label label() {
        Label label = new Label();
        label._parent = this;
        label.tagName = "label";
        this.children.add(label);
        return label;
    }

    public Script script() {
        Script script = new Script();
        script._parent = this;
        script.tagName = "script";
        this.children.add(script);
        return script;
    }

    public Style style() {
        Style style = new Style();
        style._parent = this;
        style.tagName = "style";
        this.children.add(style);
        return style;
    }

    public A a() {
        A a = new A();
        a._parent = this;
        a.tagName = "a";
        this.children.add(a);
        return a;
    }

    public HTMLElement parent() {
        return this._parent;
    }

    public HTMLElement attr(String attrName, String value) {
        if (attrName.equals("style")) {
            return this.style(value);
        }
        this._attrs.put(attrName, value);
        return this;
    }

    public String attr(String attrName) {
        return this._attrs.get(attrName);
    }

    public HTMLElement removeAttr(String attrName) {
        this._attrs.remove(attrName);
        if (attrName.equals("style")) {
            this._style.clear();
        }
        return this;
    }

    public HTMLElement id(String _id) {
        this._attrs.put("id", _id);
        return this;
    }

    public HTMLElement name(String _name) {
        this._attrs.put("name", _name);
        return this;
    }

    public HTMLElement addClass(String _class) {
        String cls = this._attrs.get("class");
        cls = cls == null ? _class : String.valueOf(_class) + " " + cls;
        this._attrs.put("class", cls);
        return this;
    }

    public HTMLElement style(String _style) {
        if (_style != null && !"".equals(_style)) {
            this.setStringToStyle(_style);
            this.setStyleToAttr();
        }
        return this;
    }

    public HTMLElement css(String _styleName, String _style) {
        this._style.put(_styleName, _style);
        this.setStyleToAttr();
        return this;
    }

    private void setStringToStyle(String _style) {
        if (_style != null && !"".equals(_style)) {
            String[] _css = _style.split(";");
            int i = 0;
            while (i < _css.length) {
                String[] __css = _css[i].split(":");
                if (__css.length == 2) {
                    this._style.put(__css[0].trim(), __css[1].trim());
                }
                ++i;
            }
        }
    }

    private void setStyleToAttr() {
        if (!this._style.isEmpty()) {
            StringBuffer content = new StringBuffer();
            for (Map.Entry<String, String> entry : this._style.entrySet()) {
                content.append(String.valueOf(entry.getKey()) + ":" + entry.getValue() + ";");
            }
            this._attrs.put("style", content.toString());
        }
    }

    public HTMLElement type(String _type) {
        this._attrs.put("type", _type);
        return this;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean noclose) {
        StringBuffer c = new StringBuffer();
        if (!"".equals(this.tagName)) {
            c.append("<" + this.tagName);
            for (Map.Entry entry : this._attrs.entrySet()) {
                c.append(" " + ((String)entry.getKey()).toString() + "=\"" + (entry.getValue() == null ? "" : ((String)entry.getValue()).toString()) + "\"");
            }
            if (this.isSingleTag) {
                c.append("/>");
            } else {
                c.append(">");
            }
        }
        for (HTMLElement hTMLElement : this.children) {
            c.append(hTMLElement.toString());
        }
        c.append(this.cont);
        if (!(noclose || "".equals(this.tagName) || this.isSingleTag)) {
            c.append("</" + this.tagName + ">");
        }
        return c.toString();
    }

    public String getCloseTag() {
        return "</" + this.tagName + ">";
    }
}

