/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ui.web.freemarker.directives;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ui.web.freemarker.annotation.ZKUIDirective;
import com.zkteco.zkbiosecurity.ui.web.freemarker.tags.Document;
import com.zkteco.zkbiosecurity.ui.web.freemarker.tags.HTMLElement;
import com.zkteco.zkbiosecurity.ui.web.freemarker.util.BeanUtil;
import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
@ZKUIDirective(script="ui/js/ZKUpload.js")
public class Upload
implements TemplateDirectiveModel {
    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        JSONObject options = new JSONObject();
        BeanUtil.setParamsToJson(options, params);
        String uuid = BeanUtil.getUUID();
        String id = BeanUtil.getParam(params, "id", "uploadFile" + uuid);
        String name = BeanUtil.getParam(params, "name", "upload");
        String text = BeanUtil.getParam(params, "text", I18nUtil.i18nCode((String)"base_file_notUpload", (Object[])new Object[0]));
        String value = BeanUtil.getParam(params, "value", I18nUtil.i18nCode((String)"base_file_browse", (Object[])new Object[0]));
        options.put("id", (Object)id);
        options.put("name", (Object)name);
        options.put("text", (Object)text);
        HTMLElement doc = Document.createElement();
        HTMLElement div = doc.div().addAttributesOnly(params).id(id).removeAttr("name").addClass("upload-file-box input-valid-hidden");
        HTMLElement button = div.input().id("uploadFileButton" + uuid).name("uploadFileButton");
        Map<String, String> btnAttr = this.getParamsByPrefix(options, "btn_");
        button.addAttributesOnly(btnAttr);
        button.type("button").addClass("upload-file-button").value(value);
        button.attr("onclick", String.valueOf(name) + ".click()");
        options.put("buttonId", (Object)button.attr("id"));
        HTMLElement label = div.label().id("uploadMsg" + uuid).addClass("upload-file-msg").appendContent(text);
        if (options.get((Object)"hideLabel") != null && options.getString("hideLabel").equals("true")) {
            label.css("display", "none");
        }
        Map<String, String> fileAttr = this.getParamsByPrefix(options, "file_");
        HTMLElement file = div.input().id(String.valueOf(id) + "_hidden").addAttributesOnly(fileAttr).type("file").name(name).css("display", "none");
        options.put("fileId", (Object)file.attr("id"));
        doc.script().appendContent("new ZKUI.Upload(" + options.toJSONString() + ");");
        Writer out = env.getOut();
        out.write(doc.toString());
    }

    private Map<String, String> getParamsByPrefix(JSONObject options, String prefix) {
        HashMap<String, String> map = new HashMap<String, String>();
        Set keys = options.keySet();
        for (String key : keys) {
            if (!key.startsWith(prefix) || !StringUtils.isNotBlank((CharSequence)options.getString(key))) continue;
            map.put(key.substring(prefix.length()), options.getString(key));
        }
        return map;
    }
}

