/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ui.web.freemarker.directives;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.LocaleMessageSourceUtil;
import com.zkteco.zkbiosecurity.core.utils.SpringContextUtil;
import com.zkteco.zkbiosecurity.security.SecurityService;
import com.zkteco.zkbiosecurity.ui.web.freemarker.annotation.ZKUIDirective;
import com.zkteco.zkbiosecurity.ui.web.freemarker.util.BeanUtil;
import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Component;

@Component
@ZKUIDirective
public class ToolItem
implements TemplateDirectiveModel {
    @Autowired(required=false)
    private SecurityService securityService;
    @Value(value="${system.admin.isshow:false}")
    private String systemAdminIsshow;
    @Value(value="${system.upload.maxsize:}")
    private String systemUploadMaxSize;

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        JSONObject toolbar = (JSONObject)env.getCurrentNamespace().toMap().get("toolbar");
        if (toolbar != null) {
            JSONObject jsonData = new JSONObject();
            BeanUtil.setParamsToJson(jsonData, params);
            if (GridUtil.isPermitted((String)jsonData.getString("permission")) && this.isShow(jsonData.getString("isShow"))) {
                JSONObject option = new JSONObject();
                this.setOption(option, params, env, body);
                if (Objects.nonNull(option.get((Object)"options")) && option.get((Object)"options") instanceof List && ((List)option.get((Object)"options")).size() == 0) {
                    return;
                }
                ((List)toolbar.get((Object)"options")).add(option);
            }
        }
    }

    public Boolean systemAdminIsshow() {
        if ("true".equals(this.systemAdminIsshow)) {
            return true;
        }
        return false;
    }

    private boolean isShow(String s) {
        if (StringUtils.isNotBlank((CharSequence)s)) {
            try {
                s = s.trim();
                if (s.toLowerCase().equals("true") || s.toLowerCase().equals("false")) {
                    return Boolean.valueOf(s.trim().toLowerCase());
                }
                if (s.startsWith("JAVA#")) {
                    String classMethodName = s.substring(5);
                    int len = classMethodName.lastIndexOf(".");
                    String className = classMethodName.substring(0, len);
                    String methodName = classMethodName.substring(len + 1);
                    Object obj = null;
                    try {
                        obj = SpringContextUtil.getBean((String)className);
                    }
                    catch (Exception ex) {
                        obj = ClassUtils.getClass((String)className).newInstance();
                    }
                    boolean show = (Boolean)MethodUtils.invokeMethod((Object)obj, (String)methodName, null);
                    return show;
                }
                s = this.parseExpression(s, "application['", "']");
                SpelExpressionParser parser = new SpelExpressionParser();
                StandardEvaluationContext context = new StandardEvaluationContext();
                context.setVariable("language", (Object)LocaleMessageSourceUtil.language);
                boolean show = (Boolean)parser.parseExpression(s).getValue((EvaluationContext)context, Boolean.class);
                return show;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    private String parseExpression(String exp, String bTag, String eTag) {
        if (StringUtils.isNotBlank((CharSequence)exp)) {
            int bInd = exp.indexOf(bTag);
            while (bInd != -1) {
                String prop;
                int eInd = exp.indexOf(eTag, bInd);
                if (eInd != -1 && StringUtils.isNotBlank((CharSequence)(prop = exp.substring(bInd + bTag.length(), eInd)))) {
                    String val = SpringContextUtil.getApplicationContext().getEnvironment().getProperty(prop.trim());
                    exp = String.valueOf(exp.substring(0, bInd)) + "'" + val + "'" + exp.substring(eInd + eTag.length());
                }
                bInd = exp.indexOf(bTag, eInd);
            }
        }
        return exp;
    }

    public void setOption(JSONObject opts, Map params, Environment env, TemplateDirectiveBody body) throws TemplateException, IOException {
        String type;
        BeanUtil.setParamsToJson(opts, params);
        if (params.get("id") == null) {
            opts.put("id", (Object)("btn" + BeanUtil.getUUID()));
        }
        if ((type = BeanUtil.getParam(params, "type", "button")).equals("refresh")) {
            opts.put("type", (Object)"button");
            opts.put("img", (Object)BeanUtil.getParam(params, "img", "comm_refresh.png"));
            opts.put("action", (Object)BeanUtil.getParam(params, "action", "commonRefresh"));
            opts.put("id", (Object)"refresh");
            opts.put("text", (Object)"common_op_refresh");
        } else if (type.equals("add")) {
            opts.put("type", (Object)"button");
            opts.put("img", (Object)BeanUtil.getParam(params, "img", "comm_add.png"));
            opts.put("action", (Object)BeanUtil.getParam(params, "action", "commonAdd"));
            opts.put("text", (Object)"common_op_new");
        } else if (type.equals("export")) {
            opts.put("type", (Object)"button");
            opts.put("img", (Object)BeanUtil.getParam(params, "img", "comm_export.png"));
            opts.put("action", (Object)BeanUtil.getParam(params, "action", "commonExport"));
            opts.put("text", (Object)BeanUtil.getParam(params, "text", "common_op_export"));
            opts.put("title", (Object)I18nUtil.i18nCode((String)BeanUtil.getParam(params, "title", "common_op_export"), (Object[])new Object[0]));
            opts.put("width", (Object)BeanUtil.getParam(params, "width", "550"));
        } else if (type.equals("import")) {
            opts.put("type", (Object)"button");
            opts.put("maxUploadSize", (Object)BeanUtil.getParam(params, "maxUploadSize", this.systemUploadMaxSize));
            opts.put("img", (Object)BeanUtil.getParam(params, "img", "comm_import.png"));
            opts.put("action", (Object)BeanUtil.getParam(params, "action", "commonImport"));
            opts.put("text", (Object)BeanUtil.getParam(params, "text", "common_op_import"));
            opts.put("title", (Object)I18nUtil.i18nCode((String)BeanUtil.getParam(params, "title", "common_op_import"), (Object[])new Object[0]));
            opts.put("width", (Object)BeanUtil.getParam(params, "width", "500"));
        } else if (type.equals("delete")) {
            opts.put("type", (Object)"button");
            opts.put("img", (Object)BeanUtil.getParam(params, "img", "comm_del.png"));
            opts.put("action", (Object)BeanUtil.getParam(params, "action", "commonDel"));
            opts.put("text", (Object)"common_op_del");
        } else if (type.equals("more")) {
            opts.put("type", (Object)"buttonSelect");
            opts.put("img", (Object)BeanUtil.getParam(params, "img", "comm_moreActions.png"));
            opts.put("text", (Object)BeanUtil.getParam(params, "text", "common_more"));
            opts.put("openAll", (Object)true);
            opts.put("id", (Object)BeanUtil.getParam(params, "id", "moreActions" + BeanUtil.getUUID()));
            JSONObject toolbar = (JSONObject)env.getCurrentNamespace().toMap().get("toolbar");
            opts.put("options", new ArrayList());
            env.getCurrentNamespace().put("toolbar", (Object)opts);
            body.render(env.getOut());
            env.getCurrentNamespace().put("toolbar", (Object)toolbar);
        } else if (type.equals("buttonSelect")) {
            JSONObject toolbar = (JSONObject)env.getCurrentNamespace().toMap().get("toolbar");
            opts.put("options", new ArrayList());
            opts.put("openAll", (Object)true);
            env.getCurrentNamespace().put("toolbar", (Object)opts);
            body.render(env.getOut());
            env.getCurrentNamespace().put("toolbar", (Object)toolbar);
            opts.put("type", (Object)type);
        } else {
            opts.put("type", (Object)type);
        }
        if (opts.getString("type").equals("button") && "".equals(opts.getString("action"))) {
            opts.put("action", (Object)"commonOpen");
        }
        opts.put("text", (Object)I18nUtil.i18nCode((String)((String)opts.get((Object)"text")), (Object[])new Object[0]));
    }
}

