/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ui.web.freemarker.directives;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.ui.web.freemarker.annotation.ZKUIDirective;
import com.zkteco.zkbiosecurity.ui.web.freemarker.tags.Document;
import com.zkteco.zkbiosecurity.ui.web.freemarker.tags.HTMLElement;
import com.zkteco.zkbiosecurity.ui.web.freemarker.util.BeanUtil;
import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
@ZKUIDirective(script="ui/js/ZKSlider.js")
public class Slider
implements TemplateDirectiveModel {
    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        String inputPos;
        String className;
        String id = BeanUtil.getParam(params, "id", "slider" + BeanUtil.getUUID());
        JSONObject options = new JSONObject();
        BeanUtil.setParamsToJson(options, params);
        options.put("id", (Object)id);
        HTMLElement doc = Document.createElement();
        HTMLElement root = doc.div().id(String.valueOf(id) + "Box").addClass("zk_slider_box");
        HTMLElement cont = root.div().addClass("zk_slider_cont_box");
        cont.div().id(id).addClass("zk_slider_cont");
        HTMLElement line = cont.div().addClass("zk_slider_line");
        line.div().addClass("zk_slider_line_min").appendContent("");
        line.div().addClass("zk_slider_line_max").appendContent("");
        HTMLElement inputBox = root.div().addClass("zk_slider_input_box");
        HTMLElement input = inputBox.input().addClass("zk_slider_input").type("text").id(String.valueOf(id) + "Input");
        String name = BeanUtil.getParam((Map)options, "name", "");
        if (StringUtils.isNotBlank((CharSequence)name)) {
            input.name(name);
        }
        if (StringUtils.isNotBlank((CharSequence)(className = BeanUtil.getParam((Map)options, "class", "")))) {
            root.addClass(className);
        }
        if (StringUtils.isNotBlank((CharSequence)(inputPos = BeanUtil.getParam((Map)options, "inputPos", "")))) {
            if ("left".equalsIgnoreCase(inputPos)) {
                root.addClass("zk_slider_box_left");
            } else if ("top".equalsIgnoreCase(inputPos)) {
                root.addClass("zk_slider_box_top");
            } else if ("bottom".equalsIgnoreCase(inputPos)) {
                root.addClass("zk_slider_box_bottom");
            }
        } else {
            inputBox.css("display", "none");
        }
        String showRange = BeanUtil.getParam((Map)options, "showRange", "");
        if (!"true".equalsIgnoreCase(showRange)) {
            line.css("display", "none");
        }
        doc.script().appendContent("new ZKUI.Slider(" + options.toJSONString() + ")");
        Writer out = env.getOut();
        out.write(doc.toString());
    }
}

