/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ui.web.freemarker.directives;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ui.web.freemarker.annotation.ZKUIDirective;
import com.zkteco.zkbiosecurity.ui.web.freemarker.tags.A;
import com.zkteco.zkbiosecurity.ui.web.freemarker.tags.Document;
import com.zkteco.zkbiosecurity.ui.web.freemarker.tags.HTMLElement;
import com.zkteco.zkbiosecurity.ui.web.freemarker.tags.TR;
import com.zkteco.zkbiosecurity.ui.web.freemarker.util.BeanUtil;
import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@ZKUIDirective(script="ui/js/ZKSearchbar.js")
public class Searchbar
implements TemplateDirectiveModel {
    @Value(value="${system.queryIcon:icon-search}")
    private String queryIcon;
    @Value(value="${system.clearIcon:icon-cancel-circle}")
    private String clearIcon;
    @Value(value="${system.clearAutoReload:}")
    private String autoReload;

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        JSONObject options;
        Writer out = env.getOut();
        JSONObject jsonData = new JSONObject();
        BeanUtil.setParamsToJson(jsonData, params);
        String gridName = jsonData.getString("gridName");
        if ((gridName == null || "".equals(gridName)) && (options = (JSONObject)env.getCurrentNamespace().toMap().get("options")) != null && ((gridName = options.getString("gridName")) == null || "".equals(gridName))) {
            gridName = "gridbox" + BeanUtil.getUUID();
        }
        jsonData.put("gridName", (Object)gridName);
        jsonData.put("top", (Object)"");
        jsonData.put("below", (Object)"");
        jsonData.put("combos", new ArrayList());
        jsonData.put("comboTrees", new ArrayList());
        jsonData.put("comboGrids", new ArrayList());
        JSONObject searchParams = (JSONObject)env.getCurrentNamespace().toMap().get("searchParams");
        env.getCurrentNamespace().put("searchParams", (Object)jsonData);
        if (body != null) {
            body.render(out);
        }
        env.getCurrentNamespace().put("searchParams", (Object)searchParams);
        HTMLElement doc = Document.createElement();
        HTMLElement box = doc.div().id("searchBox" + gridName).style("min-height: 44px").addClass("searchBox");
        TR tr = box.div().addClass("searchTopBox").span().style("float:left").table().attr("cellpadding", "0").attr("cellspacing", "0").tr();
        tr.style("overflow: hidden;height: 22px;").id("rightSearchBox" + gridName);
        tr.td().div().id("topSearchBox" + gridName).style("float: left;").table().addClass("searchTable").attr("cellpadding", "0").attr("cellspacing", "0").tbody().appendContent(jsonData.getString("top"));
        A a = tr.td().attr("valign", "middle").style("display:none").div().id("moreConditionButton" + gridName).addClass("search_more_box").a();
        String more = I18nUtil.i18nCode((String)"common_more", (Object[])new Object[0]);
        String close = I18nUtil.i18nCode((String)"common_search_retract", (Object[])new Object[0]);
        a.id("moreConditionLink" + gridName).attr("href", "javascript:moreScreeningCondition('" + close + "','" + more + "','" + gridName + "')");
        a.span().id("moreConditionText" + gridName).text(more);
        a.span().id("moreConditionIcon" + gridName).addClass("more_arrow_down");
        if (StringUtils.isBlank((CharSequence)jsonData.getString("hideQueryButton"))) {
            HTMLElement query = tr.td().addClass("search_query_td").attr("valign", "middle").div().id("searchButton" + gridName).addClass("search_button_new").style("margin:0px 10px;");
            String queryTxt = I18nUtil.i18nCode((String)"common_search_query", (Object[])new Object[0]);
            query.attr("onclick", "searchButton('" + gridName + "')").attr("title", queryTxt).span().addClass(this.queryIcon);
        }
        if (StringUtils.isBlank((CharSequence)jsonData.getString("hideClearButton"))) {
            HTMLElement clear = tr.td().addClass("search_clear_td").attr("valign", "middle").div().id("searchClearButton" + gridName).addClass("search_clear_button_new").style("margin:0px 10px;");
            String clearTxt = I18nUtil.i18nCode((String)"common_search_clearTitle", (Object[])new Object[0]);
            clear.attr("onclick", "clearCondition('searchBox" + gridName + "','" + gridName + "')").attr("title", clearTxt).span().addClass(this.clearIcon);
        }
        HTMLElement blow = box.div().addClass("searchBelowBox");
        HTMLElement tip = blow.div().id("searchTextDiv" + gridName).addClass("searchBelowBox_tip");
        if (StringUtils.isNotBlank((CharSequence)jsonData.getString("hideTip"))) {
            tip.css("display", "none");
        }
        tip.span().style("font-weight: bold;display:inline-block").text(I18nUtil.i18nCode((String)"common_search_currentQuery", (Object[])new Object[0]));
        tip.span().id("searchText" + gridName).style("padding-left: 5px;").text(I18nUtil.i18nCode((String)"common_none", (Object[])new Object[0]));
        tip.span().id("noSearchText" + gridName).style("display: none").text(I18nUtil.i18nCode((String)"common_none", (Object[])new Object[0]));
        blow.div().id("belowSearchBox" + gridName).addClass("searchBelowBox_input").table().addClass("searchTable2").attr("cellpadding", "0").attr("cellspacing", "0").tbody().appendContent(jsonData.getString("below"));
        jsonData.remove((Object)"top");
        if (!jsonData.getString("below").equals("")) {
            jsonData.remove((Object)"below");
            jsonData.put("hasBelow", (Object)true);
        }
        if (StringUtils.isNotBlank((CharSequence)this.autoReload)) {
            jsonData.put("autoReload", (Object)this.autoReload);
        }
        doc.script().appendContent("new ZKUI.Searchbar(" + jsonData.toJSONString() + ");");
        out.write(doc.toString());
    }
}

