/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ui.web.freemarker.directives;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.ui.web.freemarker.annotation.ZKUIDirective;
import com.zkteco.zkbiosecurity.ui.web.freemarker.tags.Document;
import com.zkteco.zkbiosecurity.ui.web.freemarker.tags.HTMLElement;
import com.zkteco.zkbiosecurity.ui.web.freemarker.util.BeanUtil;
import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
@ZKUIDirective(script="ui/js/ZKLayout.js")
public class Layout
implements TemplateDirectiveModel {
    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        if (body == null) {
            return;
        }
        boolean enableRTL = BeanUtil.enableRTL();
        Writer out = env.getOut();
        JSONObject options = new JSONObject();
        BeanUtil.setParamsToJson(options, params);
        String id = BeanUtil.getParam(params, "id", "layoutBox" + BeanUtil.getUUID());
        options.put("id", (Object)id);
        JSONArray cells = new JSONArray();
        options.put("cells", (Object)cells);
        JSONObject opts = (JSONObject)env.getCurrentNamespace().toMap().get("opts");
        env.getCurrentNamespace().put("opts", (Object)options);
        body.render(out);
        env.getCurrentNamespace().put("opts", (Object)opts);
        if (options.getString("pattern") == null) {
            int cnum = cells.size();
            String[] defPattern = new String[]{"1C", "2U", "3J", "4I", "5I", "6A", "7I"};
            if (cnum > 0 && cnum <= defPattern.length) {
                options.put("pattern", (Object)defPattern[cnum - 1]);
            }
        }
        HTMLElement doc = Document.createElement();
        doc.div().addAttributesOnly(params).id(id).addClass("dhx_layout_box");
        int i = 0;
        while (i < cells.size()) {
            JSONObject cell = cells.getJSONObject(i);
            cell.put("cellId", (Object)(String.valueOf(id) + "cell_" + (char)(97 + i)));
            cell.put("id", (Object)Character.valueOf((char)(97 + i)));
            doc.div().id(String.valueOf(id) + "cell_" + (char)(97 + i)).addClass("dhx_layout_cell_box");
            ++i;
        }
        if (enableRTL) {
            options.put("enableRTL", (Object)true);
        }
        doc.script().appendContent("new ZKUI.Layout(" + options.toJSONString() + ");");
        out.write(doc.toString());
    }
}

