/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ui.web.freemarker.directives;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ui.web.freemarker.annotation.ZKUIDirective;
import com.zkteco.zkbiosecurity.ui.web.freemarker.tags.Document;
import com.zkteco.zkbiosecurity.ui.web.freemarker.tags.HTMLElement;
import com.zkteco.zkbiosecurity.ui.web.freemarker.util.BeanUtil;
import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@ZKUIDirective(script="ui/js/ZKInput.js")
public class Input
implements TemplateDirectiveModel {
    @Value(value="${biosecurity.date.sysDateFmt:yyyy-MM-dd}")
    private String dateFmt;
    @Value(value="${biosecurity.date.sysTimeFmt:HH:mm:ss}")
    private String timeFmt;
    @Value(value="${biosecurity.date.sysDateTimeFmt:yyyy-MM-dd HH:mm:ss}")
    private String dateTimeFmt;
    @Value(value="${system.customCheckbox:true}")
    private Boolean customCheckbox;
    @Value(value="${system.customDate:true}")
    private Boolean customDate;
    @Value(value="${system.customDateFormat:false}")
    private Boolean customDateFormat;

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        String type;
        Writer out = env.getOut();
        JSONObject jsonData = new JSONObject();
        BeanUtil.addRequestParams(jsonData, "useInputReq");
        BeanUtil.setParamsToJson(jsonData, params);
        String uuid = BeanUtil.getUUID();
        String id = BeanUtil.getParams(params, "id", jsonData.getString("id"), "input_" + uuid);
        jsonData.put("id", (Object)id);
        HTMLElement root = Document.createElement();
        String title = I18nUtil.i18nCode((String)BeanUtil.getParams(params, "title", jsonData.getString("title"), ""), (Object[])new Object[0]);
        if (params.get("hideLabel") == null && StringUtils.isBlank((CharSequence)jsonData.getString("hideLabel"))) {
            if (params.get("required") != null) {
                title = String.valueOf(title) + "<span class='required'>*</span>";
            }
            HTMLElement label = root.label().text(title).attr("title", title).addClass("search-label");
            if (params.get("labelWidth") != null) {
                label.width(params.get("labelWidth").toString());
            }
        }
        String ignoreFormat = BeanUtil.getParams(params, "ignoreFormat", jsonData.getString("ignoreFormat"), "");
        String originType = type = BeanUtil.getParams(params, "type", jsonData.getString("type"), "text");
        String value = BeanUtil.getParams(params, "value", jsonData.getString("value"), "");
        StringUtils.isNotBlank((CharSequence)value);
        String name = BeanUtil.getParams(params, "name", jsonData.getString("name"), "");
        if (type.equals("date") || type.equals("datetime") || type.equals("select") || type.equals("color")) {
            type = "text";
        }
        if (type.equals("ip")) {
            String prefix = BeanUtil.getParam(params, "prefix", "ipv4" + uuid);
            jsonData.put("prefix", (Object)prefix);
            name = BeanUtil.getParams(params, "name", jsonData.getString("name"), "ip" + uuid);
            root.div().addAttributes(params).id(id).removeAttr("name").removeAttr("type").addClass("ip_input").style("display:inline-block;");
            root.input().type("hidden").value(value).name(name).id(String.valueOf(id) + "_hidden");
        } else if (type.equals("checkbox")) {
            HTMLElement input = null;
            HTMLElement label = null;
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{jsonData.getString("eventCheck")})) {
                name = BeanUtil.getParams(params, "name", jsonData.getString("name"), id);
                input = root.input().addAttributes((Map)jsonData).id(id).removeAttr("name").type("checkbox");
                if (this.customCheckbox.booleanValue()) {
                    input.addClass("zk-checkbox-custom");
                    label = root.label().addClass("zk-checkbox-custom-lab").attr("for", id).attr("title", title);
                    if (StringUtils.isNotBlank((CharSequence)jsonData.getString("style"))) {
                        label.style(jsonData.getString("style"));
                    }
                    if (StringUtils.isNotBlank((CharSequence)jsonData.getString("class"))) {
                        label.addClass(jsonData.getString("class"));
                    }
                    if (StringUtils.isNotBlank((CharSequence)jsonData.getString("onclick"))) {
                        label.attr("onclick", jsonData.getString("onclick"));
                        input.removeAttr("onclick");
                    }
                }
                root.input().type("hidden").name(name).id(String.valueOf(id) + "_hidden");
            } else {
                input = root.input().addAttributesOnly((Map)jsonData).attr("name", name).type(type).id(id).value(value);
                if (this.customCheckbox.booleanValue()) {
                    input.addClass("zk-checkbox-custom");
                    label = root.label().addClass("zk-checkbox-custom-lab").attr("for", id).attr("title", title);
                    if (StringUtils.isNotBlank((CharSequence)jsonData.getString("style"))) {
                        label.style(jsonData.getString("style"));
                    }
                    if (StringUtils.isNotBlank((CharSequence)jsonData.getString("class"))) {
                        label.addClass(jsonData.getString("class"));
                    }
                    if (StringUtils.isNotBlank((CharSequence)jsonData.getString("onclick"))) {
                        label.attr("onclick", jsonData.getString("onclick"));
                        input.removeAttr("onclick");
                    }
                }
            }
        } else if (!"true".equals(ignoreFormat) && this.customDateFormat.booleanValue() && ("date".equals(originType) || "datetime".equals(originType))) {
            HTMLElement input = root.input().attr("autocomplete", "off").addAttributesOnly((Map)jsonData).attr("name", name).addClass("search-input").type(type).id(id).value(value);
            input.removeAttr("name");
            input.removeAttr("value");
            jsonData.put("customDateFormat", (Object)this.customDateFormat);
            root.input().type("hidden").value(value).attr("name", jsonData.getString("name")).id(String.valueOf(id) + "_value");
        } else {
            HTMLElement input = root.input().attr("autocomplete", "off").addAttributesOnly((Map)jsonData).attr("name", name).addClass("search-input").type(type).id(id).value(value);
            if ("select".equals(jsonData.getString("type"))) {
                input.removeAttr("name");
                root.input().type("hidden").value(value).attr("name", jsonData.getString("name")).id(String.valueOf(id) + "_value");
            }
        }
        jsonData.put("value", (Object)value);
        jsonData.put("customDate", (Object)this.customDate);
        root.script().appendContent("new ZKUI.Input(" + jsonData.toJSONString() + ")");
        out.write(root.toString());
    }
}

