/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ui.web.freemarker.directives;

import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.web.extend.ExtendJSAndCSS;
import com.zkteco.zkbiosecurity.ui.web.freemarker.annotation.ZKDirective;
import com.zkteco.zkbiosecurity.ui.web.freemarker.annotation.ZKUIDirective;
import com.zkteco.zkbiosecurity.ui.web.freemarker.util.BeanUtil;
import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@ZKDirective(value="uiScript")
public class ImportUIScript
implements TemplateDirectiveModel {
    @Autowired
    private TemplateModel[] templates;
    @Autowired
    private ExtendJSAndCSS[] exts;
    @Value(value="${system.packageTime:}")
    private String packageTime;
    @Value(value="${system.devMode:true}")
    private Boolean devMode;
    private String uuid;

    public void execute(Environment env, Map arg1, TemplateModel[] arg2, TemplateDirectiveBody arg3) throws TemplateException, IOException {
        Writer out = env.getOut();
        this.uuid = BeanUtil.getUUID();
        try {
            if (StringUtils.isNotBlank((CharSequence)this.packageTime) && !this.packageTime.matches("[\\d]+")) {
                this.packageTime = "" + DateUtil.stringToDate((String)this.packageTime.replaceAll("[\\\\]+", ""), (String)"yyyy-MM-dd HH:mm:ss").getTime();
            }
        }
        catch (Exception e) {
            this.packageTime = "";
        }
        String content = "";
        String onlyUI = BeanUtil.getParam(arg1, "onlyUI", "");
        content = "true".equalsIgnoreCase(onlyUI) ? this.appendUIScript() : String.valueOf(this.appendUIScript()) + this.appendExts();
        out.write(content);
    }

    private String appendUIScript() {
        String content = "";
        if (this.templates != null && this.templates.length > 0) {
            TemplateModel[] templateModelArray = this.templates;
            int n = this.templates.length;
            int n2 = 0;
            while (n2 < n) {
                TemplateModel temp = templateModelArray[n2];
                ZKUIDirective directive = temp.getClass().getAnnotation(ZKUIDirective.class);
                if (directive != null) {
                    String css;
                    String script = directive.script();
                    if (!"".equals(script)) {
                        content = String.valueOf(content) + this.appendScript(script);
                    }
                    if (!"".equals(css = directive.css())) {
                        content = String.valueOf(content) + this.appendCss(css);
                    }
                }
                ++n2;
            }
        }
        return content;
    }

    private String appendExts() {
        String content = "";
        if (this.exts != null && this.exts.length > 0) {
            ExtendJSAndCSS[] extendJSAndCSSArray = this.exts;
            int n = this.exts.length;
            int n2 = 0;
            while (n2 < n) {
                ExtendJSAndCSS ext = extendJSAndCSSArray[n2];
                List extContent = ext.extend();
                if (extContent != null && !extContent.isEmpty()) {
                    int i = 0;
                    while (i < extContent.size()) {
                        String c = (String)extContent.get(i);
                        if (c.endsWith(".js")) {
                            content = String.valueOf(content) + this.appendScript(c);
                        } else if (c.endsWith(".jsi")) {
                            content = String.valueOf(content) + this.appendI18nScript(c.substring(0, c.length() - 1));
                        } else if (c.endsWith(".css")) {
                            content = String.valueOf(content) + this.appendCss(c);
                        } else if (!c.equals("")) {
                            content = String.valueOf(content) + this.appendScript(String.valueOf(c) + ".js");
                        }
                        ++i;
                    }
                }
                ++n2;
            }
        }
        return content;
    }

    private String appendScript(String path) {
        return "<script type='text/javascript' src='" + path + "'></script>";
    }

    private String appendI18nScript(String path) {
        return "<script type='text/javascript'>I18n.script('" + path + "');</script>";
    }

    private String appendCss(String path) {
        return "<link rel='stylesheet' type='text/css' href='" + path + "'/>";
    }
}

