/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ui.web.freemarker.directives;

import com.zkteco.zkbiosecurity.ui.web.freemarker.annotation.ZKDirective;
import com.zkteco.zkbiosecurity.ui.web.freemarker.tags.Document;
import com.zkteco.zkbiosecurity.ui.web.freemarker.tags.HTMLElement;
import com.zkteco.zkbiosecurity.ui.web.freemarker.util.BeanUtil;
import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
@ZKDirective(value="fontStyle")
public class ImportFontStyle
implements TemplateDirectiveModel {
    public void execute(Environment env, Map params, TemplateModel[] arg2, TemplateDirectiveBody arg3) throws TemplateException, IOException {
        if (this.isIE()) {
            Writer out = env.getOut();
            HTMLElement doc = Document.createElement();
            String fontName = BeanUtil.getParam(params, "fontName", "");
            String fontSrc = BeanUtil.getParam(params, "fontSrc", "");
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{fontName, fontSrc})) {
                String cont = this.readFontFile(fontSrc);
                String s = "@font-face {  font-family: '" + fontName + "';" + "  src:  url('" + cont + "');" + "  src:  url('" + cont + "') format('embedded-opentype')," + "  font-weight: normal;" + "  font-style: normal;" + "  font-display: block;" + "}";
                doc.style().appendContent(s);
                out.write(doc.toString());
            }
        }
    }

    private String readFontFile(String path) {
        String cont = null;
        try {
            InputStream in = this.getClass().getResourceAsStream("/static/" + path);
            if (Objects.nonNull(in)) {
                byte[] src = new byte[in.available()];
                in.read(src);
                cont = new String(Base64.getEncoder().encode(src), "UTF-8");
                cont = "data:application/vnd.ms-fontobject;charset=utf-8;base64," + cont;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cont;
    }

    private boolean isIE() {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        HttpServletRequest request = servletRequestAttributes.getRequest();
        String userAgent = request.getHeader("User-Agent");
        return StringUtils.isNotBlank((CharSequence)userAgent) && (userAgent.toLowerCase().contains("msie") || userAgent.toLowerCase().contains("trident"));
    }
}

