/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ui.web.freemarker.directives;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.core.utils.ApplicationPropertiesUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.ui.web.freemarker.annotation.ZKUIDirective;
import com.zkteco.zkbiosecurity.ui.web.freemarker.tags.Document;
import com.zkteco.zkbiosecurity.ui.web.freemarker.tags.HTMLElement;
import com.zkteco.zkbiosecurity.ui.web.freemarker.util.BeanUtil;
import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
@ZKUIDirective(value="Grid", script="ui/js/ZKGrid.js")
public class Grid
implements TemplateDirectiveModel {
    @Value(value="${system.gridIconFont:}")
    private String gridIconFont;

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        String gridName;
        boolean enableRTL = BeanUtil.enableRTL();
        JSONObject jsonData = new JSONObject();
        this.addRequestParams(jsonData);
        BeanUtil.setParamsToJson(jsonData, params);
        JSONObject options = (JSONObject)env.getCurrentNamespace().toMap().get("options");
        if (options != null) {
            jsonData = this.mergeJSON(options, jsonData);
        }
        if (StringUtils.isEmpty((CharSequence)(gridName = jsonData.getString("gridName")))) {
            gridName = "gridbox" + BeanUtil.getUUID();
            jsonData.put("gridName", (Object)gridName);
        }
        String vo = jsonData.getString("vo");
        HTMLElement doc = Document.createElement();
        doc.div().id(gridName);
        if (StringUtils.isEmpty((CharSequence)jsonData.getString("nopaging"))) {
            doc.div().id(String.valueOf(gridName) + "_paging");
        }
        this.gridIconFont = ApplicationPropertiesUtil.getProperty((String)"system.gridIconFont", (String)"");
        JSONObject headData = GridUtil.getGridHeader((String)vo, (String)gridName, (String)this.gridIconFont);
        jsonData = this.mergeJSON(jsonData, headData);
        jsonData.put("query", (Object)this.getQueryPath(jsonData));
        if (jsonData.getString("queryParam") != null || !"".equals(jsonData.getString("queryParam"))) {
            jsonData.put("queryParam", (Object)JSONObject.parseObject((String)jsonData.getString("queryParam")));
        }
        if (enableRTL) {
            jsonData.put("enableRTL", (Object)true);
        }
        if (StringUtils.isNotBlank((CharSequence)this.gridIconFont)) {
            jsonData.put("gridIconFont", (Object)this.gridIconFont);
        }
        doc.script().appendContent("new ZKUI.Grid(" + jsonData.toJSONString() + ")");
        Writer out = env.getOut();
        out.write(doc.toString());
    }

    private JSONObject mergeJSON(JSONObject src, JSONObject tag) {
        JSONObject newSrc = src.clone();
        Set entrys = tag.entrySet();
        entrys.forEach(entry -> newSrc.put((String)entry.getKey(), entry.getValue()));
        return newSrc;
    }

    private String getQueryPath(JSONObject params) {
        if (StringUtils.isEmpty((CharSequence)params.getString("query"))) {
            String vo = params.getString("vo");
            String entityName = vo.substring(vo.lastIndexOf(".") + 1, vo.length() - 4);
            entityName = String.valueOf(String.valueOf(entityName.charAt(0)).toLowerCase()) + entityName.substring(1);
            return "/" + entityName + ".do?list";
        }
        return params.getString("query");
    }

    private void addRequestParams(JSONObject opts) {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        HttpServletRequest request = servletRequestAttributes.getRequest();
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (BeanUtil.isIllegal(name) || BeanUtil.isIllegal(request.getParameter(name))) continue;
            opts.put(name, (Object)request.getParameter(name));
        }
    }
}

