/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ui.web.freemarker.directives;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ui.web.freemarker.annotation.ZKUIDirective;
import com.zkteco.zkbiosecurity.ui.web.freemarker.tags.Document;
import com.zkteco.zkbiosecurity.ui.web.freemarker.tags.HTMLElement;
import com.zkteco.zkbiosecurity.ui.web.freemarker.util.BeanUtil;
import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
@ZKUIDirective(script="ui/js/ZKComboGrid.js")
public class ComboGrid
implements TemplateDirectiveModel {
    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        List comboTrees;
        String id;
        Writer out = env.getOut();
        JSONObject options = new JSONObject();
        BeanUtil.addRequestParams(options, "useComGridReq");
        BeanUtil.setParamsToJson(options, params);
        String gridName = options.getString("gridName");
        if (StringUtils.isBlank((CharSequence)gridName)) {
            gridName = "gridbox" + BeanUtil.getUUID();
            options.put("gridName", (Object)gridName);
        }
        String title = I18nUtil.i18nCode((String)BeanUtil.getParam(params, "title", ""), (Object[])new Object[0]);
        HTMLElement doc = Document.createElement();
        HTMLElement div = doc.div().addClass("search-combo-box").attr("title", title);
        if (params.get("hideLabel") == null) {
            if (params.get("required") != null) {
                title = String.valueOf(title) + "<span class='required'>*</span>";
            }
            HTMLElement label = div.label().text(title).addClass("search-label");
            if (params.get("labelWidth") != null) {
                label.width(params.get("labelWidth").toString());
            }
        }
        id = StringUtils.isBlank((CharSequence)(id = options.getString("id"))) ? "comboGrid" + BeanUtil.getUUID() : id;
        options.put("id", (Object)id);
        JSONObject opt = (JSONObject)env.getCurrentNamespace().toMap().get("searchParams");
        if (opt != null && (comboTrees = (List)opt.getObject("comboGrids", List.class)) != null) {
            comboTrees.add(id);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{options.getString("searchText")})) {
            options.put("searchText", (Object)I18nUtil.i18nCode((String)options.getString("searchText"), (Object[])new Object[0]));
        }
        div.div().addAttributesOnly(params).id(id).attr("title", title);
        div.script().appendContent("new ZKUI.ComboGrid(" + options.toJSONString() + ");");
        out.write(doc.toString());
    }
}

