/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ui.web.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.bean.ProcessBean;
import com.zkteco.zkbiosecurity.base.bean.SystemTip;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.config.PropertiesListenerConfig;
import com.zkteco.zkbiosecurity.core.utils.ApplicationPropertiesUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.core.web.extend.IFrontI18nKeys;
import com.zkteco.zkbiosecurity.ui.web.freemarker.util.BeanUtil;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@ConditionalOnWebApplication
@Controller
public class SkipController
extends BaseController {
    @Autowired
    private ProgressCache progressCache;
    @Value(value="${system.language:zh_CN}")
    private String language;
    @Value(value="${system.oem:false}")
    private String oem;
    @Value(value="${biosecurity.date.sysDateFmt:yyyy-MM-dd}")
    private String sysDateFmt;
    @Value(value="${biosecurity.date.sysTimeFmt:HH:mm:ss}")
    private String sysTimeFmt;
    @Value(value="${biosecurity.date.sysDateTimeFmt:yyyy-MM-dd HH:mm:ss}")
    private String sysDateTimeFmt;
    @Value(value="${date.dhxDateFmt:%Y-%m-%d}")
    private String dhxDateFmt;
    @Value(value="${date.dhxTimeFmt:%H:%i:%s}")
    private String dhxTimeFmt;
    @Value(value="${system.skin:default}")
    private String skin;
    @Value(value="${system.headLogo_thumb:}")
    private String headLogo;
    @Value(value="${system.securityLevel:0}")
    private int securityLevel;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private IFrontI18nKeys[] i18nKeys;
    @Autowired
    private Configuration configuration;

    @RequestMapping(value={"skip.do"})
    public ModelAndView skip(@RequestParam String page) {
        String pagePath = page.replaceAll("_", "/");
        Enumeration paramNames = this.request.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            this.request.setAttribute(paramName, (Object)this.request.getParameter(paramName));
        }
        return new ModelAndView(pagePath);
    }

    @RequestMapping(value={"complieJSFile.do"}, produces={"application/javascript"})
    @ResponseBody
    public String complieJSFile(@RequestParam String file) {
        String pagePath = file.replaceAll("_", "/");
        return this.compile(pagePath);
    }

    @RequestMapping(value={"complieCSSFile.do"}, produces={"text/css"})
    @ResponseBody
    public String complieCSSFile(@RequestParam String file) {
        String pagePath = file.replaceAll("_", "/");
        return this.compile(pagePath);
    }

    private String compile(String path) {
        String s = null;
        try {
            StringWriter out = new StringWriter();
            Template t = this.configuration.getTemplate(path);
            t.process(new HashMap(), (Writer)out);
            s = out.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return s;
    }

    @RequestMapping(value={"getI18n.do"})
    @ResponseBody
    public ZKResultMsg getI18n(String code) {
        ZKResultMsg ret = new ZKResultMsg();
        JSONObject data = new JSONObject();
        if (!StringUtils.isEmpty((CharSequence)code)) {
            String[] codes;
            String[] stringArray = codes = code.split(",");
            int n = codes.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                data.put(key, (Object)I18nUtil.i18nCode((String)key, (Object[])new Object[0]));
                ++n2;
            }
        }
        ret.setData((Object)data);
        return ret;
    }

    private void loadSystemProperty(JSONObject data) {
        JSONObject systemProp = new JSONObject();
        for (Map.Entry entry : PropertiesListenerConfig.getSystemProperty().entrySet()) {
            if (!((String)entry.getKey()).startsWith("system.frontProps.")) continue;
            systemProp.put(((String)entry.getKey()).substring(18), entry.getValue());
        }
        data.put("frontProps", (Object)systemProp);
    }

    @RequestMapping(value={"getSysParams.do"})
    @ResponseBody
    public ZKResultMsg getSysParams() {
        ZKResultMsg ret = new ZKResultMsg();
        JSONObject data = new JSONObject();
        data.put("language", (Object)this.language);
        String clientlanguage = BeanUtil.getCurrentLanguage();
        data.put("clientLanguage", (Object)clientlanguage);
        data.put("oem", (Object)this.oem);
        data.put("devMode", (Object)(!"pro".equals(System.getProperty("spring.profiles.active")) ? 1 : 0));
        data.put("sysDateFmt", (Object)this.sysDateFmt);
        data.put("sysTimeFmt", (Object)this.sysTimeFmt);
        data.put("sysDateTimeFmt", (Object)this.sysDateTimeFmt);
        this.dhxDateFmt = ApplicationPropertiesUtil.getProperty((String)"date.dhxDateFmt", (String)this.dhxDateFmt);
        this.dhxTimeFmt = ApplicationPropertiesUtil.getProperty((String)"date.dhxTimeFmt", (String)this.dhxTimeFmt);
        data.put("dhxDateFmt", (Object)this.dhxDateFmt);
        data.put("dhxTimeFmt", (Object)this.dhxTimeFmt);
        this.skin = ApplicationPropertiesUtil.getProperty((String)"system.skin", (String)"default");
        data.put("skin", (Object)this.skin);
        this.headLogo = ApplicationPropertiesUtil.getProperty((String)"system.headLogo_thumb", (String)"");
        data.put("headLogo", (Object)this.headLogo);
        data.put("msgStyle", (Object)ApplicationPropertiesUtil.getProperty((String)"system.msgStyle", (String)""));
        data.put("securityLevel", (Object)this.securityLevel);
        this.loadSystemProperty(data);
        ret.setData((Object)data);
        return ret;
    }

    @RequestMapping(value={"/portalI18nLoader"}, produces={"application/javascript"})
    @ResponseBody
    public String i18nLoader() {
        StringBuffer content = new StringBuffer();
        if (this.i18nKeys != null && this.i18nKeys.length > 0) {
            content.append("if(localStorage){");
            TreeSet items = new TreeSet();
            IFrontI18nKeys[] iFrontI18nKeysArray = this.i18nKeys;
            int n = this.i18nKeys.length;
            int n2 = 0;
            while (n2 < n) {
                IFrontI18nKeys key = iFrontI18nKeysArray[n2];
                items.addAll(key.keys());
                ++n2;
            }
            String value = null;
            for (String item : items) {
                if (item.equals(value = I18nUtil.i18nCode((String)item, (Object[])new Object[0]))) continue;
                content.append("localStorage.setItem(\"" + item + "\",\"" + value.replaceAll("\"", "\\\\\"") + "\");");
            }
            content.append("}");
        }
        return content.toString();
    }

    @RequestMapping(value={"skip.do"}, params={"getProcess"})
    @ResponseBody
    public ProcessBean getProcess(String clientId) {
        return this.progressCache.getProcess();
    }

    @RequestMapping(value={"skip.do"}, params={"getExportResult"})
    @ResponseBody
    public ZKResultMsg getExportResult() {
        String result = (String)this.stringRedisTemplate.opsForValue().get((Object)("export-result:" + this.request.getSession().getId()));
        return new ZKResultMsg((Object)result);
    }

    @RequestMapping(value={"skip.do"}, params={"getImportResult"})
    @ResponseBody
    public ZKResultMsg getImportResult() {
        String result = (String)this.stringRedisTemplate.opsForValue().get((Object)("import-result:" + this.request.getSession().getId()));
        return new ZKResultMsg((Object)result);
    }

    @RequestMapping(value={"skip.do"}, params={"keepalive"})
    @ResponseBody
    public ZKResultMsg keepalive() {
        return new ZKResultMsg();
    }

    @RequestMapping(value={"skip.do"}, params={"getSystemTip"})
    @ResponseBody
    public JSONArray getSystemTip() {
        JSONArray ret = new JSONArray();
        SystemTip tip1 = new SystemTip();
        tip1.setShowName("\u4e3a\u4e86\u4fbf\u4e8e\u627e\u56de\u5bc6\u7801\uff0c\u8bf7\u5b8c\u5584\u90ae\u7bb1\u4fe1\u606f\uff01");
        tip1.setHref("javascript:void($('#userInfo').click())");
        tip1.setOperateName("\u7acb\u5373\u5b8c\u5584");
        ret.add((Object)tip1);
        tip1 = new SystemTip();
        tip1.setShowName("\u68c0\u67e5\u5230\u4eba\u5458\u4fe1\u606f\u6709\u5f02\u5e38\uff01");
        tip1.setHref("javascript:void(0)");
        tip1.setOperateName("\u7acb\u5373\u5904\u7406");
        ret.add((Object)tip1);
        return ret;
    }

    @RequestMapping(value={"skip.do"}, params={"testDealData"})
    @ResponseBody
    public String testDealData() {
        try {
            int totalCount = 15;
            int currentCount = 10;
            this.progressCache.beginProcess(String.valueOf(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0])) + "<br/>");
            int i = 1;
            while (i <= totalCount) {
                int totalProcess = (i - 1) * 100 / totalCount;
                this.progressCache.setProcess(new ProcessBean(0, totalProcess, totalCount - i, "<font color='#ebdd37'>\u6b63\u5728\u8fde\u63a5\u8bbe\u59070000" + i + "................</font><br/>", "\u5f53\u524d0000" + i + "\u8bbe\u5907\u8fdb\u5ea6"));
                int j = 1;
                while (j <= currentCount) {
                    this.progressCache.setProcess(new ProcessBean(j * 100 / currentCount, totalProcess, totalCount - i, "", "\u5f53\u524d0000" + i + "\u8bbe\u5907\u8fdb\u5ea6"));
                    Thread.sleep(200L);
                    ++j;
                }
                if (i == 2) {
                    this.progressCache.setProcess(new ProcessBean(0, totalProcess, totalCount - i, "<font color='red'>\u8bbe\u59070000" + i + "\u8fde\u63a5\u5931\u8d25!!!!!!!!!!!!!!</font><br/>", "\u5f53\u524d0000" + i + "\u8bbe\u5907\u8fdb\u5ea6"));
                } else {
                    this.progressCache.setProcess(new ProcessBean(0, totalProcess, totalCount - i, "<font color='#5debb0'>\u8bbe\u59070000" + i + "\u8fde\u63a5\u6210\u529f!!!!!!!!!!!!!!</font><br/>", "\u5f53\u524d0000" + i + "\u8bbe\u5907\u8fdb\u5ea6"));
                }
                Thread.sleep(200L);
                ++i;
            }
            this.progressCache.finishProcess("\u5df2\u5b8c\u6210", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0]), I18nUtil.i18nCode((String)"common_op_totalProgress", (Object[])new Object[0]));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return "true";
    }
}

