/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cmd.sec.user;

import com.zkteco.zkbiosecurity.cmd.sec.device.CmdDevice;
import com.zkteco.zkbiosecurity.cmd.sec.user.CmdUser;
import com.zkteco.zkbiosecurity.cmd.sec.utils.CmdSecUtil;
import java.util.Collection;
import java.util.Objects;

public class CmdUserConstructor {
    public static String setUser(Collection<CmdUser> cmdUsers, CmdDevice cmdDevice) {
        if (cmdUsers != null && cmdUsers.size() > 0) {
            boolean isSupportTimeEncode = "1".equals(cmdDevice.getDateFmtFunOn());
            boolean isSupportSupAuth = "1".equals(cmdDevice.getSupAuthrizeFunOn());
            boolean isSupportDisable = "1".equals(cmdDevice.getDisableUserFunOn());
            boolean isSupportIdCard = "1".equals(cmdDevice.getAccSupportFunList(30));
            boolean isSupportName = false;
            if ("1".equals(cmdDevice.getUserNameFunOn()) || !CmdSecUtil.isC3Device(cmdDevice.getMachineType()).booleanValue()) {
                isSupportName = true;
            }
            boolean isSupportManageAuth = CmdSecUtil.isStandaloneDevice(cmdDevice.getMachineType()) != false;
            StringBuffer cmdContent = new StringBuffer();
            for (CmdUser cmdUser : cmdUsers) {
                long start;
                String cmd = "";
                long l = cmdUser.getStartTime() == null ? 0L : (start = (isSupportTimeEncode ? CmdSecUtil.encodeTime(cmdUser.getStartTime()) : CmdSecUtil.encodeDate(cmdUser.getStartTime())).longValue());
                long end = cmdUser.getEndTime() == null ? 0L : (isSupportTimeEncode ? CmdSecUtil.encodeTime(cmdUser.getEndTime()) : CmdSecUtil.encodeDate(cmdUser.getEndTime()));
                cmd = String.format("CardNo=%s\tPin=%s\tPassword=%s\tGroup=%d\tStartTime=%s\tEndTime=%s", cmdUser.getCardNo(), cmdUser.getPin(), cmdUser.getPassword(), cmdUser.getGroup(), start, end);
                if (isSupportName) {
                    cmd = cmd + String.format("\tName=%s", cmdUser.getName());
                }
                if (isSupportIdCard) {
                    cmd = cmd + String.format("\tViceCard=%s", Objects.nonNull(cmdUser.getViceCard()) ? cmdUser.getViceCard() : "");
                }
                if (isSupportSupAuth) {
                    cmd = cmd + String.format("\tSuperAuthorize=%s", cmdUser.getSuperAuthorize());
                }
                if (isSupportManageAuth) {
                    cmd = cmd + String.format("\tPrivilege=%s", Objects.nonNull(cmdUser.getPrivilege()) ? cmdUser.getPrivilege() : (short)0);
                }
                if (isSupportDisable) {
                    String disabled = "0";
                    if (Objects.nonNull(cmdUser.getDisabled()) && cmdUser.getDisabled().booleanValue()) {
                        disabled = "1";
                    }
                    cmd = cmd + String.format("\tDisable=%s", disabled);
                }
                cmd = cmd + "\r\n";
                cmdContent.append(cmd);
            }
            return CmdUser.SET_USER_HEAD + cmdContent.toString();
        }
        return null;
    }

    public static String setUserToChildDev(Collection<CmdUser> cmdUsers) {
        if (cmdUsers != null && cmdUsers.size() > 0) {
            StringBuffer cmdContent = new StringBuffer();
            for (CmdUser cmdUser : cmdUsers) {
                cmdContent.append(String.format("Pin=%s\r\n", cmdUser.getPin()));
            }
            return CmdUser.SET_USER_HEAD + cmdContent.toString();
        }
        return null;
    }

    public static String delUser(Collection<String> pins) {
        if (pins != null && pins.size() > 0) {
            StringBuffer cmdContent = new StringBuffer();
            for (String pin : pins) {
                cmdContent.append(String.format("Pin=%s\r\n", pin));
            }
            return CmdUser.DEL_USER_HEAD + cmdContent;
        }
        return null;
    }

    public static String delAllUser() {
        return CmdUser.DEL_USER_HEAD + "*\r\n";
    }

    public static String getAllUser() {
        return String.format("DATA QUERY tablename=%s,fielddesc=%s,filter=%s\r\n", "user", "*", "*");
    }

    public static String getUserCount() {
        return String.format("DATA COUNT %s ", "user");
    }
}

