/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cmd.sec.extuser;

import com.zkteco.zkbiosecurity.cmd.sec.device.CmdDevice;
import com.zkteco.zkbiosecurity.cmd.sec.extuser.CmdExtuser;
import java.util.Collection;

public class CmdExtuserConstructor {
    public static String setExtuser(Collection<CmdExtuser> cmdExtusers, CmdDevice cmdDevice) {
        if (CmdExtuserConstructor.isSupportExtuser(cmdDevice).booleanValue() && cmdExtusers != null && cmdExtusers.size() > 0) {
            boolean isCleanTempUser = "1".equals(cmdDevice.getAccSupportFunList(9));
            boolean isSupportLongName = "1".equals(cmdDevice.getAccSupportFunList(5));
            StringBuffer cmdContent = new StringBuffer();
            cmdExtusers.forEach(cmdExtuser -> {
                String delayPassage = cmdExtuser.getDelayPassage() != null ? (cmdExtuser.getDelayPassage().booleanValue() ? "1" : "0") : "0";
                String tempUser = "";
                if (isCleanTempUser) {
                    tempUser = cmdExtuser.getTempUser() != null ? (cmdExtuser.getTempUser().booleanValue() ? "1" : "0") : "0";
                }
                String funSwitch = tempUser + delayPassage;
                String cmd = String.format("Pin=%s\tFunSwitch=%s", cmdExtuser.getPin(), Integer.parseInt(funSwitch, 2));
                if (isSupportLongName) {
                    cmd = cmd + String.format("\tFirstName=%s\tLastName=%s", cmdExtuser.getFirstName() != null ? cmdExtuser.getFirstName() : "", cmdExtuser.getLastName() != null ? cmdExtuser.getLastName() : "");
                }
                if (cmdDevice.getMachineType() == 104 && cmdExtuser.getPhoto() != null) {
                    cmd = cmd + String.format("\tPhoto=%s", cmdExtuser.getPhoto());
                }
                cmd = cmd + "\r\n";
                cmdContent.append(cmd);
            });
            return CmdExtuser.SET_EXTUSER_HEAD + cmdContent.toString();
        }
        return null;
    }

    public static String delExtuser(Collection<String> pins, CmdDevice cmdDevice) {
        if (CmdExtuserConstructor.isSupportExtuser(cmdDevice).booleanValue() && pins != null && pins.size() > 0) {
            StringBuffer cmdContent = new StringBuffer();
            pins.forEach(pin -> cmdContent.append(String.format("Pin=%s\r\n", pin)));
            return CmdExtuser.DEL_EXTUSER_HEAD + cmdContent.toString();
        }
        return null;
    }

    public static String delAllExtuser(CmdDevice cmdDevice) {
        if (CmdExtuserConstructor.isSupportExtuser(cmdDevice).booleanValue()) {
            return CmdExtuser.DEL_EXTUSER_HEAD + "*\r\n";
        }
        return null;
    }

    private static Boolean isSupportExtuser(CmdDevice cmdDevice) {
        return "1".equals(cmdDevice.getUserOpenDoorDelayFunOn()) || "1".equals(cmdDevice.getAccSupportFunList(5));
    }

    public static String getAllExtuser(CmdDevice cmdDevice) {
        if (CmdExtuserConstructor.isSupportExtuser(cmdDevice).booleanValue()) {
            return String.format("DATA QUERY tablename=%s,fielddesc=%s,filter=%s\r\n", "extuser", "*", "*");
        }
        return null;
    }
}

