/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cmd.sec.biotemplate;

import com.zkteco.zkbiosecurity.cmd.sec.biophoto.CmdBiophoto;
import com.zkteco.zkbiosecurity.cmd.sec.biophoto.CmdBiophotoConstructor;
import com.zkteco.zkbiosecurity.cmd.sec.biotemplate.CmdBioTemplate;
import com.zkteco.zkbiosecurity.cmd.sec.device.CmdDevice;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CmdBioTemplateConstructor {
    public static List<String> setBioTemplate(CmdDevice cmdDevice, Collection<CmdBioTemplate> cmdBioTemplates) {
        if (cmdBioTemplates != null && cmdBioTemplates.size() > 0) {
            ArrayList<String> cmdList = new ArrayList<String>();
            StringBuffer fpContent = new StringBuffer();
            HashMap<Short, StringBuffer> biodataContentMap = new HashMap<Short, StringBuffer>();
            StringBuffer faceContent = new StringBuffer();
            StringBuffer fvContent = new StringBuffer();
            ArrayList<CmdBiophoto> cmdBiophotoList = new ArrayList<CmdBiophoto>();
            CmdBiophoto biophoto = null;
            HashSet<String> visilightUseTempPins = new HashSet<String>();
            boolean isSupportFP = CmdBioTemplateConstructor.isSupportFP(cmdDevice);
            boolean isSupportFace = CmdBioTemplateConstructor.isSupportFace(cmdDevice);
            boolean isSupportFV = CmdBioTemplateConstructor.isSupportFV(cmdDevice);
            boolean isSupportFP12 = CmdBioTemplateConstructor.isSupportFP12(cmdDevice);
            boolean isSupportVisilight = CmdBioTemplateConstructor.isSupportVisilight(cmdDevice);
            boolean isSupportPv = CmdBioTemplateConstructor.isSupportPv(cmdDevice);
            HashSet tempMap = new HashSet();
            cmdBioTemplates.stream().forEach(cmdBioTemplate -> {
                if (cmdBioTemplate.getType() == 1) {
                    tempMap.add(cmdBioTemplate.getPin() + "_" + cmdBioTemplate.getTemplateId() + "_" + cmdBioTemplate.getVersion());
                }
            });
            for (CmdBioTemplate cmdBioTemplate2 : cmdBioTemplates) {
                if (cmdBioTemplate2.getType() == 1) {
                    if (cmdDevice.getMultiBioDataSupport() != null && cmdDevice.getMultiBioDataSupport().length() > 0) {
                        if (!"1".equals(cmdDevice.getMultiBioDataSupport((short)1)) || Float.parseFloat(cmdBioTemplate2.getVersion()) != Float.parseFloat(cmdDevice.getMultiBioVersion((short)1))) continue;
                        CmdBioTemplateConstructor.formatBioDataContent(biodataContentMap, cmdBioTemplate2, cmdList);
                        continue;
                    }
                    if (!isSupportFP) continue;
                    if (isSupportFP12) {
                        if (cmdBioTemplate2.getVersion().equals("10")) {
                            String tempKey = cmdBioTemplate2.getPin() + "_" + cmdBioTemplate2.getTemplateId() + "_12";
                            boolean bioTemplate = tempMap.contains(tempKey);
                            if (bioTemplate) continue;
                            CmdBioTemplateConstructor.formatBioDataContent(biodataContentMap, cmdBioTemplate2, cmdList);
                            continue;
                        }
                        if (!cmdBioTemplate2.getVersion().equals("12")) continue;
                        CmdBioTemplateConstructor.formatBioDataContent(biodataContentMap, cmdBioTemplate2, cmdList);
                        continue;
                    }
                    if (!"10".equals(cmdBioTemplate2.getVersion())) continue;
                    fpContent.append(String.format("Pin=%s\tFingerID=%s\tValid=%s\tTemplate=%s\r\n", cmdBioTemplate2.getPin(), cmdBioTemplate2.getTemplateId(), cmdBioTemplate2.getDuress() != false ? 3 : 1, cmdBioTemplate2.getTemplate()));
                    if (fpContent.length() / 1024 < 40) continue;
                    cmdList.add(CmdBioTemplate.SET_FPTEMPLATE_HEAD + fpContent.toString());
                    fpContent.setLength(0);
                    continue;
                }
                if (cmdBioTemplate2.getType() == 2) {
                    if (cmdDevice.getMultiBioDataSupport() != null && cmdDevice.getMultiBioDataSupport().length() > 0) {
                        if (!"1".equals(cmdDevice.getMultiBioDataSupport((short)2)) || Float.parseFloat(cmdBioTemplate2.getVersion()) != Float.parseFloat(cmdDevice.getMultiBioVersion((short)2))) continue;
                        CmdBioTemplateConstructor.formatBioDataContent(biodataContentMap, cmdBioTemplate2, cmdList);
                        continue;
                    }
                    if (!isSupportFace || isSupportVisilight || !"7".equals(cmdBioTemplate2.getVersion())) continue;
                    faceContent.append(String.format("Pin=%s\tFaceID=%s\tValid=%s\tFace=%s\r\n", cmdBioTemplate2.getPin(), cmdBioTemplate2.getTemplateIndex(), cmdBioTemplate2.getDuress() != false ? 3 : 1, cmdBioTemplate2.getTemplate()));
                    if (faceContent.length() / 1024 < 40) continue;
                    cmdList.add(CmdBioTemplate.SET_FACEV7_HEAD + faceContent.toString());
                    faceContent.setLength(0);
                    continue;
                }
                if (cmdBioTemplate2.getType() == 7) {
                    if (cmdDevice.getMultiBioDataSupport() != null && cmdDevice.getMultiBioDataSupport().length() > 0) {
                        if (!"1".equals(cmdDevice.getMultiBioDataSupport((short)7)) || Float.parseFloat(cmdBioTemplate2.getVersion()) != Float.parseFloat(cmdDevice.getMultiBioVersion((short)7))) continue;
                        CmdBioTemplateConstructor.formatBioDataContent(biodataContentMap, cmdBioTemplate2, cmdList);
                        continue;
                    }
                    if (!isSupportFV) continue;
                    fvContent.append(String.format("Pin=%s\tFingerid=%s\tIndex=%d\tDuress=%s\tTemplate=%s\r\n", cmdBioTemplate2.getPin(), cmdBioTemplate2.getTemplateId(), cmdBioTemplate2.getTemplateIndex(), cmdBioTemplate2.getDuress() != false ? 3 : 1, cmdBioTemplate2.getTemplate()));
                    if (fvContent.length() / 1024 < 40) continue;
                    cmdList.add(CmdBioTemplate.SET_FVTEMPLATE_HEAD + fvContent.toString());
                    fvContent.setLength(0);
                    continue;
                }
                if (cmdBioTemplate2.getType() == 8) {
                    if (cmdDevice.getMultiBioDataSupport() != null && cmdDevice.getMultiBioDataSupport().length() > 0) {
                        if (!"1".equals(cmdDevice.getMultiBioDataSupport((short)8)) || Float.parseFloat(cmdBioTemplate2.getVersion()) != Float.parseFloat(cmdDevice.getMultiBioVersion((short)8))) continue;
                        CmdBioTemplateConstructor.formatBioDataContent(biodataContentMap, cmdBioTemplate2, cmdList);
                        continue;
                    }
                    if (!isSupportPv || !cmdBioTemplate2.getVersion().equals(cmdDevice.getPvVersion())) continue;
                    CmdBioTemplateConstructor.formatBioDataContent(biodataContentMap, cmdBioTemplate2, cmdList);
                    continue;
                }
                if (cmdBioTemplate2.getType() == 9) {
                    if (cmdDevice.getMultiBioDataSupport() != null && cmdDevice.getMultiBioDataSupport().length() > 0) {
                        if (!"1".equals(cmdDevice.getMultiBioDataSupport((short)9))) continue;
                        if (cmdBioTemplate2.getFormat() == 0 && Float.parseFloat(cmdBioTemplate2.getVersion()) == Float.parseFloat(cmdDevice.getMultiBioVersion((short)9))) {
                            CmdBioTemplateConstructor.formatBioDataContent(biodataContentMap, cmdBioTemplate2, cmdList);
                            visilightUseTempPins.add(cmdBioTemplate2.getPin());
                            continue;
                        }
                        if (cmdBioTemplate2.getFormat() != 1 || !"1".equals(cmdDevice.getMultiBioPhotoSupport((short)9)) || visilightUseTempPins.contains(cmdBioTemplate2.getPin())) continue;
                        biophoto = new CmdBiophoto();
                        biophoto.setPin(cmdBioTemplate2.getPin());
                        biophoto.setType(cmdBioTemplate2.getType());
                        biophoto.setFormat(cmdBioTemplate2.getFormat());
                        biophoto.setUrl(cmdBioTemplate2.getUrl());
                        cmdBiophotoList.add(biophoto);
                        continue;
                    }
                    if (!"1".equals(cmdDevice.getAccSupportFunList(38)) || cmdBioTemplate2.getFormat() != 1) continue;
                    biophoto = new CmdBiophoto();
                    biophoto.setPin(cmdBioTemplate2.getPin());
                    biophoto.setType(cmdBioTemplate2.getType());
                    biophoto.setFormat(cmdBioTemplate2.getFormat());
                    biophoto.setUrl(cmdBioTemplate2.getUrl());
                    cmdBiophotoList.add(biophoto);
                    continue;
                }
                if (cmdDevice.getMultiBioDataSupport() == null || cmdDevice.getMultiBioDataSupport().length() <= 0 || !"1".equals(cmdDevice.getMultiBioDataSupport(cmdBioTemplate2.getType())) || Float.parseFloat(cmdBioTemplate2.getVersion()) != Float.parseFloat(cmdDevice.getMultiBioVersion(cmdBioTemplate2.getType()))) continue;
                CmdBioTemplateConstructor.formatBioDataContent(biodataContentMap, cmdBioTemplate2, cmdList);
            }
            if (biodataContentMap.size() > 0) {
                for (Map.Entry entry : biodataContentMap.entrySet()) {
                    if (entry.getValue() == null || "".equals(entry.getValue() + "")) continue;
                    cmdList.add(CmdBioTemplate.SET_BIODATA_HEAD + entry.getValue());
                }
            }
            if (fpContent.length() > 0) {
                cmdList.add(CmdBioTemplate.SET_FPTEMPLATE_HEAD + fpContent.toString());
            }
            if (faceContent.length() > 0) {
                cmdList.add(CmdBioTemplate.SET_FACEV7_HEAD + faceContent.toString());
            }
            if (fvContent.length() > 0) {
                cmdList.add(CmdBioTemplate.SET_FVTEMPLATE_HEAD + fvContent.toString());
            }
            if (cmdBiophotoList.size() > 0) {
                cmdList.addAll(CmdBiophotoConstructor.setBioPhotoContents(cmdDevice, cmdBiophotoList));
            }
            return cmdList;
        }
        return null;
    }

    private static void formatBioDataContent(Map<Short, StringBuffer> biodataContents, CmdBioTemplate cmdBioTemplate, List<String> cmdList) {
        String bioMajorVersion = "0";
        String bioMinorVersion = "0";
        if (cmdBioTemplate.getVersion().indexOf(".") > 0) {
            bioMajorVersion = cmdBioTemplate.getVersion().split("\\.")[0];
            bioMinorVersion = cmdBioTemplate.getVersion().split("\\.")[1];
        } else {
            bioMajorVersion = cmdBioTemplate.getVersion();
        }
        StringBuffer biodataContent = biodataContents.get(cmdBioTemplate.getType());
        if (Objects.isNull(biodataContent)) {
            biodataContent = new StringBuffer();
        }
        biodataContent.append(String.format("Pin=%s\tNo=%s\tType=%s\tIndex=%s\tValid=1\tDuress=%s\tMajorVer=%s\tMinorVer=%s\tFormat=0\tTmp=%s\r\n", cmdBioTemplate.getPin(), cmdBioTemplate.getTemplateId(), cmdBioTemplate.getType(), cmdBioTemplate.getTemplateIndex(), cmdBioTemplate.getDuress() == false ? 0 : 1, bioMajorVersion, bioMinorVersion, cmdBioTemplate.getTemplate()));
        if (biodataContent.length() / 1024 >= 40) {
            cmdList.add(CmdBioTemplate.SET_BIODATA_HEAD + biodataContent.toString());
            biodataContent.setLength(0);
            biodataContents.remove(cmdBioTemplate.getType());
        }
        if (biodataContent.length() > 0) {
            biodataContents.put(cmdBioTemplate.getType(), biodataContent);
        }
    }

    public static List<String> setBioTemplateToChildDev(CmdDevice cmdDevice, Collection<CmdBioTemplate> cmdBioTemplates) {
        if (cmdBioTemplates != null && cmdBioTemplates.size() > 0) {
            ArrayList<String> cmdList = new ArrayList<String>();
            HashSet fpPins = new HashSet();
            StringBuffer fpContent = new StringBuffer();
            cmdBioTemplates.stream().forEach(cmdBioTemplate -> {
                if (cmdBioTemplate.getType() == 1) {
                    fpPins.add(cmdBioTemplate.getPin());
                }
            });
            if (fpPins.size() > 0 && CmdBioTemplateConstructor.isSupportFP(cmdDevice).booleanValue() && CmdBioTemplateConstructor.isSupportFP12(cmdDevice)) {
                fpPins.stream().forEach(fpPin -> fpContent.append(String.format("Pin=%s\r\n", fpPin)));
                cmdList.add(CmdBioTemplate.SET_BIODATA_HEAD + fpContent.toString());
            } else if (fpPins.size() > 0 && CmdBioTemplateConstructor.isSupportFP(cmdDevice).booleanValue()) {
                fpPins.stream().forEach(fpPin -> fpContent.append(String.format("Pin=%s\r\n", fpPin)));
                cmdList.add(CmdBioTemplate.SET_FPTEMPLATE_HEAD + fpContent.toString());
            }
            return cmdList;
        }
        return null;
    }

    public static String delFingerprints(CmdDevice cmdDevice, Collection<String> pins) {
        if (pins != null && pins.size() > 0) {
            StringBuffer cmdContent = new StringBuffer();
            if ("1".equals(cmdDevice.getMultiBioDataSupport((short)1)) || CmdBioTemplateConstructor.isSupportFP12(cmdDevice)) {
                pins.stream().forEach(pin -> cmdContent.append(String.format("Pin=%s\tType=%s\r\n", pin, (short)1)));
                return CmdBioTemplate.DEL_BIODATA_HEAD + cmdContent.toString();
            }
            if (CmdBioTemplateConstructor.isSupportFP(cmdDevice).booleanValue()) {
                pins.stream().forEach(pin -> cmdContent.append(String.format("Pin=%s\r\n", pin)));
                return CmdBioTemplate.DEL_FPTEMPLATE_HEAD + cmdContent.toString();
            }
        }
        return null;
    }

    public static String delFaces(CmdDevice cmdDevice, Collection<String> pins) {
        if (pins != null && pins.size() > 0) {
            StringBuffer cmdContent = new StringBuffer();
            if ("1".equals(cmdDevice.getMultiBioDataSupport((short)2))) {
                pins.stream().forEach(pin -> cmdContent.append(String.format("Pin=%s\tType=%s\r\n", pin, (short)2)));
                return CmdBioTemplate.DEL_BIODATA_HEAD + cmdContent.toString();
            }
            if (CmdBioTemplateConstructor.isSupportFace(cmdDevice).booleanValue()) {
                pins.stream().forEach(pin -> cmdContent.append(String.format("Pin=%s\r\n", pin)));
                return CmdBioTemplate.DEL_FACEV7_HEAD + cmdContent.toString();
            }
        }
        return null;
    }

    public static String delFingerveins(CmdDevice cmdDevice, Collection<String> pins) {
        if (CmdBioTemplateConstructor.isSupportFV(cmdDevice).booleanValue() && pins != null && pins.size() > 0) {
            StringBuffer cmdContent = new StringBuffer();
            pins.stream().forEach(pin -> cmdContent.append(String.format("Pin=%s\r\n", pin)));
            return CmdBioTemplate.DEL_FVTEMPLATE_HEAD + cmdContent.toString();
        }
        return null;
    }

    public static String delPalmveins(CmdDevice cmdDevice, Collection<String> pins) {
        if (pins != null && pins.size() > 0 && ("1".equals(cmdDevice.getMultiBioDataSupport((short)8)) || CmdBioTemplateConstructor.isSupportPv(cmdDevice))) {
            StringBuffer cmdContent = new StringBuffer();
            pins.stream().forEach(pin -> cmdContent.append(String.format("Pin=%s\tType=%s\r\n", pin, (short)8)));
            return CmdBioTemplate.DEL_BIODATA_HEAD + cmdContent.toString();
        }
        return null;
    }

    public static String delVislightDatas(CmdDevice cmdDevice, Collection<String> pins) {
        if (pins != null && pins.size() > 0 && "1".equals(cmdDevice.getMultiBioDataSupport((short)9))) {
            StringBuffer cmdContent = new StringBuffer();
            pins.stream().forEach(pin -> cmdContent.append(String.format("Pin=%s\tType=%s\r\n", pin, (short)9)));
            return CmdBioTemplate.DEL_BIODATA_HEAD + cmdContent.toString();
        }
        return null;
    }

    public static String delVislightPalms(CmdDevice cmdDevice, Collection<String> pins) {
        if (pins != null && pins.size() > 0 && "1".equals(cmdDevice.getMultiBioDataSupport((short)10))) {
            StringBuffer cmdContent = new StringBuffer();
            pins.stream().forEach(pin -> cmdContent.append(String.format("Pin=%s\tType=%s\r\n", pin, (short)10)));
            return CmdBioTemplate.DEL_BIODATA_HEAD + cmdContent.toString();
        }
        return null;
    }

    public static String delBioDataByType(CmdDevice cmdDevice, Collection<String> pins, Short bioType) {
        if (pins != null && pins.size() > 0 && "1".equals(cmdDevice.getMultiBioDataSupport(bioType))) {
            StringBuffer cmdContent = new StringBuffer();
            pins.stream().forEach(pin -> cmdContent.append(String.format("Pin=%s\tType=%s\r\n", pin, bioType)));
            return CmdBioTemplate.DEL_BIODATA_HEAD + cmdContent.toString();
        }
        return null;
    }

    public static String delAllFingerprint(CmdDevice cmdDevice) {
        if (cmdDevice.getMultiBioDataSupport() != null && cmdDevice.getMultiBioDataSupport().length() > 0) {
            if ("1".equals(cmdDevice.getMultiBioDataSupport((short)1))) {
                return CmdBioTemplate.DEL_BIODATA_HEAD + String.format("Type=%s\r\n", (short)1);
            }
        } else {
            if (CmdBioTemplateConstructor.isSupportFP12(cmdDevice)) {
                return CmdBioTemplate.DEL_BIODATA_HEAD + String.format("Type=%s\r\n", (short)1);
            }
            if (CmdBioTemplateConstructor.isSupportFP(cmdDevice).booleanValue()) {
                return CmdBioTemplate.DEL_FPTEMPLATE_HEAD + "*\r\n";
            }
        }
        return null;
    }

    public static String delAllFace(CmdDevice cmdDevice) {
        if (cmdDevice.getMultiBioDataSupport() != null && cmdDevice.getMultiBioDataSupport().length() > 0) {
            if ("1".equals(cmdDevice.getMultiBioDataSupport((short)2))) {
                return CmdBioTemplate.DEL_BIODATA_HEAD + String.format("Type=%s\r\n", (short)2);
            }
        } else if (CmdBioTemplateConstructor.isSupportFace(cmdDevice).booleanValue()) {
            return CmdBioTemplate.DEL_FACEV7_HEAD + "*\r\n";
        }
        return null;
    }

    public static String delAllFingervein(CmdDevice cmdDevice) {
        if (cmdDevice.getMultiBioDataSupport() != null && cmdDevice.getMultiBioDataSupport().length() > 0) {
            if ("1".equals(cmdDevice.getMultiBioDataSupport((short)7))) {
                return CmdBioTemplate.DEL_BIODATA_HEAD + String.format("Type=%s\r\n", (short)7);
            }
        } else if (CmdBioTemplateConstructor.isSupportFV(cmdDevice).booleanValue()) {
            return CmdBioTemplate.DEL_FVTEMPLATE_HEAD + "*\r\n";
        }
        return null;
    }

    public static String delAllPalm(CmdDevice cmdDevice) {
        if (cmdDevice.getMultiBioDataSupport() != null && cmdDevice.getMultiBioDataSupport().length() > 0 && "1".equals(cmdDevice.getMultiBioDataSupport((short)8))) {
            return CmdBioTemplate.DEL_BIODATA_HEAD + String.format("Type=%s\r\n", (short)8);
        }
        return null;
    }

    public static String delAllVislightData(CmdDevice cmdDevice) {
        if (cmdDevice.getMultiBioDataSupport() != null && cmdDevice.getMultiBioDataSupport().length() > 0 && "1".equals(cmdDevice.getMultiBioDataSupport((short)9))) {
            return CmdBioTemplate.DEL_BIODATA_HEAD + String.format("Type=%s\r\n", (short)9);
        }
        return null;
    }

    public static String delAllVislightPalm(CmdDevice cmdDevice) {
        if ("1".equals(cmdDevice.getMultiBioDataSupport((short)10))) {
            return CmdBioTemplate.DEL_BIODATA_HEAD + String.format("Type=%s\r\n", (short)10);
        }
        return null;
    }

    public static boolean isSupportPv(CmdDevice cmdDevice) {
        return "1".equals(cmdDevice.getPvFunOn());
    }

    private static boolean isSupportVisilight(CmdDevice cmdDevice) {
        return "1".equals(cmdDevice.getVisilightFun());
    }

    private static Boolean isSupportFP(CmdDevice cmdDevice) {
        boolean isSupportFP = false;
        if (cmdDevice.getFingerFunOn() != null) {
            isSupportFP = "1".equals(cmdDevice.getFingerFunOn());
        } else if (cmdDevice.getIsOnlyRFMachine() != null) {
            isSupportFP = "0".equals(cmdDevice.getIsOnlyRFMachine());
        }
        return isSupportFP;
    }

    private static boolean isSupportFP12(CmdDevice cmdDevice) {
        return "1".equals(cmdDevice.getFingerFunOn()) && "12".equals(cmdDevice.getzKFPVersion());
    }

    private static Boolean isSupportFV(CmdDevice cmdDevice) {
        return "1".equals(cmdDevice.getFvFunOn());
    }

    private static Boolean isSupportFace(CmdDevice cmdDevice) {
        return !"1".equals(cmdDevice.getBioPhotoFunOn()) && "1".equals(cmdDevice.getFaceFunOn());
    }

    public static String getAllFingerprint(CmdDevice cmdDevice) {
        if (cmdDevice.getMultiBioDataSupport() != null && cmdDevice.getMultiBioDataSupport().length() > 0) {
            if ("1".equals(cmdDevice.getMultiBioDataSupport((short)1))) {
                return String.format("DATA QUERY tablename=%s,fielddesc=%s,filter=%s\r\n", "biodata", "*", "Type=1");
            }
        } else {
            if (CmdBioTemplateConstructor.isSupportFP12(cmdDevice)) {
                return String.format("DATA QUERY tablename=%s,fielddesc=%s,filter=%s\r\n", "biodata", "*", "Type=1");
            }
            if (CmdBioTemplateConstructor.isSupportFP(cmdDevice).booleanValue()) {
                return String.format("DATA QUERY tablename=%s,fielddesc=%s,filter=%s\r\n", "templatev10", "*", "*");
            }
        }
        return null;
    }

    public static String getAllFace(CmdDevice cmdDevice) {
        if (cmdDevice.getMultiBioDataSupport() != null && cmdDevice.getMultiBioDataSupport().length() > 0) {
            if ("1".equals(cmdDevice.getMultiBioDataSupport((short)2))) {
                return String.format("DATA QUERY tablename=%s,fielddesc=%s,filter=%s\r\n", "biodata", "*", "Type=2");
            }
        } else if (CmdBioTemplateConstructor.isSupportFace(cmdDevice).booleanValue()) {
            return String.format("DATA QUERY tablename=%s,fielddesc=%s,filter=%s\r\n", "facev7", "*", "*");
        }
        return null;
    }

    public static String getAllFingervein(CmdDevice cmdDevice) {
        if (CmdBioTemplateConstructor.isSupportFV(cmdDevice).booleanValue()) {
            return String.format("DATA QUERY tablename=%s,fielddesc=%s,filter=%s\r\n", "fvtemplate", "*", "*");
        }
        return null;
    }

    public static String getAllPalm(CmdDevice cmdDevice) {
        if (cmdDevice.getMultiBioDataSupport() != null && cmdDevice.getMultiBioDataSupport().length() > 0 ? "1".equals(cmdDevice.getMultiBioDataSupport((short)8)) : CmdBioTemplateConstructor.isSupportPv(cmdDevice)) {
            return String.format("DATA QUERY tablename=%s,fielddesc=%s,filter=%s\r\n", "biodata", "*", "Type=8");
        }
        return null;
    }

    public static String getAllVislightFace(CmdDevice cmdDevice) {
        if (cmdDevice.getMultiBioDataSupport() != null && cmdDevice.getMultiBioDataSupport().length() > 0 && "1".equals(cmdDevice.getMultiBioDataSupport((short)9))) {
            return String.format("DATA QUERY tablename=%s,fielddesc=%s,filter=%s\r\n", "biodata", "*", "Type=9");
        }
        return null;
    }

    public static String getAllBioDataByType(CmdDevice cmdDevice, Short bioType) {
        if (cmdDevice.getMultiBioDataSupport() != null && cmdDevice.getMultiBioDataSupport().length() > 0 && "1".equals(cmdDevice.getMultiBioDataSupport(bioType))) {
            return String.format("DATA QUERY tablename=%s,fielddesc=%s,filter=%s\r\n", "biodata", "*", "Type=" + bioType);
        }
        return null;
    }

    public static String getFingerprintCount(CmdDevice cmdDevice) {
        if (cmdDevice.getMultiBioDataSupport() != null && cmdDevice.getMultiBioDataSupport().length() > 0) {
            if ("1".equals(cmdDevice.getMultiBioDataSupport((short)1))) {
                return String.format("DATA COUNT %s ", "biodata Type=1");
            }
        } else {
            if (CmdBioTemplateConstructor.isSupportFP12(cmdDevice)) {
                return String.format("DATA COUNT %s ", "biodata Type=1");
            }
            if (CmdBioTemplateConstructor.isSupportFP(cmdDevice).booleanValue()) {
                return String.format("DATA COUNT %s ", "templatev10");
            }
        }
        return null;
    }

    public static String getFaceCount(CmdDevice cmdDevice) {
        if (cmdDevice.getMultiBioDataSupport() != null && cmdDevice.getMultiBioDataSupport().length() > 0) {
            if ("1".equals(cmdDevice.getMultiBioDataSupport((short)2))) {
                return String.format("DATA COUNT %s ", "biodata Type=2");
            }
        } else if (CmdBioTemplateConstructor.isSupportFace(cmdDevice).booleanValue()) {
            return String.format("DATA COUNT %s ", "facev7", "*", "*");
        }
        return null;
    }

    public static String getFingerveinCount(CmdDevice cmdDevice) {
        if (cmdDevice.getMultiBioDataSupport() != null && cmdDevice.getMultiBioDataSupport().length() > 0) {
            if ("1".equals(cmdDevice.getMultiBioDataSupport((short)7))) {
                return String.format("DATA COUNT %s ", "biodata Type=7");
            }
        } else if (CmdBioTemplateConstructor.isSupportFV(cmdDevice).booleanValue()) {
            return String.format("DATA COUNT %s ", "fvtemplate");
        }
        return null;
    }

    public static String getPalmCount(CmdDevice cmdDevice) {
        if (cmdDevice.getMultiBioDataSupport() != null && cmdDevice.getMultiBioDataSupport().length() > 0 ? "1".equals(cmdDevice.getMultiBioDataSupport((short)8)) : CmdBioTemplateConstructor.isSupportPv(cmdDevice)) {
            return String.format("DATA COUNT %s ", "biodata Type=8");
        }
        return null;
    }

    public static String getVislightFaceCount(CmdDevice cmdDevice) {
        if (cmdDevice.getMultiBioDataSupport() != null && cmdDevice.getMultiBioDataSupport().length() > 0 && "1".equals(cmdDevice.getMultiBioDataSupport((short)9))) {
            return String.format("DATA COUNT %s ", "biodata Type=9");
        }
        return null;
    }

    public static String getBioDataCountByType(CmdDevice cmdDevice, Short type) {
        if ("1".equals(cmdDevice.getMultiBioDataSupport(type))) {
            return String.format("DATA COUNT %s ", "biodata Type=" + type);
        }
        return null;
    }
}

