/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.client.service;

import com.zkteco.zkbiosecurity.att.api.vo.MessagePushCloudSendMessageItem;
import com.zkteco.zkbiosecurity.att.service.AttCloudMessageSendService;
import com.zkteco.zkbiosecurity.att.vo.AttRecordItem;
import com.zkteco.zkbiosecurity.att.vo.AttTransactionItem;
import com.zkteco.zkbiosecurity.core.utils.CollectionUtil;
import com.zkteco.zkbiosecurity.license.provider.BaseLicenseProvider;
import com.zkteco.zkbiosecurity.license.service.BaseLicenseClientService;
import com.zkteco.zkbiosecurity.license.service.BaseLicenseService;
import com.zkteco.zkbiosecurity.message.bean.ZKMessage;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AttCloudMessageSendServiceImpl
implements AttCloudMessageSendService {
    private static final Logger log = LoggerFactory.getLogger(AttCloudMessageSendServiceImpl.class);
    @Autowired
    private BaseLicenseService baseLicenseService;
    @Autowired
    private BaseLicenseClientService baseLicenseClientService;
    @Autowired
    private BaseLicenseProvider baseLicenseProvider;

    public void sendRuleToCloud(Map<String, String> params) {
    }

    public void asyncPushTransactionToCloud(List<AttTransactionItem> attTransactionItemList) {
    }

    public void asyncPushRecordToCloud(List<AttRecordItem> attRecordItemList) {
    }

    public boolean isActiveLicense() {
        List activeModuleCodeList = this.baseLicenseProvider.getActiveModuleLIist();
        return activeModuleCodeList.contains("att");
    }

    public void asyncPushTransactionWxMsgToCloud(List<MessagePushCloudSendMessageItem> messageItemList) {
        if (StringUtils.isNotBlank((CharSequence)this.baseLicenseService.getAppId()) && this.isActiveLicense() && !CollectionUtil.isEmpty(messageItemList)) {
            CompletableFuture.runAsync(() -> {
                List pageList = CollectionUtil.split((Collection)messageItemList, (int)30);
                ZKMessage zkMessage = new ZKMessage();
                zkMessage.setAppId(this.baseLicenseService.getAppId());
                zkMessage.setModuleCode("pers");
                zkMessage.setMessageId("messagePushHandleMessage#sendWxAndAppMessageHandle");
                pageList.forEach(items -> {
                    zkMessage.setListContent(items);
                    this.baseLicenseClientService.sendMessage(zkMessage);
                });
            });
        }
    }
}

