/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ad.init;

import com.zkteco.zkbiosecurity.ad.constants.AdConstants;
import com.zkteco.zkbiosecurity.ad.service.AdFieldMappingService;
import com.zkteco.zkbiosecurity.ad.service.AdPropertiesService;
import com.zkteco.zkbiosecurity.ad.vo.AdFieldMappingItem;
import com.zkteco.zkbiosecurity.ad.vo.AdPropertiesItem;
import com.zkteco.zkbiosecurity.auth.service.AuthPermissionService;
import com.zkteco.zkbiosecurity.auth.vo.AuthPermissionItem;
import com.zkteco.zkbiosecurity.base.utils.VersionUtil;
import com.zkteco.zkbiosecurity.system.service.BaseSysParamService;
import com.zkteco.zkbiosecurity.system.vo.BaseSysParamItem;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=320)
public class AdInit
implements CommandLineRunner {
    @Autowired
    private AuthPermissionService authPermissionService;
    @Autowired
    private BaseSysParamService baseSysParamService;
    @Autowired
    private AdPropertiesService adPropertiesService;
    @Autowired
    private AdFieldMappingService adFieldMappingService;

    public void run(String ... args) throws Exception {
        boolean alreadyInit = this.baseSysParamService.getAlreadyInitModule("AdInit");
        if (!alreadyInit) {
            this.initAuthPermission();
            this.initAdParams();
            this.initAdProperties();
            this.initAdFieldMapping();
            this.baseSysParamService.setAlreadyInitModule("AdInit");
            this.initUpgradeVersion();
        }
    }

    private void initAuthPermission() {
        AuthPermissionItem subMenuItem1;
        AuthPermissionItem systemItem = this.authPermissionService.getItemByCode("System");
        if (systemItem == null) {
            systemItem = new AuthPermissionItem("System", "system_module", "system", "system", "true", Integer.valueOf(999));
            systemItem = this.authPermissionService.initData(systemItem);
        }
        if ((subMenuItem1 = this.authPermissionService.getItemByCode("ThirdPartyDocking")) == null) {
            subMenuItem1 = new AuthPermissionItem("ThirdPartyDocking", "base_leftMenu_thirdParty", "third:party:docking", "menu", "true", Integer.valueOf(4));
            subMenuItem1.setParentId(systemItem.getId());
            subMenuItem1.setImg("base_extendManage.png");
            subMenuItem1.setImgHover("base_extendManage_over.png");
            subMenuItem1 = this.authPermissionService.initData(subMenuItem1);
        }
        AuthPermissionItem subMenuItem = new AuthPermissionItem("AdSync", "docking_ad_ADManage", "ad:manager", "menu", "true", Integer.valueOf(7));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("adSync.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
    }

    public void initAdParams() {
        this.baseSysParamService.initData(new BaseSysParamItem("ad.url", "ldap://localhost:389", "\u8fde\u63a5\u5730\u5740"));
        this.baseSysParamService.initData(new BaseSysParamItem("ad.username", "", "\u7528\u6237\u540d"));
        this.baseSysParamService.initData(new BaseSysParamItem("ad.userPwd", "", "\u5bc6\u7801"));
        this.baseSysParamService.initData(new BaseSysParamItem("ad.domainNode", "", "\u57df\u8282\u70b9"));
        this.baseSysParamService.initData(new BaseSysParamItem("ad.syncLevelEnabled", "0", "\u662f\u5426\u5f00\u542f\u540c\u6b65GROUP\uff0c\u9ed8\u8ba4\u5173\u95ed"));
        this.baseSysParamService.initData(new BaseSysParamItem("ad.syncPersonByLevelEnabled", "0", "\u662f\u5426\u5f00\u542f\u540c\u6b65GROUP\u4e0b\u7684MEMBER\uff0c\u9ed8\u8ba4\u5173\u95ed"));
        this.baseSysParamService.initData(new BaseSysParamItem("ad.domainNodeForLevel", "", "\u540c\u6b65\u6743\u9650\u7ec4\u57df\u8282\u70b9"));
        this.baseSysParamService.initData(new BaseSysParamItem("ad.syncPollDataEnabled", "0", "\u662f\u5426\u5f00\u542f\u589e\u91cf\u540c\u6b65\u4efb\u52a1\uff0c\u9ed8\u8ba4\u5173\u95ed"));
        this.baseSysParamService.initData(new BaseSysParamItem("ad.syncSweepDataEnabled", "0", "\u662f\u5426\u5f00\u542f\u5168\u91cf\u540c\u6b65\u4efb\u52a1,\u9ed8\u8ba4\u5173\u95ed"));
        this.baseSysParamService.initData(new BaseSysParamItem("ad.pollSyncExpression", "0 0/30 * * * ?", "ad\u589e\u91cf\u5b9a\u65f6\u540c\u6b65cron\u8868\u8fbe\u5f0f"));
        this.baseSysParamService.initData(new BaseSysParamItem("ad.sweepSyncExpression", "0 0 0 1/3 * ?", "ad\u5168\u91cf\u5b9a\u65f6\u540c\u6b65cron\u8868\u8fbe\u5f0f"));
        this.baseSysParamService.initData(new BaseSysParamItem("ad.version", "true", "ad version", Boolean.valueOf(true)));
    }

    private void initAdProperties() {
        for (Map.Entry entry : AdConstants.AD_PROPERTIES_MAP.entrySet()) {
            this.adPropertiesService.initData(new AdPropertiesItem((String)entry.getKey(), (String)entry.getValue()));
        }
    }

    private void initAdFieldMapping() {
        this.adFieldMappingService.initData(new AdFieldMappingItem("pin", "description", "description"));
        this.adFieldMappingService.initData(new AdFieldMappingItem("name", "givenName", "givenName"));
        this.adFieldMappingService.initData(new AdFieldMappingItem("lastName", "sn", "sn"));
        this.adFieldMappingService.initData(new AdFieldMappingItem("deptName", "department", "department"));
        this.adFieldMappingService.initData(new AdFieldMappingItem("mobilePhone", "mobile", "mobile"));
        this.adFieldMappingService.initData(new AdFieldMappingItem("email", "mail", "mail"));
        this.adFieldMappingService.initData(new AdFieldMappingItem("createTime", "whenCreated", "falseShow"));
        this.adFieldMappingService.initData(new AdFieldMappingItem("updateTime", "whenChanged", "falseShow"));
    }

    private void initUpgradeVersion() {
        String curVersion = VersionUtil.getReleaseGitTags((String)"ad");
        if (StringUtils.isNotBlank((CharSequence)curVersion)) {
            BaseSysParamItem baseSysParamItem = this.baseSysParamService.findByParamName("AdUpgradeVersion");
            if (StringUtils.isBlank((CharSequence)baseSysParamItem.getId())) {
                baseSysParamItem = new BaseSysParamItem("AdUpgradeVersion", curVersion, "AD Upgrade Version", Boolean.valueOf(true));
            }
            this.baseSysParamService.saveItem(baseSysParamItem);
        }
    }
}

