/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.annotation.Where;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.io.Serializable;
import java.util.Date;

@From(after="VIS_WATCHLIST t LEFT JOIN VIS_WATCHLIST_CATEGORY c ON t.CATEGORY=c.ID ")
@Where(after="AND t.WATCH_LIST_TYPE='1'")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=true, idField="id", winHeight=490, winWidth=782)
public class VisWatchListThumbnailsItem
extends BaseItem
implements Serializable {
    @GridColumn(checkbox=false, width="40", sortNo=0)
    @Column(name="t.ID")
    private String id;
    @Column(name="t.CERT_PHOTO")
    @GridColumn(label="vis_watchList_category", width="200")
    private String certPhoto;
    @Column(name="t.NAME")
    @GridColumn(label="vis_watchList_category", width="200", encryptMode="${vis.name.encryptMode}", encryptProp="${vis.name.encryptProp}")
    private String name;
    @Column(name="t.LAST_NAME")
    @GridColumn(label="vis_watchList_category", width="200", defaultValue="-", encryptMode="${vis.lastName.encryptMode}", encryptProp="${vis.lastName.encryptProp}")
    private String lastName;
    @Column(name="c.CATEGORY")
    @GridColumn(label="vis_watchList_category", width="200")
    private String category;
    @Column(name="c.ID")
    private String categoryId;
    @Column(name="t.CERT_TYPE")
    private String certType;
    @Column(name="t.CERT_NUMBER", encryptConverter=true)
    private String certNumber;
    @Column(name="t.IS_SET_WATCH_TIME")
    private Boolean setWatchTime;
    @Column(name="t.START_WATCH_TIME")
    @GridColumn(label="common_timeSeg_startTime", width="200")
    private Date startWatchTime;
    @Column(name="t.END_WATCH_TIME")
    @GridColumn(label="common_timeSeg_endTime", width="200")
    private Date endWatchTime;
    @Condition(value="(LOWER (t.NAME) LIKE LOWER (''%{0}%'') OR LOWER (t.LAST_NAME) LIKE LOWER (''%{0}%''))")
    private String likeName;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCertPhoto() {
        return this.certPhoto;
    }

    public void setCertPhoto(String certPhoto) {
        this.certPhoto = certPhoto;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(String categoryId) {
        this.categoryId = categoryId;
    }

    public String getCertType() {
        return this.certType;
    }

    public void setCertType(String certType) {
        this.certType = certType;
    }

    public String getCertNumber() {
        return this.certNumber;
    }

    public void setCertNumber(String certNumber) {
        this.certNumber = certNumber;
    }

    public Boolean getSetWatchTime() {
        return this.setWatchTime;
    }

    public void setSetWatchTime(Boolean setWatchTime) {
        this.setWatchTime = setWatchTime;
    }

    public Date getStartWatchTime() {
        return this.startWatchTime;
    }

    public void setStartWatchTime(Date startWatchTime) {
        this.startWatchTime = startWatchTime;
    }

    public Date getEndWatchTime() {
        return this.endWatchTime;
    }

    public void setEndWatchTime(Date endWatchTime) {
        this.endWatchTime = endWatchTime;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public void setLikeName(String likeName) {
        this.likeName = likeName;
    }
}

