/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.io.Serializable;
import java.util.Date;

@From(after="VIS_VISITOR t LEFT JOIN vis_watchlist w on t.cert_number=w.cert_number AND t.cert_type=w.cert_type AND w.enabled=1 LEFT JOIN vis_watchlist_category g on w.category=g.id")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=false, idField="id", winHeight=400, winWidth=600)
public class VisWatchListSelectItem
extends BaseItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String type;
    private String selectId;
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sortNo=0)
    private String id;
    @Column(name="t.PIN")
    @GridColumn(label="vis_emp_pin", width="100")
    private String pin;
    @Column(name="t.NAME")
    @GridColumn(label="pers_person_name", width="100")
    private String name;
    @Column(name="t.LAST_NAME")
    @GridColumn(label="pers_person_lastName", width="100", showExpression="#language!='zh_CN'")
    private String lastName;
    @Column(name="t.CERT_TYPE")
    private String certType;
    @Column(name="t.CERT_TYPE")
    @GridColumn(columnType="dic", key="certificateType", label="vis_cert_type", width="120")
    private String certName;
    @Column(name="t.CERT_NUMBER", encryptConverter=true)
    @GridColumn(label="vis_cert_number", width="140")
    private String certNumber;
    @Column(name="t.COMPANY")
    @GridColumn(label="vis_common_company", width="100")
    private String company;
    @Column(name="t.CAR_PLATE")
    private String carPlate;
    @Column(name="t.PHONE", encryptConverter=true)
    private String phone;
    @Column(name="g.CATEGORY")
    private String status;
    @Column(name="t.ENABLED")
    private Boolean enabled;
    @Column(name="t.CREATE_TIME")
    private Date createTime;
    @Column(name="t.CERT_PHOTO")
    private String certPhoto;
    @Column(name="t.NATIONALITY")
    private Integer nationality;
    @Column(name="t.NAME_SPELL")
    private String nameSpell;
    @Column(name="t.GENDER")
    private String gender;
    @Column(name="t.HEAD_PORTRAIT")
    private String headPortrait;
    @Column(name="t.CHANGE_OPERATOR")
    private String changeOperator;
    @Column(name="t.CHANGE_TIME")
    private Date changeTime;
    @Column(name="t.PARK_BLACKWHITE_ID")
    private String parkBlackWhiteId;
    @Condition(value="(LOWER (t.NAME) LIKE LOWER (''%{0}%'') OR LOWER (t.LAST_NAME) LIKE LOWER (''%{0}%''))")
    private String likeName;

    public VisWatchListSelectItem setType(String type) {
        this.type = type;
        return this;
    }

    public VisWatchListSelectItem setSelectId(String selectId) {
        this.selectId = selectId;
        return this;
    }

    public VisWatchListSelectItem setId(String id) {
        this.id = id;
        return this;
    }

    public VisWatchListSelectItem setPin(String pin) {
        this.pin = pin;
        return this;
    }

    public VisWatchListSelectItem setName(String name) {
        this.name = name;
        return this;
    }

    public VisWatchListSelectItem setLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public VisWatchListSelectItem setCertType(String certType) {
        this.certType = certType;
        return this;
    }

    public VisWatchListSelectItem setCertName(String certName) {
        this.certName = certName;
        return this;
    }

    public VisWatchListSelectItem setCertNumber(String certNumber) {
        this.certNumber = certNumber;
        return this;
    }

    public VisWatchListSelectItem setCompany(String company) {
        this.company = company;
        return this;
    }

    public VisWatchListSelectItem setCarPlate(String carPlate) {
        this.carPlate = carPlate;
        return this;
    }

    public VisWatchListSelectItem setPhone(String phone) {
        this.phone = phone;
        return this;
    }

    public VisWatchListSelectItem setStatus(String status) {
        this.status = status;
        return this;
    }

    public VisWatchListSelectItem setEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public VisWatchListSelectItem setCreateTime(Date createTime) {
        this.createTime = createTime;
        return this;
    }

    public VisWatchListSelectItem setCertPhoto(String certPhoto) {
        this.certPhoto = certPhoto;
        return this;
    }

    public VisWatchListSelectItem setNationality(Integer nationality) {
        this.nationality = nationality;
        return this;
    }

    public VisWatchListSelectItem setNameSpell(String nameSpell) {
        this.nameSpell = nameSpell;
        return this;
    }

    public VisWatchListSelectItem setGender(String gender) {
        this.gender = gender;
        return this;
    }

    public VisWatchListSelectItem setHeadPortrait(String headPortrait) {
        this.headPortrait = headPortrait;
        return this;
    }

    public VisWatchListSelectItem setChangeOperator(String changeOperator) {
        this.changeOperator = changeOperator;
        return this;
    }

    public VisWatchListSelectItem setChangeTime(Date changeTime) {
        this.changeTime = changeTime;
        return this;
    }

    public VisWatchListSelectItem setParkBlackWhiteId(String parkBlackWhiteId) {
        this.parkBlackWhiteId = parkBlackWhiteId;
        return this;
    }

    public VisWatchListSelectItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public String getSelectId() {
        return this.selectId;
    }

    public String getId() {
        return this.id;
    }

    public String getPin() {
        return this.pin;
    }

    public String getName() {
        return this.name;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getCertType() {
        return this.certType;
    }

    public String getCertName() {
        return this.certName;
    }

    public String getCertNumber() {
        return this.certNumber;
    }

    public String getCompany() {
        return this.company;
    }

    public String getCarPlate() {
        return this.carPlate;
    }

    public String getPhone() {
        return this.phone;
    }

    public String getStatus() {
        return this.status;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public String getCertPhoto() {
        return this.certPhoto;
    }

    public Integer getNationality() {
        return this.nationality;
    }

    public String getNameSpell() {
        return this.nameSpell;
    }

    public String getGender() {
        return this.gender;
    }

    public String getHeadPortrait() {
        return this.headPortrait;
    }

    public String getChangeOperator() {
        return this.changeOperator;
    }

    public Date getChangeTime() {
        return this.changeTime;
    }

    public String getParkBlackWhiteId() {
        return this.parkBlackWhiteId;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String toString() {
        return "VisWatchListSelectItem(type=" + this.getType() + ", selectId=" + this.getSelectId() + ", id=" + this.getId() + ", pin=" + this.getPin() + ", name=" + this.getName() + ", lastName=" + this.getLastName() + ", certType=" + this.getCertType() + ", certName=" + this.getCertName() + ", certNumber=" + this.getCertNumber() + ", company=" + this.getCompany() + ", carPlate=" + this.getCarPlate() + ", phone=" + this.getPhone() + ", status=" + this.getStatus() + ", enabled=" + this.getEnabled() + ", createTime=" + this.getCreateTime() + ", certPhoto=" + this.getCertPhoto() + ", nationality=" + this.getNationality() + ", nameSpell=" + this.getNameSpell() + ", gender=" + this.getGender() + ", headPortrait=" + this.getHeadPortrait() + ", changeOperator=" + this.getChangeOperator() + ", changeTime=" + this.getChangeTime() + ", parkBlackWhiteId=" + this.getParkBlackWhiteId() + ", likeName=" + this.getLikeName() + ")";
    }
}

