/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GridOperate;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.io.Serializable;
import java.util.Date;

@From(after="VIS_WATCHLIST t LEFT JOIN VIS_WATCHLIST_CATEGORY c ON t.CATEGORY=c.ID")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=true, idField="id", winHeight=510, winWidth=782, operates={@GridOperate(type="edit", permission="vis:watchList:edit", url="watchList.do?addView", label="common_op_edit"), @GridOperate(type="del", permission="vis:watchList:del", url="watchList.do?del&names=(name)", label="common_op_del")})
public class VisWatchListItem
extends BaseItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sortNo=0)
    private String id;
    @Column(name="t.WATCH_LIST_TYPE")
    @GridColumn(label="vis_watchList_type", i18n=true, format="1=pers_person,2=vis_common_company,3=pers_person_nationality", width="100")
    private String watchListType;
    @Column(name="t.NAME")
    @GridColumn(label="pers_person_name", width="100", encryptMode="${vis.name.encryptMode}", encryptProp="${vis.name.encryptProp}")
    private String name;
    @Column(name="t.LAST_NAME")
    @GridColumn(label="pers_person_lastName", width="100", showExpression="#language!='zh_CN'", encryptMode="${vis.lastName.encryptMode}", encryptProp="${vis.lastName.encryptProp}")
    private String lastName;
    @Column(name="t.ALIASES")
    private String aliases;
    @Column(name="t.CERT_TYPE")
    @GridColumn(columnType="dic", key="certificateType", label="vis_cert_type", width="120")
    private String certType;
    @Column(name="t.CERT_NUMBER", encryptConverter=true)
    @GridColumn(label="vis_cert_number", width="140", encryptMode="${vis.certNumber.encryptMode}", encryptProp="${vis.certNumber.encryptProp}")
    private String certNumber;
    @Column(name="t.COMPANY")
    @GridColumn(label="vis_common_company", width="100")
    private String company;
    @Column(name="t.NATIONALITY")
    private String nationality;
    @Column(name="t.NATIONALITY_NAME")
    @GridColumn(label="pers_person_nationality", i18n=true, width="100")
    private String nationalityName;
    @Column(name="c.CATEGORY")
    @GridColumn(label="vis_watchList_category", width="100")
    private String category;
    @Column(name="t.ENABLED")
    @GridColumn(label="common_enable", width="100", columnType="custom", convert="statusToIcon")
    private Integer enabled;
    @Column(name="t.CREATE_TIME")
    private Date createTime;
    @Column(name="t.CERT_PHOTO")
    @GridColumn(show=false)
    private String certPhoto;
    @Column(name="t.HEAD_PORTRAIT")
    @GridColumn(show=false)
    private String headPortrait;
    @Column(name="t.CHANGE_TIME")
    @GridColumn(show=false)
    private Date changeTime;
    @Column(name="t.IS_SET_WATCH_TIME")
    @GridColumn(show=false)
    private Boolean setWatchTime;
    @Column(name="t.START_WATCH_TIME")
    @GridColumn(show=false)
    private Date startWatchTime;
    @Column(name="t.END_WATCH_TIME")
    @GridColumn(show=false)
    private Date endWatchTime;
    @Column(name="t.REJECT_COUNT")
    @GridColumn(show=false)
    private Integer rejectCount;
    @Column(name="t.REJECT_DATES")
    @GridColumn(show=false)
    private String rejectDates;
    @Column(name="t.REMARK")
    @GridColumn(show=false)
    private String remark;
    @Column(name="t.ADDRESS")
    @GridColumn(show=false)
    private String address;
    @Condition(value="(LOWER (t.NAME) LIKE LOWER (''%{0}%'') OR LOWER (t.LAST_NAME) LIKE LOWER (''%{0}%''))")
    private String likeName;
    private String certPhotoBase64;

    public VisWatchListItem setId(String id) {
        this.id = id;
        return this;
    }

    public VisWatchListItem setWatchListType(String watchListType) {
        this.watchListType = watchListType;
        return this;
    }

    public VisWatchListItem setName(String name) {
        this.name = name;
        return this;
    }

    public VisWatchListItem setLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public VisWatchListItem setAliases(String aliases) {
        this.aliases = aliases;
        return this;
    }

    public VisWatchListItem setCertType(String certType) {
        this.certType = certType;
        return this;
    }

    public VisWatchListItem setCertNumber(String certNumber) {
        this.certNumber = certNumber;
        return this;
    }

    public VisWatchListItem setCompany(String company) {
        this.company = company;
        return this;
    }

    public VisWatchListItem setNationality(String nationality) {
        this.nationality = nationality;
        return this;
    }

    public VisWatchListItem setNationalityName(String nationalityName) {
        this.nationalityName = nationalityName;
        return this;
    }

    public VisWatchListItem setCategory(String category) {
        this.category = category;
        return this;
    }

    public VisWatchListItem setEnabled(Integer enabled) {
        this.enabled = enabled;
        return this;
    }

    public VisWatchListItem setCreateTime(Date createTime) {
        this.createTime = createTime;
        return this;
    }

    public VisWatchListItem setCertPhoto(String certPhoto) {
        this.certPhoto = certPhoto;
        return this;
    }

    public VisWatchListItem setHeadPortrait(String headPortrait) {
        this.headPortrait = headPortrait;
        return this;
    }

    public VisWatchListItem setChangeTime(Date changeTime) {
        this.changeTime = changeTime;
        return this;
    }

    public VisWatchListItem setSetWatchTime(Boolean setWatchTime) {
        this.setWatchTime = setWatchTime;
        return this;
    }

    public VisWatchListItem setStartWatchTime(Date startWatchTime) {
        this.startWatchTime = startWatchTime;
        return this;
    }

    public VisWatchListItem setEndWatchTime(Date endWatchTime) {
        this.endWatchTime = endWatchTime;
        return this;
    }

    public VisWatchListItem setRejectCount(Integer rejectCount) {
        this.rejectCount = rejectCount;
        return this;
    }

    public VisWatchListItem setRejectDates(String rejectDates) {
        this.rejectDates = rejectDates;
        return this;
    }

    public VisWatchListItem setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public VisWatchListItem setAddress(String address) {
        this.address = address;
        return this;
    }

    public VisWatchListItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public VisWatchListItem setCertPhotoBase64(String certPhotoBase64) {
        this.certPhotoBase64 = certPhotoBase64;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getWatchListType() {
        return this.watchListType;
    }

    public String getName() {
        return this.name;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getAliases() {
        return this.aliases;
    }

    public String getCertType() {
        return this.certType;
    }

    public String getCertNumber() {
        return this.certNumber;
    }

    public String getCompany() {
        return this.company;
    }

    public String getNationality() {
        return this.nationality;
    }

    public String getNationalityName() {
        return this.nationalityName;
    }

    public String getCategory() {
        return this.category;
    }

    public Integer getEnabled() {
        return this.enabled;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public String getCertPhoto() {
        return this.certPhoto;
    }

    public String getHeadPortrait() {
        return this.headPortrait;
    }

    public Date getChangeTime() {
        return this.changeTime;
    }

    public Boolean getSetWatchTime() {
        return this.setWatchTime;
    }

    public Date getStartWatchTime() {
        return this.startWatchTime;
    }

    public Date getEndWatchTime() {
        return this.endWatchTime;
    }

    public Integer getRejectCount() {
        return this.rejectCount;
    }

    public String getRejectDates() {
        return this.rejectDates;
    }

    public String getRemark() {
        return this.remark;
    }

    public String getAddress() {
        return this.address;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getCertPhotoBase64() {
        return this.certPhotoBase64;
    }
}

