/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.annotation.Where;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.io.Serializable;

@From(after="PERS_PERSON t LEFT join AUTH_DEPARTMENT d on t.auth_dept_id = d.id")
@Where(after=" AND t.ID NOT IN (SELECT vp.PERS_PERSON_ID FROM VIS_VISITEDPERSON vp)")
@OrderBy(after="t.UPDATE_TIME DESC")
@GridConfig(operate=false, idField="id", winHeight=400, winWidth=600)
public class VisVisitedPersonSelectItem
extends BaseItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID", equalTag="=")
    @GridColumn(checkbox=true, width="40", sortNo=0)
    private String id;
    @Column(name="t.PIN")
    @GridColumn(label="vis_record_visitedPin", width="80")
    private String persPin;
    @Column(name="t.NAME")
    @GridColumn(label="vis_record_visitedName", width="100")
    private String persName;
    @Column(name="t.LAST_NAME")
    @GridColumn(label="vis_record_visitedLastName", width="100", showExpression="#language!='zh_CN'")
    private String persLastName;
    @Column(name="d.NAME")
    @GridColumn(label="pers_dept_deptName", width="123", sort="na")
    private String deptName;
    private String type;
    @Condition(value="t.ID", equalTag="not in")
    private String selectId;
    @Condition(value="(LOWER (t.NAME) LIKE LOWER (''%{0}%'') OR LOWER (t.LAST_NAME) LIKE LOWER (''%{0}%''))")
    private String likeName;
    @Condition(value="t.AUTH_DEPT_ID IN (SELECT ud.AUTH_DEPT_ID FROM AUTH_USER_DEPT ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String userId;
    @Column(name="t.ENABLED_CREDENTIAL")
    private Boolean enabledCredential;

    public String getId() {
        return this.id;
    }

    public String getPersPin() {
        return this.persPin;
    }

    public String getPersName() {
        return this.persName;
    }

    public String getPersLastName() {
        return this.persLastName;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public String getType() {
        return this.type;
    }

    public String getSelectId() {
        return this.selectId;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getUserId() {
        return this.userId;
    }

    public Boolean getEnabledCredential() {
        return this.enabledCredential;
    }

    public VisVisitedPersonSelectItem setId(String id) {
        this.id = id;
        return this;
    }

    public VisVisitedPersonSelectItem setPersPin(String persPin) {
        this.persPin = persPin;
        return this;
    }

    public VisVisitedPersonSelectItem setPersName(String persName) {
        this.persName = persName;
        return this;
    }

    public VisVisitedPersonSelectItem setPersLastName(String persLastName) {
        this.persLastName = persLastName;
        return this;
    }

    public VisVisitedPersonSelectItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public VisVisitedPersonSelectItem setType(String type) {
        this.type = type;
        return this;
    }

    public VisVisitedPersonSelectItem setSelectId(String selectId) {
        this.selectId = selectId;
        return this;
    }

    public VisVisitedPersonSelectItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public VisVisitedPersonSelectItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public VisVisitedPersonSelectItem setEnabledCredential(Boolean enabledCredential) {
        this.enabledCredential = enabledCredential;
        return this;
    }

    public String toString() {
        return "VisVisitedPersonSelectItem(id=" + this.getId() + ", persPin=" + this.getPersPin() + ", persName=" + this.getPersName() + ", persLastName=" + this.getPersLastName() + ", deptName=" + this.getDeptName() + ", type=" + this.getType() + ", selectId=" + this.getSelectId() + ", likeName=" + this.getLikeName() + ", userId=" + this.getUserId() + ", enabledCredential=" + this.getEnabledCredential() + ")";
    }
}

