/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;

@From(after="VIS_TRANSACTION t LEFT JOIN VIS_VISITOR v ON t.VIS_EMP_ID=v.id")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(idField="id", winHeight=650, winWidth=835)
public class VisTransactionItem
extends BaseItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sortNo=0)
    private String id;
    @Column(name="t.VIS_EMP_PIN")
    @GridColumn(label="vis_emp_pin", width="100", columnType="edit", editPermission="vis:transaction:refresh", editUrl="visTransaction.do?edit")
    private String visEmpPin;
    @Column(name="t.VIS_EMP_NAME")
    @GridColumn(label="pers_person_name", width="100", encryptMode="${vis.name.encryptMode}", encryptProp="${vis.name.encryptProp}")
    private String visEmpName;
    @Column(name="t.VIS_EMP_LAST_NAME")
    @GridColumn(label="pers_person_lastName", width="100", showExpression="#language!='zh_CN'", encryptMode="${vis.lastName.encryptMode}", encryptProp="${vis.lastName.encryptProp}")
    private String visEmpLastName;
    @Column(name="t.VISIT_REASON")
    @GridColumn(label="vis_reason_name", width="100")
    private String visitReason;
    @Column(name="t.VISITED_EMP_PIN")
    @GridColumn(label="vis_record_visitedPin", width="120", encryptMode="${pers.pin.encryptMode}", encryptProp="${pers.pin.encryptProp}")
    private String visitedEmpPin;
    @Column(name="t.VISITED_EMP_NAME")
    @GridColumn(label="vis_record_visitedName", width="100", encryptMode="${pers.name.encryptMode}", encryptProp="${pers.name.encryptProp}")
    private String visitedEmpName;
    @Column(name="t.VISITED_EMP_LAST_NAME")
    @GridColumn(label="vis_record_visitedLastName", width="100", showExpression="#language!='zh_CN'", encryptMode="${pers.lastName.encryptMode}", encryptProp="${pers.lastName.encryptProp}")
    private String visitedEmpLastName;
    @Column(name="t.VISIT_STATE")
    @GridColumn(label="vis_emp_status", width="100", format="0=vis_record_stateIn,1=vis_record_stateOut,2=vis_record_lateCheckOut")
    private Short visitState;
    @Column(name="t.CARD_NO", encryptConverter=true)
    @GridColumn(label="pers_card_cardNo", width="100", encryptMode="${vis.cardNo.encryptMode}", encryptProp="${vis.cardNo.encryptProp}")
    private String cardNo;
    @Column(name="t.ENTER_TIME")
    @GridColumn(label="vis_emp_enterTime", width="123")
    private Date enterTime;
    @Column(name="t.ENTER_PLACE")
    @GridColumn(label="vis_emp_entrance", width="100")
    private String enterPlace;
    @Column(name="t.EXIT_TIME")
    @GridColumn(label="vis_emp_exitTime", width="123")
    private Date exitTime;
    @Column(name="t.EXIT_PLACE")
    @GridColumn(label="vis_emp_exitPlace", width="100")
    private String exitPlace;
    @Column(name="t.CARRIED_GOODS_IN")
    @GridColumn(label="vis_common_carriedGoodsIn", width="120")
    private String carriedGoodsIn;
    @Column(name="t.CARRIED_GOODS_OUT")
    @GridColumn(label="vis_common_carriedGoodsOut")
    private String carriedGoodsOut;
    @Column(name="t.VIS_EMP_ID")
    @GridColumn(show=false)
    private String visEmpId;
    @Column(name="t.VIS_EMP_CERT_TYPE")
    @GridColumn(show=false)
    private String visEmpCertType;
    @Column(name="t.VIS_EMP_CERT_NUMBER", encryptConverter=true)
    @GridColumn(show=false)
    private String visEmpCertNumber;
    @Column(name="v.PHONE", encryptConverter=true)
    @GridColumn(show=false)
    private String visEmpPhone;
    @Column(name="v.EMAIL", encryptConverter=true)
    private String email;
    @Column(name="t.VISITED_EMP_ID")
    @GridColumn(show=false)
    private String visitedEmpId;
    @Column(name="t.VISITED_EMP_OFFICE_PHONE", encryptConverter=true)
    @GridColumn(show=false)
    private String visitedEmpOfficePhone;
    @Column(name="t.VISITED_EMP_DEPT")
    @GridColumn(show=false)
    private String visitedEmpDept;
    @Column(name="t.VISITED_EMP_DEPT_ID")
    @GridColumn(show=false)
    private String visitedEmpDeptId;
    @Column(name="t.VISITOR_COUNT")
    @GridColumn(show=false)
    private Integer visitorCount;
    @Column(name="t.ENTER_PHOTO")
    @GridColumn(show=false)
    private String enterPhoto;
    @Column(name="t.EXIT_PHOTO")
    @GridColumn(show=false)
    private String exitPhoto;
    @Column(name="t.CERT_PHOTO")
    @GridColumn(show=false)
    private String certPhoto;
    @Column(name="t.SIGNATURE_PHOTO")
    @GridColumn(show=false)
    private String signaturePhoto;
    @Column(name="t.BUSINESSCARD_PHOTO")
    @GridColumn(show=false)
    private String businessCardPhoto;
    @Column(name="t.VIS_COMPANY")
    @GridColumn(label="vis_common_company", width="100")
    private String visCompany;
    @Column(name="t.LEVEL_STATE")
    @GridColumn(show=false)
    private Short levelState;
    @Column(name="t.VALID_START_TIME")
    @GridColumn(show=false)
    private Date validStartTime;
    @Column(name="t.VALID_END_TIME")
    @GridColumn(show=false)
    private Date validEndTime;
    @Column(name="t.VISIT_NUMBER")
    @GridColumn(show=false)
    private String visitNumber;
    @Column(name="t.VIS_REMARK")
    @GridColumn(show=false)
    private String visRemark;
    @Column(name="t.AREA_NAME")
    @GridColumn(show=false)
    private String areaName;
    @Column(name="t.PERSON_PWD", encryptConverter=true)
    @GridColumn(show=false)
    private String personPwd;
    @Column(name="t.ENTER_GOODS_PHOTO")
    @GridColumn(show=false)
    private String enterGoodsPhoto;
    @Column(name="t.EXIT_GOODS_PHOTO")
    @GridColumn(show=false)
    private String exitGoodsPhoto;
    @Condition(value="t.ID", equalTag="in")
    private String inId;
    @Condition(value="t.ID", equalTag="not in")
    private String notInId;
    @Condition(value="t.ENTER_TIME", equalTag=">=")
    private Date startEnterTime;
    @Condition(value="t.ENTER_TIME", equalTag="<=")
    private Date endEnterTime;
    @Column(name="t.CREATER_NAME")
    private String createrName;
    @Column(name="t.CREATER_CODE")
    private String createrCode;
    @Column(name="v.HEAD_PORTRAIT")
    private String headPortrait;
    @Column(name="v.NATIONALITY")
    private Integer nationality;
    private String nationalityStr;
    @Column(name="t.UPDATER_NAME")
    private String updaterName;
    @Column(name="t.UPDATER_CODE")
    private String updaterCode;
    @Condition(value="(LOWER (t.VIS_EMP_NAME) LIKE LOWER (''%{0}%'') OR LOWER (t.VIS_EMP_LAST_NAME) LIKE LOWER (''%{0}%''))")
    private String likeName;
    @Condition(value="(LOWER (t.VISITED_EMP_NAME) LIKE LOWER (''%{0}%'') OR LOWER (t.VISITED_EMP_LAST_NAME) LIKE LOWER (''%{0}%''))")
    private String visitedLikeName;
    @Column(name="v.GENDER")
    private String gender;
    @Column(name="v.CAR_PLATE")
    private String carPlate;
    @Condition(value="t.VISIT_STATE", equalTag="<>")
    private Short visitStateNot;
    private Boolean sendTendency;
    private String visReservationId;
    private String watchListType;
    private String watchListStatus;
    @GridColumn(dynamicColumn="visTransactionDyna")
    private Map attrValueMap;
    private String barcodeNumber;
    private String enterPhotoBase64;
    private String certPhotoBase64;
    private String enterGoodsPhotoBase64;
    private String exitPhotoBase64;
    private String exitGoodsPhotoBase64;
    private String signaturePhotoBase64;
    private String headPortraitBase64;
    private Date createTime;
    private String enterTimeStr;
    private String exitTimeStr;
    private String smsStatus;
    private String photoPathFileId;
    private String cropPhotoPathFileId;
    private String defaultFloorIds;
    @Column(name="t.PERSONNAL_LIST_ID")
    private String personnalListId;
    private String defense;
    @Condition(value="t.VISITED_EMP_DEPT_ID IN (SELECT ud.AUTH_DEPT_ID FROM AUTH_USER_DEPT ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String userId;
    @Condition(value="(t.VIS_EMP_NAME LIKE ''%{0}%'' OR t.ENTER_PLACE LIKE ''%{0}%'')")
    private String visNmameOrEnterPlaceLike;

    public VisTransactionItem() {
    }

    public VisTransactionItem(Boolean equals) {
        super(equals);
    }

    public VisTransactionItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public VisTransactionItem setId(String id) {
        this.id = id;
        return this;
    }

    public VisTransactionItem setVisEmpPin(String visEmpPin) {
        this.visEmpPin = visEmpPin;
        return this;
    }

    public VisTransactionItem setVisEmpName(String visEmpName) {
        this.visEmpName = visEmpName;
        return this;
    }

    public VisTransactionItem setVisEmpLastName(String visEmpLastName) {
        this.visEmpLastName = visEmpLastName;
        return this;
    }

    public VisTransactionItem setVisitReason(String visitReason) {
        this.visitReason = visitReason;
        return this;
    }

    public VisTransactionItem setVisitedEmpPin(String visitedEmpPin) {
        this.visitedEmpPin = visitedEmpPin;
        return this;
    }

    public VisTransactionItem setVisitedEmpName(String visitedEmpName) {
        this.visitedEmpName = visitedEmpName;
        return this;
    }

    public VisTransactionItem setVisitedEmpLastName(String visitedEmpLastName) {
        this.visitedEmpLastName = visitedEmpLastName;
        return this;
    }

    public VisTransactionItem setVisitState(Short visitState) {
        this.visitState = visitState;
        return this;
    }

    public VisTransactionItem setCardNo(String cardNo) {
        this.cardNo = cardNo;
        return this;
    }

    public VisTransactionItem setEnterTime(Date enterTime) {
        this.enterTime = enterTime;
        return this;
    }

    public VisTransactionItem setEnterPlace(String enterPlace) {
        this.enterPlace = enterPlace;
        return this;
    }

    public VisTransactionItem setExitTime(Date exitTime) {
        this.exitTime = exitTime;
        return this;
    }

    public VisTransactionItem setExitPlace(String exitPlace) {
        this.exitPlace = exitPlace;
        return this;
    }

    public VisTransactionItem setCarriedGoodsIn(String carriedGoodsIn) {
        this.carriedGoodsIn = carriedGoodsIn;
        return this;
    }

    public VisTransactionItem setCarriedGoodsOut(String carriedGoodsOut) {
        this.carriedGoodsOut = carriedGoodsOut;
        return this;
    }

    public VisTransactionItem setVisEmpId(String visEmpId) {
        this.visEmpId = visEmpId;
        return this;
    }

    public VisTransactionItem setVisEmpCertType(String visEmpCertType) {
        this.visEmpCertType = visEmpCertType;
        return this;
    }

    public VisTransactionItem setVisEmpCertNumber(String visEmpCertNumber) {
        this.visEmpCertNumber = visEmpCertNumber;
        return this;
    }

    public VisTransactionItem setVisEmpPhone(String visEmpPhone) {
        this.visEmpPhone = visEmpPhone;
        return this;
    }

    public VisTransactionItem setEmail(String email) {
        this.email = email;
        return this;
    }

    public VisTransactionItem setVisitedEmpId(String visitedEmpId) {
        this.visitedEmpId = visitedEmpId;
        return this;
    }

    public VisTransactionItem setVisitedEmpOfficePhone(String visitedEmpOfficePhone) {
        this.visitedEmpOfficePhone = visitedEmpOfficePhone;
        return this;
    }

    public VisTransactionItem setVisitedEmpDept(String visitedEmpDept) {
        this.visitedEmpDept = visitedEmpDept;
        return this;
    }

    public VisTransactionItem setVisitedEmpDeptId(String visitedEmpDeptId) {
        this.visitedEmpDeptId = visitedEmpDeptId;
        return this;
    }

    public VisTransactionItem setVisitorCount(Integer visitorCount) {
        this.visitorCount = visitorCount;
        return this;
    }

    public VisTransactionItem setEnterPhoto(String enterPhoto) {
        this.enterPhoto = enterPhoto;
        return this;
    }

    public VisTransactionItem setExitPhoto(String exitPhoto) {
        this.exitPhoto = exitPhoto;
        return this;
    }

    public VisTransactionItem setCertPhoto(String certPhoto) {
        this.certPhoto = certPhoto;
        return this;
    }

    public VisTransactionItem setSignaturePhoto(String signaturePhoto) {
        this.signaturePhoto = signaturePhoto;
        return this;
    }

    public VisTransactionItem setBusinessCardPhoto(String businessCardPhoto) {
        this.businessCardPhoto = businessCardPhoto;
        return this;
    }

    public VisTransactionItem setVisCompany(String visCompany) {
        this.visCompany = visCompany;
        return this;
    }

    public VisTransactionItem setLevelState(Short levelState) {
        this.levelState = levelState;
        return this;
    }

    public VisTransactionItem setValidStartTime(Date validStartTime) {
        this.validStartTime = validStartTime;
        return this;
    }

    public VisTransactionItem setValidEndTime(Date validEndTime) {
        this.validEndTime = validEndTime;
        return this;
    }

    public VisTransactionItem setVisitNumber(String visitNumber) {
        this.visitNumber = visitNumber;
        return this;
    }

    public VisTransactionItem setVisRemark(String visRemark) {
        this.visRemark = visRemark;
        return this;
    }

    public VisTransactionItem setAreaName(String areaName) {
        this.areaName = areaName;
        return this;
    }

    public VisTransactionItem setPersonPwd(String personPwd) {
        this.personPwd = personPwd;
        return this;
    }

    public VisTransactionItem setEnterGoodsPhoto(String enterGoodsPhoto) {
        this.enterGoodsPhoto = enterGoodsPhoto;
        return this;
    }

    public VisTransactionItem setExitGoodsPhoto(String exitGoodsPhoto) {
        this.exitGoodsPhoto = exitGoodsPhoto;
        return this;
    }

    public VisTransactionItem setInId(String inId) {
        this.inId = inId;
        return this;
    }

    public VisTransactionItem setNotInId(String notInId) {
        this.notInId = notInId;
        return this;
    }

    public VisTransactionItem setStartEnterTime(Date startEnterTime) {
        this.startEnterTime = startEnterTime;
        return this;
    }

    public VisTransactionItem setEndEnterTime(Date endEnterTime) {
        this.endEnterTime = endEnterTime;
        return this;
    }

    public VisTransactionItem setCreaterName(String createrName) {
        this.createrName = createrName;
        return this;
    }

    public VisTransactionItem setCreaterCode(String createrCode) {
        this.createrCode = createrCode;
        return this;
    }

    public VisTransactionItem setHeadPortrait(String headPortrait) {
        this.headPortrait = headPortrait;
        return this;
    }

    public VisTransactionItem setNationality(Integer nationality) {
        this.nationality = nationality;
        return this;
    }

    public VisTransactionItem setNationalityStr(String nationalityStr) {
        this.nationalityStr = nationalityStr;
        return this;
    }

    public VisTransactionItem setUpdaterName(String updaterName) {
        this.updaterName = updaterName;
        return this;
    }

    public VisTransactionItem setUpdaterCode(String updaterCode) {
        this.updaterCode = updaterCode;
        return this;
    }

    public VisTransactionItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public VisTransactionItem setVisitedLikeName(String visitedLikeName) {
        this.visitedLikeName = visitedLikeName;
        return this;
    }

    public VisTransactionItem setGender(String gender) {
        this.gender = gender;
        return this;
    }

    public VisTransactionItem setCarPlate(String carPlate) {
        this.carPlate = carPlate;
        return this;
    }

    public VisTransactionItem setVisitStateNot(Short visitStateNot) {
        this.visitStateNot = visitStateNot;
        return this;
    }

    public VisTransactionItem setSendTendency(Boolean sendTendency) {
        this.sendTendency = sendTendency;
        return this;
    }

    public VisTransactionItem setVisReservationId(String visReservationId) {
        this.visReservationId = visReservationId;
        return this;
    }

    public VisTransactionItem setWatchListType(String watchListType) {
        this.watchListType = watchListType;
        return this;
    }

    public VisTransactionItem setWatchListStatus(String watchListStatus) {
        this.watchListStatus = watchListStatus;
        return this;
    }

    public VisTransactionItem setAttrValueMap(Map attrValueMap) {
        this.attrValueMap = attrValueMap;
        return this;
    }

    public VisTransactionItem setBarcodeNumber(String barcodeNumber) {
        this.barcodeNumber = barcodeNumber;
        return this;
    }

    public VisTransactionItem setEnterPhotoBase64(String enterPhotoBase64) {
        this.enterPhotoBase64 = enterPhotoBase64;
        return this;
    }

    public VisTransactionItem setCertPhotoBase64(String certPhotoBase64) {
        this.certPhotoBase64 = certPhotoBase64;
        return this;
    }

    public VisTransactionItem setEnterGoodsPhotoBase64(String enterGoodsPhotoBase64) {
        this.enterGoodsPhotoBase64 = enterGoodsPhotoBase64;
        return this;
    }

    public VisTransactionItem setExitPhotoBase64(String exitPhotoBase64) {
        this.exitPhotoBase64 = exitPhotoBase64;
        return this;
    }

    public VisTransactionItem setExitGoodsPhotoBase64(String exitGoodsPhotoBase64) {
        this.exitGoodsPhotoBase64 = exitGoodsPhotoBase64;
        return this;
    }

    public VisTransactionItem setSignaturePhotoBase64(String signaturePhotoBase64) {
        this.signaturePhotoBase64 = signaturePhotoBase64;
        return this;
    }

    public VisTransactionItem setHeadPortraitBase64(String headPortraitBase64) {
        this.headPortraitBase64 = headPortraitBase64;
        return this;
    }

    public VisTransactionItem setCreateTime(Date createTime) {
        this.createTime = createTime;
        return this;
    }

    public VisTransactionItem setEnterTimeStr(String enterTimeStr) {
        this.enterTimeStr = enterTimeStr;
        return this;
    }

    public VisTransactionItem setExitTimeStr(String exitTimeStr) {
        this.exitTimeStr = exitTimeStr;
        return this;
    }

    public VisTransactionItem setSmsStatus(String smsStatus) {
        this.smsStatus = smsStatus;
        return this;
    }

    public VisTransactionItem setPhotoPathFileId(String photoPathFileId) {
        this.photoPathFileId = photoPathFileId;
        return this;
    }

    public VisTransactionItem setCropPhotoPathFileId(String cropPhotoPathFileId) {
        this.cropPhotoPathFileId = cropPhotoPathFileId;
        return this;
    }

    public VisTransactionItem setDefaultFloorIds(String defaultFloorIds) {
        this.defaultFloorIds = defaultFloorIds;
        return this;
    }

    public VisTransactionItem setPersonnalListId(String personnalListId) {
        this.personnalListId = personnalListId;
        return this;
    }

    public VisTransactionItem setDefense(String defense) {
        this.defense = defense;
        return this;
    }

    public VisTransactionItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public VisTransactionItem setVisNmameOrEnterPlaceLike(String visNmameOrEnterPlaceLike) {
        this.visNmameOrEnterPlaceLike = visNmameOrEnterPlaceLike;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getVisEmpPin() {
        return this.visEmpPin;
    }

    public String getVisEmpName() {
        return this.visEmpName;
    }

    public String getVisEmpLastName() {
        return this.visEmpLastName;
    }

    public String getVisitReason() {
        return this.visitReason;
    }

    public String getVisitedEmpPin() {
        return this.visitedEmpPin;
    }

    public String getVisitedEmpName() {
        return this.visitedEmpName;
    }

    public String getVisitedEmpLastName() {
        return this.visitedEmpLastName;
    }

    public Short getVisitState() {
        return this.visitState;
    }

    public String getCardNo() {
        return this.cardNo;
    }

    public Date getEnterTime() {
        return this.enterTime;
    }

    public String getEnterPlace() {
        return this.enterPlace;
    }

    public Date getExitTime() {
        return this.exitTime;
    }

    public String getExitPlace() {
        return this.exitPlace;
    }

    public String getCarriedGoodsIn() {
        return this.carriedGoodsIn;
    }

    public String getCarriedGoodsOut() {
        return this.carriedGoodsOut;
    }

    public String getVisEmpId() {
        return this.visEmpId;
    }

    public String getVisEmpCertType() {
        return this.visEmpCertType;
    }

    public String getVisEmpCertNumber() {
        return this.visEmpCertNumber;
    }

    public String getVisEmpPhone() {
        return this.visEmpPhone;
    }

    public String getEmail() {
        return this.email;
    }

    public String getVisitedEmpId() {
        return this.visitedEmpId;
    }

    public String getVisitedEmpOfficePhone() {
        return this.visitedEmpOfficePhone;
    }

    public String getVisitedEmpDept() {
        return this.visitedEmpDept;
    }

    public String getVisitedEmpDeptId() {
        return this.visitedEmpDeptId;
    }

    public Integer getVisitorCount() {
        return this.visitorCount;
    }

    public String getEnterPhoto() {
        return this.enterPhoto;
    }

    public String getExitPhoto() {
        return this.exitPhoto;
    }

    public String getCertPhoto() {
        return this.certPhoto;
    }

    public String getSignaturePhoto() {
        return this.signaturePhoto;
    }

    public String getBusinessCardPhoto() {
        return this.businessCardPhoto;
    }

    public String getVisCompany() {
        return this.visCompany;
    }

    public Short getLevelState() {
        return this.levelState;
    }

    public Date getValidStartTime() {
        return this.validStartTime;
    }

    public Date getValidEndTime() {
        return this.validEndTime;
    }

    public String getVisitNumber() {
        return this.visitNumber;
    }

    public String getVisRemark() {
        return this.visRemark;
    }

    public String getAreaName() {
        return this.areaName;
    }

    public String getPersonPwd() {
        return this.personPwd;
    }

    public String getEnterGoodsPhoto() {
        return this.enterGoodsPhoto;
    }

    public String getExitGoodsPhoto() {
        return this.exitGoodsPhoto;
    }

    public String getInId() {
        return this.inId;
    }

    public String getNotInId() {
        return this.notInId;
    }

    public Date getStartEnterTime() {
        return this.startEnterTime;
    }

    public Date getEndEnterTime() {
        return this.endEnterTime;
    }

    public String getCreaterName() {
        return this.createrName;
    }

    public String getCreaterCode() {
        return this.createrCode;
    }

    public String getHeadPortrait() {
        return this.headPortrait;
    }

    public Integer getNationality() {
        return this.nationality;
    }

    public String getNationalityStr() {
        return this.nationalityStr;
    }

    public String getUpdaterName() {
        return this.updaterName;
    }

    public String getUpdaterCode() {
        return this.updaterCode;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getVisitedLikeName() {
        return this.visitedLikeName;
    }

    public String getGender() {
        return this.gender;
    }

    public String getCarPlate() {
        return this.carPlate;
    }

    public Short getVisitStateNot() {
        return this.visitStateNot;
    }

    public Boolean getSendTendency() {
        return this.sendTendency;
    }

    public String getVisReservationId() {
        return this.visReservationId;
    }

    public String getWatchListType() {
        return this.watchListType;
    }

    public String getWatchListStatus() {
        return this.watchListStatus;
    }

    public Map getAttrValueMap() {
        return this.attrValueMap;
    }

    public String getBarcodeNumber() {
        return this.barcodeNumber;
    }

    public String getEnterPhotoBase64() {
        return this.enterPhotoBase64;
    }

    public String getCertPhotoBase64() {
        return this.certPhotoBase64;
    }

    public String getEnterGoodsPhotoBase64() {
        return this.enterGoodsPhotoBase64;
    }

    public String getExitPhotoBase64() {
        return this.exitPhotoBase64;
    }

    public String getExitGoodsPhotoBase64() {
        return this.exitGoodsPhotoBase64;
    }

    public String getSignaturePhotoBase64() {
        return this.signaturePhotoBase64;
    }

    public String getHeadPortraitBase64() {
        return this.headPortraitBase64;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public String getEnterTimeStr() {
        return this.enterTimeStr;
    }

    public String getExitTimeStr() {
        return this.exitTimeStr;
    }

    public String getSmsStatus() {
        return this.smsStatus;
    }

    public String getPhotoPathFileId() {
        return this.photoPathFileId;
    }

    public String getCropPhotoPathFileId() {
        return this.cropPhotoPathFileId;
    }

    public String getDefaultFloorIds() {
        return this.defaultFloorIds;
    }

    public String getPersonnalListId() {
        return this.personnalListId;
    }

    public String getDefense() {
        return this.defense;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getVisNmameOrEnterPlaceLike() {
        return this.visNmameOrEnterPlaceLike;
    }
}

