/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GridOperate;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.io.Serializable;

@From(after="VIS_RESERVATION_INVITATION t LEFT JOIN PERS_PERSON p ON t.VISITED_EMP_ID=p.ID LEFT join AUTH_DEPARTMENT d on p.auth_dept_id = d.id")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=true, idField="id", winHeight=460, winWidth=650, operates={@GridOperate(type="edit", permission="vis:reservationInvitation:edit", url="visReservationInvitation.do?edit", label="common_op_edit"), @GridOperate(type="del", permission="vis:reservationInvitation:del", url="visReservationInvitation.do?del&email=(email)&inviteName=(inviteName)&sendTime=(sendTime)", label="common_op_del")})
public class VisReservationInvitationItem
extends BaseItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40")
    private String id;
    @Column(name="p.NAME")
    @GridColumn(label="vis_reservation_invitationName", width="150", sortNo=1, encryptMode="${pers.name.encryptMode}", encryptProp="${pers.name.encryptProp}")
    private String inviteName;
    @Column(name="p.LAST_NAME")
    @GridColumn(label="vis_reservation_invitationLastName", width="150", showExpression="#language!='zh_CN'", encryptMode="${pers.lastName.encryptMode}", encryptProp="${pers.lastName.encryptProp}")
    private String inviteLastName;
    @Column(name="d.NAME")
    @GridColumn(label="vis_reservation_invitationDeptName", width="150")
    private String inviteDeptName;
    @Column(name="t.VISITOR_EMAIL", encryptConverter=true)
    @GridColumn(label="common_linkIO_mailAddr", width="200", encryptMode="${vis.email.encryptMode}", encryptProp="${vis.email.encryptProp}")
    private String visitorEmail;
    @Column(name="t.EMAIL_CONTENT")
    private String emailContent;
    @Column(name="t.IS_SEND")
    @GridColumn(label="common_status", format="0=vis_reservation_noSend,1=vis_reservation_sendSuccess,2=vis_reservation_sendFail", width="100")
    private Short isSend;
    @Column(name="t.EMAIL_SEND_TIME")
    @GridColumn(label="vis_alertTempalte_sendTime", width="150")
    private String sendTime;
    @Column(name="p.PIN")
    private String invitePin;
    @Column(name="p.AUTH_DEPT_ID", equalTag="=")
    private String inviteDeptId;
    @Column(name="t.VISITED_EMP_ID")
    private String visitedEmpId;
    private String sendFailMsg;
    @Condition(value="(LOWER(p.NAME) LIKE LOWER(''%{0}%'') OR LOWER(p.LAST_NAME) LIKE LOWER(''%{0}%''))")
    private String likeName;
    @Condition(value="t.VISITED_EMP_ID IN (%s)", formatType="quote")
    private String visitedEmpIdIn;

    public String getId() {
        return this.id;
    }

    public String getInviteName() {
        return this.inviteName;
    }

    public String getInviteLastName() {
        return this.inviteLastName;
    }

    public String getInviteDeptName() {
        return this.inviteDeptName;
    }

    public String getVisitorEmail() {
        return this.visitorEmail;
    }

    public String getEmailContent() {
        return this.emailContent;
    }

    public Short getIsSend() {
        return this.isSend;
    }

    public String getSendTime() {
        return this.sendTime;
    }

    public String getInvitePin() {
        return this.invitePin;
    }

    public String getInviteDeptId() {
        return this.inviteDeptId;
    }

    public String getVisitedEmpId() {
        return this.visitedEmpId;
    }

    public String getSendFailMsg() {
        return this.sendFailMsg;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getVisitedEmpIdIn() {
        return this.visitedEmpIdIn;
    }

    public VisReservationInvitationItem setId(String id) {
        this.id = id;
        return this;
    }

    public VisReservationInvitationItem setInviteName(String inviteName) {
        this.inviteName = inviteName;
        return this;
    }

    public VisReservationInvitationItem setInviteLastName(String inviteLastName) {
        this.inviteLastName = inviteLastName;
        return this;
    }

    public VisReservationInvitationItem setInviteDeptName(String inviteDeptName) {
        this.inviteDeptName = inviteDeptName;
        return this;
    }

    public VisReservationInvitationItem setVisitorEmail(String visitorEmail) {
        this.visitorEmail = visitorEmail;
        return this;
    }

    public VisReservationInvitationItem setEmailContent(String emailContent) {
        this.emailContent = emailContent;
        return this;
    }

    public VisReservationInvitationItem setIsSend(Short isSend) {
        this.isSend = isSend;
        return this;
    }

    public VisReservationInvitationItem setSendTime(String sendTime) {
        this.sendTime = sendTime;
        return this;
    }

    public VisReservationInvitationItem setInvitePin(String invitePin) {
        this.invitePin = invitePin;
        return this;
    }

    public VisReservationInvitationItem setInviteDeptId(String inviteDeptId) {
        this.inviteDeptId = inviteDeptId;
        return this;
    }

    public VisReservationInvitationItem setVisitedEmpId(String visitedEmpId) {
        this.visitedEmpId = visitedEmpId;
        return this;
    }

    public VisReservationInvitationItem setSendFailMsg(String sendFailMsg) {
        this.sendFailMsg = sendFailMsg;
        return this;
    }

    public VisReservationInvitationItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public VisReservationInvitationItem setVisitedEmpIdIn(String visitedEmpIdIn) {
        this.visitedEmpIdIn = visitedEmpIdIn;
        return this;
    }

    public String toString() {
        return "VisReservationInvitationItem(id=" + this.getId() + ", inviteName=" + this.getInviteName() + ", inviteLastName=" + this.getInviteLastName() + ", inviteDeptName=" + this.getInviteDeptName() + ", visitorEmail=" + this.getVisitorEmail() + ", emailContent=" + this.getEmailContent() + ", isSend=" + this.getIsSend() + ", sendTime=" + this.getSendTime() + ", invitePin=" + this.getInvitePin() + ", inviteDeptId=" + this.getInviteDeptId() + ", visitedEmpId=" + this.getVisitedEmpId() + ", sendFailMsg=" + this.getSendFailMsg() + ", likeName=" + this.getLikeName() + ", visitedEmpIdIn=" + this.getVisitedEmpIdIn() + ")";
    }
}

