/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GridOperate;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.io.Serializable;

@From(after="VIS_RESERVATION t LEFT JOIN VIS_VISITOR v ON T.VISITOR_ID=v.id")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=true, idField="id", winHeight=540, winWidth=770, operates={@GridOperate(type="edit", permission="vis:invitation:edit", url="visReservation.do?edit", label="common_op_edit")})
public class VisInvitationItem
extends BaseItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sort="na")
    private String id;
    private String visitEmpCompany;
    @Column(name="v.COMPANY")
    private String company;
    @Column(name="t.VISIT_EMP_PIN", equalTag="=")
    @GridColumn(label="vis_reservation_invitationPin", width="100", sortNo=2, encryptMode="${pers.pin.encryptMode}", encryptProp="${pers.pin.encryptProp}")
    private String visitEmpPin;
    @Column(name="t.VISIT_EMP_NAME")
    @GridColumn(label="vis_reservation_invitationName", width="100", sortNo=3, encryptMode="${pers.name.encryptMode}", encryptProp="${pers.name.encryptProp}")
    private String visitEmpName;
    @Column(name="t.VISIT_EMP_LAST_NAME")
    @GridColumn(label="vis_reservation_invitationLastName", width="100", showExpression="#language!='zh_CN'", sortNo=4, encryptMode="${pers.lastName.encryptMode}", encryptProp="${pers.lastName.encryptProp}")
    private String visitEmpLastName;
    @Column(name="t.VISIT_EMP_DEPT_NAME")
    @GridColumn(label="vis_common_visitedDept", width="120", sortNo=5)
    private String visitEmpDeptName;
    @Column(name="v.NAME")
    @GridColumn(label="pers_person_name", width="100", sortNo=6, encryptMode="${vis.name.encryptMode}", encryptProp="${vis.name.encryptProp}")
    private String visitorName;
    @Column(name="v.LAST_NAME")
    @GridColumn(label="pers_person_lastName", width="100", showExpression="#language!='zh_CN'", sortNo=7, encryptMode="${vis.lastName.encryptMode}", encryptProp="${vis.lastName.encryptProp}")
    private String visitorLastName;
    @Column(name="v.CERT_TYPE")
    private String certType;
    @Column(name="v.CERT_TYPE")
    @GridColumn(columnType="dic", key="certificateType", label="vis_cert_type", width="120")
    private String certName;
    @Column(name="v.CERT_NUMBER", encryptConverter=true)
    @GridColumn(label="vis_cert_number", width="150", encryptMode="${vis.certNumber.encryptMode}", encryptProp="${vis.certNumber.encryptProp}")
    private String certNumber;
    @Column(name="v.PHONE", encryptConverter=true)
    @GridColumn(label="vis_export_mobilePhone", width="120", encryptMode="${vis.mobilePhone.encryptMode}", encryptProp="${vis.mobilePhone.encryptProp}")
    private String phone;
    @Column(name="t.AUDIT_STATUS")
    @GridColumn(label="vis_reservation_auditStatus", format="0=vis_reservation_notAudit,1=vis_reservation_yesAudit,2=vis_reservation_refuse,3=vis_reservation_inAudit", sortNo=11)
    private Short auditStatus;
    @Column(name="t.VISIT_REASON")
    @GridColumn(label="vis_reason_name", width="100", sortNo=12)
    private String visitReason;
    @Column(name="t.VISIT_DATE")
    @GridColumn(label="vis_common_date", width="120", sortNo=13)
    private String visitDate;
    @Column(name="t.VISIT_END_DATE")
    @GridColumn(label="vis_cloud_endDate", width="120", sortNo=14)
    private String visitEndDate;
    @Column(name="t.VISITOR_COUNT")
    private Integer visitorCount;
    @Column(name="t.PHOTO_PATH")
    private String photoPath;
    @Column(name="t.CROP_PHOTO_PATH")
    private String cropPhotoPath;
    @Column(name="t.CERT_PHOTO")
    private String certPhoto;
    @Column(name="t.VISIT_EMP_DEPT_ID", equalTag="=")
    private String visitEmpDeptId;
    @Column(name="t.VISIT_EMP_ID", equalTag="=")
    private String visitedEmpId;
    @Column(name="t.IS_VISITED")
    @GridColumn(label="vis_emp_status", width="120", format="0=vis_reservation_hasVisited,1=vis_reservation_notVisited,2=vis_reservation_waste,3=vis_reservation_cancel,4=vis_reservation_waste_notVisited,5=vis_reservation_failReservation,6=vis_cloud_hasInvite,7=vis_cloud_confirmInvite,8=vis_cloud_cancelInvite", sortNo=15)
    private String isVisited;
    @Column(name="t.REMARK")
    private String remark;
    @Condition(value="t.ID", equalTag="in")
    private String inId;
    @Column(name="t.IS_FROM", equalTag="=")
    private String isFrom;
    @Column(name="t.RESERVATION_TYPE", equalTag="=")
    private String reservationType;
    @Condition(value="t.PARENT_RESERVATION_ID IS NULL")
    private String isNullParentReservationId;
    @Column(name="t.PARENT_RESERVATION_ID")
    private String parentReservationId;
    @Condition(value="(LOWER (v.NAME) LIKE LOWER (''%{0}%'') OR LOWER (v.LAST_NAME) LIKE LOWER (''%{0}%''))")
    private String likeName;
    @Condition(value="(LOWER (t.VISIT_EMP_NAME) LIKE LOWER (''%{0}%'') OR LOWER (t.VISIT_EMP_LAST_NAME) LIKE LOWER (''%{0}%''))")
    private String visitedLikeName;

    public VisInvitationItem() {
    }

    public VisInvitationItem(String id) {
        this.id = id;
    }

    public VisInvitationItem setId(String id) {
        this.id = id;
        return this;
    }

    public VisInvitationItem setVisitEmpCompany(String visitEmpCompany) {
        this.visitEmpCompany = visitEmpCompany;
        return this;
    }

    public VisInvitationItem setCompany(String company) {
        this.company = company;
        return this;
    }

    public VisInvitationItem setVisitEmpPin(String visitEmpPin) {
        this.visitEmpPin = visitEmpPin;
        return this;
    }

    public VisInvitationItem setVisitEmpName(String visitEmpName) {
        this.visitEmpName = visitEmpName;
        return this;
    }

    public VisInvitationItem setVisitEmpLastName(String visitEmpLastName) {
        this.visitEmpLastName = visitEmpLastName;
        return this;
    }

    public VisInvitationItem setVisitEmpDeptName(String visitEmpDeptName) {
        this.visitEmpDeptName = visitEmpDeptName;
        return this;
    }

    public VisInvitationItem setVisitorName(String visitorName) {
        this.visitorName = visitorName;
        return this;
    }

    public VisInvitationItem setVisitorLastName(String visitorLastName) {
        this.visitorLastName = visitorLastName;
        return this;
    }

    public VisInvitationItem setCertType(String certType) {
        this.certType = certType;
        return this;
    }

    public VisInvitationItem setCertName(String certName) {
        this.certName = certName;
        return this;
    }

    public VisInvitationItem setCertNumber(String certNumber) {
        this.certNumber = certNumber;
        return this;
    }

    public VisInvitationItem setPhone(String phone) {
        this.phone = phone;
        return this;
    }

    public VisInvitationItem setAuditStatus(Short auditStatus) {
        this.auditStatus = auditStatus;
        return this;
    }

    public VisInvitationItem setVisitReason(String visitReason) {
        this.visitReason = visitReason;
        return this;
    }

    public VisInvitationItem setVisitDate(String visitDate) {
        this.visitDate = visitDate;
        return this;
    }

    public VisInvitationItem setVisitEndDate(String visitEndDate) {
        this.visitEndDate = visitEndDate;
        return this;
    }

    public VisInvitationItem setVisitorCount(Integer visitorCount) {
        this.visitorCount = visitorCount;
        return this;
    }

    public VisInvitationItem setPhotoPath(String photoPath) {
        this.photoPath = photoPath;
        return this;
    }

    public VisInvitationItem setCropPhotoPath(String cropPhotoPath) {
        this.cropPhotoPath = cropPhotoPath;
        return this;
    }

    public VisInvitationItem setCertPhoto(String certPhoto) {
        this.certPhoto = certPhoto;
        return this;
    }

    public VisInvitationItem setVisitEmpDeptId(String visitEmpDeptId) {
        this.visitEmpDeptId = visitEmpDeptId;
        return this;
    }

    public VisInvitationItem setVisitedEmpId(String visitedEmpId) {
        this.visitedEmpId = visitedEmpId;
        return this;
    }

    public VisInvitationItem setIsVisited(String isVisited) {
        this.isVisited = isVisited;
        return this;
    }

    public VisInvitationItem setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public VisInvitationItem setInId(String inId) {
        this.inId = inId;
        return this;
    }

    public VisInvitationItem setIsFrom(String isFrom) {
        this.isFrom = isFrom;
        return this;
    }

    public VisInvitationItem setReservationType(String reservationType) {
        this.reservationType = reservationType;
        return this;
    }

    public VisInvitationItem setIsNullParentReservationId(String isNullParentReservationId) {
        this.isNullParentReservationId = isNullParentReservationId;
        return this;
    }

    public VisInvitationItem setParentReservationId(String parentReservationId) {
        this.parentReservationId = parentReservationId;
        return this;
    }

    public VisInvitationItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public VisInvitationItem setVisitedLikeName(String visitedLikeName) {
        this.visitedLikeName = visitedLikeName;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getVisitEmpCompany() {
        return this.visitEmpCompany;
    }

    public String getCompany() {
        return this.company;
    }

    public String getVisitEmpPin() {
        return this.visitEmpPin;
    }

    public String getVisitEmpName() {
        return this.visitEmpName;
    }

    public String getVisitEmpLastName() {
        return this.visitEmpLastName;
    }

    public String getVisitEmpDeptName() {
        return this.visitEmpDeptName;
    }

    public String getVisitorName() {
        return this.visitorName;
    }

    public String getVisitorLastName() {
        return this.visitorLastName;
    }

    public String getCertType() {
        return this.certType;
    }

    public String getCertName() {
        return this.certName;
    }

    public String getCertNumber() {
        return this.certNumber;
    }

    public String getPhone() {
        return this.phone;
    }

    public Short getAuditStatus() {
        return this.auditStatus;
    }

    public String getVisitReason() {
        return this.visitReason;
    }

    public String getVisitDate() {
        return this.visitDate;
    }

    public String getVisitEndDate() {
        return this.visitEndDate;
    }

    public Integer getVisitorCount() {
        return this.visitorCount;
    }

    public String getPhotoPath() {
        return this.photoPath;
    }

    public String getCropPhotoPath() {
        return this.cropPhotoPath;
    }

    public String getCertPhoto() {
        return this.certPhoto;
    }

    public String getVisitEmpDeptId() {
        return this.visitEmpDeptId;
    }

    public String getVisitedEmpId() {
        return this.visitedEmpId;
    }

    public String getIsVisited() {
        return this.isVisited;
    }

    public String getRemark() {
        return this.remark;
    }

    public String getInId() {
        return this.inId;
    }

    public String getIsFrom() {
        return this.isFrom;
    }

    public String getReservationType() {
        return this.reservationType;
    }

    public String getIsNullParentReservationId() {
        return this.isNullParentReservationId;
    }

    public String getParentReservationId() {
        return this.parentReservationId;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getVisitedLikeName() {
        return this.visitedLikeName;
    }
}

