/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.io.Serializable;

@From(after="PERS_PERSON t LEFT join AUTH_DEPARTMENT d on t.auth_dept_id = d.id")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=false, idField="id", winHeight=400, winWidth=600)
public class VisEmployeeSelectItem
extends BaseItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID", equalTag="=")
    @GridColumn(columnType="ra", width="40", sortNo=0)
    private String id;
    @Column(name="t.PIN")
    @GridColumn(label="vis_record_visitedPin", width="80")
    private String persPin;
    @Column(name="t.NAME")
    @GridColumn(label="vis_record_visitedName", width="100")
    private String persName;
    @Column(name="t.LAST_NAME")
    @GridColumn(label="vis_record_visitedLastName", width="100", showExpression="#language!='zh_CN'")
    private String persLastName;
    @Column(name="t.GENDER", equalTag="=")
    @GridColumn(label="pers_person_gender", width="60", format="M=pers_person_male,F=pers_person_female")
    private String gender;
    @Column(name="d.NAME")
    @GridColumn(label="pers_dept_deptName", width="123", sort="na")
    private String deptName;
    private String photoPath;
    @Column(name="d.id")
    private String deptId;
    private String type;
    private String selectId;
    @Condition(value="(LOWER (t.NAME) LIKE LOWER (''%{0}%'') OR LOWER (t.LAST_NAME) LIKE LOWER (''%{0}%''))")
    private String likeName;
    private String photoBase64;
    @Condition(value="t.AUTH_DEPT_ID IN (SELECT ud.AUTH_DEPT_ID FROM AUTH_USER_DEPT ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String userId;
    @Condition(value="t.ID", equalTag="not in")
    private String notInId;
    @Column(name="t.ENABLED_CREDENTIAL")
    private Boolean enabledCredential;

    public String getId() {
        return this.id;
    }

    public String getPersPin() {
        return this.persPin;
    }

    public String getPersName() {
        return this.persName;
    }

    public String getPersLastName() {
        return this.persLastName;
    }

    public String getGender() {
        return this.gender;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public String getPhotoPath() {
        return this.photoPath;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public String getType() {
        return this.type;
    }

    public String getSelectId() {
        return this.selectId;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getPhotoBase64() {
        return this.photoBase64;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getNotInId() {
        return this.notInId;
    }

    public Boolean getEnabledCredential() {
        return this.enabledCredential;
    }

    public VisEmployeeSelectItem setId(String id) {
        this.id = id;
        return this;
    }

    public VisEmployeeSelectItem setPersPin(String persPin) {
        this.persPin = persPin;
        return this;
    }

    public VisEmployeeSelectItem setPersName(String persName) {
        this.persName = persName;
        return this;
    }

    public VisEmployeeSelectItem setPersLastName(String persLastName) {
        this.persLastName = persLastName;
        return this;
    }

    public VisEmployeeSelectItem setGender(String gender) {
        this.gender = gender;
        return this;
    }

    public VisEmployeeSelectItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public VisEmployeeSelectItem setPhotoPath(String photoPath) {
        this.photoPath = photoPath;
        return this;
    }

    public VisEmployeeSelectItem setDeptId(String deptId) {
        this.deptId = deptId;
        return this;
    }

    public VisEmployeeSelectItem setType(String type) {
        this.type = type;
        return this;
    }

    public VisEmployeeSelectItem setSelectId(String selectId) {
        this.selectId = selectId;
        return this;
    }

    public VisEmployeeSelectItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public VisEmployeeSelectItem setPhotoBase64(String photoBase64) {
        this.photoBase64 = photoBase64;
        return this;
    }

    public VisEmployeeSelectItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public VisEmployeeSelectItem setNotInId(String notInId) {
        this.notInId = notInId;
        return this;
    }

    public VisEmployeeSelectItem setEnabledCredential(Boolean enabledCredential) {
        this.enabledCredential = enabledCredential;
        return this;
    }
}

