/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.io.Serializable;
import java.util.Date;

@From(after="VIS_RESERVATION t LEFT JOIN VIS_VISITOR v ON T.VISITOR_ID=v.id")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=false, idField="id")
public class VisBatchCheckInItem
extends BaseItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sortNo=0)
    private String id;
    @Column(name="v.NAME")
    @GridColumn(label="pers_person_name", width="80")
    private String visitorName;
    @Column(name="v.LAST_NAME")
    @GridColumn(label="pers_person_lastName", width="80", showExpression="#language!='zh_CN'")
    private String visitorLastName;
    @Column(name="v.CERT_TYPE", equalTag="=")
    @GridColumn(columnType="dic", key="certificateType", label="vis_cert_type", width="100")
    private String certType;
    @Column(name="v.CERT_NUMBER", equalTag="=", encryptConverter=true)
    @GridColumn(label="vis_cert_number", width="120")
    private String certNumber;
    @Column(name="t.VISIT_EMP_PIN")
    private String visitEmpPin;
    @Column(name="t.VISIT_EMP_NAME")
    @GridColumn(label="vis_record_visitedName", width="100")
    private String visitEmpName;
    @Column(name="t.VISIT_EMP_LAST_NAME")
    @GridColumn(label="vis_record_visitedLastName", width="100", showExpression="#language!='zh_CN'")
    private String visitEmpLastName;
    @Column(name="t.VISIT_EMP_DEPT_NAME")
    @GridColumn(label="vis_common_visitedDept", width="120")
    private String visitEmpDeptName;
    private String visitEmpDeptCode;
    @Column(name="v.PHONE", equalTag=" = ", encryptConverter=true)
    @GridColumn(label="vis_export_mobilePhone", width="120")
    private String phone;
    @Column(name="v.EMAIL", encryptConverter=true)
    @GridColumn(label="pers_person_email", width="120")
    private String email;
    @Column(name="v.COMPANY")
    @GridColumn(label="vis_common_company", width="100")
    private String company;
    @Column(name="t.PHOTO_PATH")
    @GridColumn(label="vis_common_enterPhoto", width="100", columnType="custom", convert="convertEnterPhoto")
    private String photoPath;
    @Column(name="t.VISIT_REASON")
    private String visitReason;
    @Column(name="t.VISIT_DATE")
    private Date visitDateView;
    @Column(name="v.CAR_PLATE")
    private String carPlate;
    private String enterPlace;
    @Condition(value="(LOWER (v.NAME) LIKE LOWER (''%{0}%'') OR LOWER (v.LAST_NAME) LIKE LOWER (''%{0}%''))")
    private String likeName;
    @Condition(value="(LOWER (t.VISIT_EMP_NAME) LIKE LOWER (''%{0}%'') OR LOWER (t.VISIT_EMP_LAST_NAME) LIKE LOWER (''%{0}%''))")
    private String visitedLikeName;
    @Condition(value="(t.AUDIT_STATUS not in (%s) or t.AUDIT_STATUS is null)", formatType="quote")
    private String notInAuditStatus;
    @Column(name="t.IS_VISITED")
    private String isVisited;
    private String levelIds;
    private String validStartTime;
    private String validEndTime;
    private String defaultFloorIds;

    public VisBatchCheckInItem() {
    }

    public VisBatchCheckInItem(Boolean equals) {
        super(equals);
    }

    public VisBatchCheckInItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public VisBatchCheckInItem setId(String id) {
        this.id = id;
        return this;
    }

    public VisBatchCheckInItem setVisitorName(String visitorName) {
        this.visitorName = visitorName;
        return this;
    }

    public VisBatchCheckInItem setVisitorLastName(String visitorLastName) {
        this.visitorLastName = visitorLastName;
        return this;
    }

    public VisBatchCheckInItem setCertType(String certType) {
        this.certType = certType;
        return this;
    }

    public VisBatchCheckInItem setCertNumber(String certNumber) {
        this.certNumber = certNumber;
        return this;
    }

    public VisBatchCheckInItem setVisitEmpPin(String visitEmpPin) {
        this.visitEmpPin = visitEmpPin;
        return this;
    }

    public VisBatchCheckInItem setVisitEmpName(String visitEmpName) {
        this.visitEmpName = visitEmpName;
        return this;
    }

    public VisBatchCheckInItem setVisitEmpLastName(String visitEmpLastName) {
        this.visitEmpLastName = visitEmpLastName;
        return this;
    }

    public VisBatchCheckInItem setVisitEmpDeptName(String visitEmpDeptName) {
        this.visitEmpDeptName = visitEmpDeptName;
        return this;
    }

    public VisBatchCheckInItem setVisitEmpDeptCode(String visitEmpDeptCode) {
        this.visitEmpDeptCode = visitEmpDeptCode;
        return this;
    }

    public VisBatchCheckInItem setPhone(String phone) {
        this.phone = phone;
        return this;
    }

    public VisBatchCheckInItem setEmail(String email) {
        this.email = email;
        return this;
    }

    public VisBatchCheckInItem setCompany(String company) {
        this.company = company;
        return this;
    }

    public VisBatchCheckInItem setPhotoPath(String photoPath) {
        this.photoPath = photoPath;
        return this;
    }

    public VisBatchCheckInItem setVisitReason(String visitReason) {
        this.visitReason = visitReason;
        return this;
    }

    public VisBatchCheckInItem setVisitDateView(Date visitDateView) {
        this.visitDateView = visitDateView;
        return this;
    }

    public VisBatchCheckInItem setCarPlate(String carPlate) {
        this.carPlate = carPlate;
        return this;
    }

    public VisBatchCheckInItem setEnterPlace(String enterPlace) {
        this.enterPlace = enterPlace;
        return this;
    }

    public VisBatchCheckInItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public VisBatchCheckInItem setVisitedLikeName(String visitedLikeName) {
        this.visitedLikeName = visitedLikeName;
        return this;
    }

    public VisBatchCheckInItem setNotInAuditStatus(String notInAuditStatus) {
        this.notInAuditStatus = notInAuditStatus;
        return this;
    }

    public VisBatchCheckInItem setIsVisited(String isVisited) {
        this.isVisited = isVisited;
        return this;
    }

    public VisBatchCheckInItem setLevelIds(String levelIds) {
        this.levelIds = levelIds;
        return this;
    }

    public VisBatchCheckInItem setValidStartTime(String validStartTime) {
        this.validStartTime = validStartTime;
        return this;
    }

    public VisBatchCheckInItem setValidEndTime(String validEndTime) {
        this.validEndTime = validEndTime;
        return this;
    }

    public VisBatchCheckInItem setDefaultFloorIds(String defaultFloorIds) {
        this.defaultFloorIds = defaultFloorIds;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getVisitorName() {
        return this.visitorName;
    }

    public String getVisitorLastName() {
        return this.visitorLastName;
    }

    public String getCertType() {
        return this.certType;
    }

    public String getCertNumber() {
        return this.certNumber;
    }

    public String getVisitEmpPin() {
        return this.visitEmpPin;
    }

    public String getVisitEmpName() {
        return this.visitEmpName;
    }

    public String getVisitEmpLastName() {
        return this.visitEmpLastName;
    }

    public String getVisitEmpDeptName() {
        return this.visitEmpDeptName;
    }

    public String getVisitEmpDeptCode() {
        return this.visitEmpDeptCode;
    }

    public String getPhone() {
        return this.phone;
    }

    public String getEmail() {
        return this.email;
    }

    public String getCompany() {
        return this.company;
    }

    public String getPhotoPath() {
        return this.photoPath;
    }

    public String getVisitReason() {
        return this.visitReason;
    }

    public Date getVisitDateView() {
        return this.visitDateView;
    }

    public String getCarPlate() {
        return this.carPlate;
    }

    public String getEnterPlace() {
        return this.enterPlace;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getVisitedLikeName() {
        return this.visitedLikeName;
    }

    public String getNotInAuditStatus() {
        return this.notInAuditStatus;
    }

    public String getIsVisited() {
        return this.isVisited;
    }

    public String getLevelIds() {
        return this.levelIds;
    }

    public String getValidStartTime() {
        return this.validStartTime;
    }

    public String getValidEndTime() {
        return this.validEndTime;
    }

    public String getDefaultFloorIds() {
        return this.defaultFloorIds;
    }
}

