/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.io.Serializable;

@From(after="PERS_PERSON t LEFT join AUTH_DEPARTMENT d on t.auth_dept_id = d.id")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=false, idField="id", winHeight=400, winWidth=600)
public class VisAlertTemplatePersonSelectItem
extends BaseItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID", equalTag="=")
    @GridColumn(checkbox=true, width="40", sortNo=0)
    private String id;
    @Column(name="t.PIN")
    @GridColumn(label="vis_record_visitedPin", width="80")
    private String persPin;
    @Column(name="t.NAME")
    @GridColumn(label="vis_record_visitedName", width="100")
    private String persName;
    @Column(name="t.LAST_NAME")
    @GridColumn(label="vis_record_visitedLastName", width="100", showExpression="#language!='zh_CN'")
    private String persLastName;
    @Column(name="d.NAME")
    @GridColumn(label="pers_dept_deptName", width="123", sort="na")
    private String deptName;
    @Column(name="t.EMAIL", encryptConverter=true)
    @GridColumn(label="pers_person_email", width="123", sort="na")
    private String email;
    @Column(name="MOBILE_PHONE", encryptConverter=true)
    @GridColumn(label="pers_person_mobilePhone", width="100")
    private String mobilePhone;
    private String type;
    @Condition(value="t.ID", equalTag="not in")
    private String selectId;
    @Condition(value="(LOWER (t.NAME) LIKE LOWER (''%{0}%'') OR LOWER (t.LAST_NAME) LIKE LOWER (''%{0}%''))")
    private String likeName;
    @Condition(value="t.AUTH_DEPT_ID IN (SELECT ud.AUTH_DEPT_ID FROM AUTH_USER_DEPT ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String userId;
    @Column(name="t.PERSON_TYPE")
    private Short personType;
    @Condition(value="t.ID", equalTag="not in")
    private String notInId;
    @Column(name="t.ENABLED_CREDENTIAL")
    private Boolean enabledCredential;

    public String getId() {
        return this.id;
    }

    public String getPersPin() {
        return this.persPin;
    }

    public String getPersName() {
        return this.persName;
    }

    public String getPersLastName() {
        return this.persLastName;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public String getEmail() {
        return this.email;
    }

    public String getMobilePhone() {
        return this.mobilePhone;
    }

    public String getType() {
        return this.type;
    }

    public String getSelectId() {
        return this.selectId;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getUserId() {
        return this.userId;
    }

    public Short getPersonType() {
        return this.personType;
    }

    public String getNotInId() {
        return this.notInId;
    }

    public Boolean getEnabledCredential() {
        return this.enabledCredential;
    }

    public VisAlertTemplatePersonSelectItem setId(String id) {
        this.id = id;
        return this;
    }

    public VisAlertTemplatePersonSelectItem setPersPin(String persPin) {
        this.persPin = persPin;
        return this;
    }

    public VisAlertTemplatePersonSelectItem setPersName(String persName) {
        this.persName = persName;
        return this;
    }

    public VisAlertTemplatePersonSelectItem setPersLastName(String persLastName) {
        this.persLastName = persLastName;
        return this;
    }

    public VisAlertTemplatePersonSelectItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public VisAlertTemplatePersonSelectItem setEmail(String email) {
        this.email = email;
        return this;
    }

    public VisAlertTemplatePersonSelectItem setMobilePhone(String mobilePhone) {
        this.mobilePhone = mobilePhone;
        return this;
    }

    public VisAlertTemplatePersonSelectItem setType(String type) {
        this.type = type;
        return this;
    }

    public VisAlertTemplatePersonSelectItem setSelectId(String selectId) {
        this.selectId = selectId;
        return this;
    }

    public VisAlertTemplatePersonSelectItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public VisAlertTemplatePersonSelectItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public VisAlertTemplatePersonSelectItem setPersonType(Short personType) {
        this.personType = personType;
        return this;
    }

    public VisAlertTemplatePersonSelectItem setNotInId(String notInId) {
        this.notInId = notInId;
        return this;
    }

    public VisAlertTemplatePersonSelectItem setEnabledCredential(Boolean enabledCredential) {
        this.enabledCredential = enabledCredential;
        return this;
    }

    public String toString() {
        return "VisAlertTemplatePersonSelectItem(id=" + this.getId() + ", persPin=" + this.getPersPin() + ", persName=" + this.getPersName() + ", persLastName=" + this.getPersLastName() + ", deptName=" + this.getDeptName() + ", email=" + this.getEmail() + ", mobilePhone=" + this.getMobilePhone() + ", type=" + this.getType() + ", selectId=" + this.getSelectId() + ", likeName=" + this.getLikeName() + ", userId=" + this.getUserId() + ", personType=" + this.getPersonType() + ", notInId=" + this.getNotInId() + ", enabledCredential=" + this.getEnabledCredential() + ")";
    }
}

