/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.dashboard.controller;

import com.zkteco.zkbiosecurity.auth.controller.MainController;
import com.zkteco.zkbiosecurity.auth.service.AuthPermissionService;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.SpringContextUtil;
import com.zkteco.zkbiosecurity.dashboard.remote.DashboardRemote;
import com.zkteco.zkbiosecurity.dashboard.service.DashboardService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.messaging.handler.annotation.SendTo;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class DashboardController
extends BaseController
implements DashboardRemote {
    @Autowired
    private DashboardService dashboardService;
    @Autowired
    private MainController mainController;
    @Value(value="${system.dashboardPath:dashboardLightGreen}")
    private String dashboardUrl;
    @Autowired
    private AuthPermissionService authPermissionService;

    public ModelAndView dashboard() {
        ModelAndView modelAndView = this.mainController.home();
        if (this.authPermissionService.checkPermission(this.request.getRequestedSessionId(), "dashboard")) {
            return new ModelAndView("dashboard/" + this.dashboardUrl);
        }
        return modelAndView;
    }

    private String getDashboardPage(String module) {
        String ret = SpringContextUtil.getApplicationContext().getEnvironment().getProperty("system.dashboard." + module);
        return StringUtils.isNotBlank((CharSequence)ret) ? ret : String.valueOf(module) + "DashboardLightGreen";
    }

    public ModelAndView persDashboard() {
        return new ModelAndView("dashboard/" + this.getDashboardPage("pers"));
    }

    public ModelAndView accDashboard() {
        return new ModelAndView("dashboard/" + this.getDashboardPage("acc"));
    }

    public ModelAndView attDashboard() {
        return new ModelAndView("dashboard/" + this.getDashboardPage("att"));
    }

    public ModelAndView visDashboard() {
        return new ModelAndView("dashboard/" + this.getDashboardPage("vis"));
    }

    public ModelAndView parkDashboard() {
        return new ModelAndView("dashboard/" + this.getDashboardPage("park"));
    }

    public ModelAndView psgDashboard() {
        return new ModelAndView("dashboard/" + this.getDashboardPage("psg"));
    }

    public ModelAndView posDashboard() {
        return new ModelAndView("dashboard/" + this.getDashboardPage("pos"));
    }

    public ZKResultMsg getDashboardData(String modeles, String timeType) {
        String psgAreaName = this.request.getParameter("psgAreaName");
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getDashboardData(modeles, timeType, psgAreaName));
    }

    public ZKResultMsg getDashboardMonitoringData() {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getDashboardMonitoringData());
    }

    public ZKResultMsg getBaseBioData() {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getBaseBioData());
    }

    public ZKResultMsg getPersBioData() {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getPersBioData());
    }

    public ZKResultMsg getPersPersonTrends() {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getPersPersonTrends());
    }

    public ZKResultMsg getAccEventTrendsData(String timeType) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getAccEventTrendsData(timeType));
    }

    public ZKResultMsg getAccExceptionTopData() {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getAccExceptionTopData());
    }

    public ZKResultMsg getAccZoneData() {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getAccZoneData());
    }

    public ZKResultMsg getAccEventCount() {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getAccEventCount());
    }

    public ZKResultMsg getAccDeviceCount() {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getAccDeviceCount());
    }

    public ZKResultMsg getAttWorkaholicData(String timeType) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getAttWorkaholicData(timeType));
    }

    public ZKResultMsg getAttTodayCountData() {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getAttTodayCountData());
    }

    public ZKResultMsg getAttTodayData() {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getAttTodayData());
    }

    public ZKResultMsg getAttExceptionCountData() {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getAttExceptionCountData());
    }

    public ZKResultMsg getAttDeviceData() {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getAttDeviceData());
    }

    public ZKResultMsg getAttDeptAttendanceRateData(String timeType) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getAttDeptAttendanceRateData(timeType));
    }

    public ZKResultMsg getAttDeptAbsentRateChartData(String timeType) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getAttDeptAbsentRateChartData(timeType));
    }

    public ZKResultMsg getAttRecordTrendChartData() {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getAttRecordTrendChartData());
    }

    public ZKResultMsg getVisDayTripsData() {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getVisDayTripsData());
    }

    public ZKResultMsg getVisitorTrendsData() {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getVisitorTrendsData());
    }

    public ZKResultMsg getVisRegistPointFlowData() {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getVisRegistPointFlowData());
    }

    public ZKResultMsg getVisitedListData() {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getVisitedListData());
    }

    public ZKResultMsg getVisitorListData() {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getVisitorListData());
    }

    public ZKResultMsg getVisTodayVisitCount() {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getVisTodayVisitCount());
    }

    public ZKResultMsg getVisTodayVisitList() {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getVisTodayVisitList());
    }

    public ZKResultMsg getParkRevenueData(String timeType) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getParkRevenueData(timeType));
    }

    public ZKResultMsg getParkRecordinData() {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getParkRecordinData());
    }

    @MessageMapping(value={"/dashboardRTMonitor/getEventData"})
    @SendTo(value={"/topic/dashboardRTMonitor/getEventData"})
    public Object getEventData(String _params) {
        return null;
    }

    public ZKResultMsg getPsgEventTrendsData(String timeType) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getPsgEventTrendsData(timeType));
    }

    public ZKResultMsg getPsgExceptionTopData() {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getPsgExceptionTopData());
    }

    public ZKResultMsg getPsgEventAlarmData(String psgAreaName) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getPsgEventAlaramData(psgAreaName));
    }

    public ZKResultMsg getPsgDeviceCount() {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getPsgDeviceCount());
    }

    public ZKResultMsg getPsgEventCount() {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getPsgEventCount());
    }

    public ZKResultMsg getPsgPasserNumber() {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getPsgPasserNumber());
    }

    public ZKResultMsg getPosTodayData(String dataType) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getPosTodayData(dataType));
    }

    public ZKResultMsg getPosDeviceData() {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getPosDeviceData());
    }

    public ZKResultMsg getPosTrendChartData() {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getPosTrendChartData());
    }

    public ModelAndView posidDashboard() {
        return new ModelAndView("dashboard/" + this.getDashboardPage("posid"));
    }

    public ZKResultMsg getPosidDeviceData() {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getPosidDeviceData());
    }

    public ZKResultMsg getPosidTodayData(String dataType) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getPosidTodayData(dataType));
    }

    public ZKResultMsg getPosidTrendChartData() {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getPosidTrendChartData());
    }

    public ZKResultMsg getHepDashboardData(String type) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getHepDashboardData(type));
    }

    public ZKResultMsg getHepDashboardGridData(String status, String type) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getHepDashboardGridData(status, type));
    }

    public ZKResultMsg getHepDashboardGridPageData(String status, String type, Integer pageNo, Integer pageSize) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getHepDashboardGridPageData(status, type, pageNo.intValue(), pageSize.intValue()));
    }

    public ZKResultMsg getHepEventStaticData(String date) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getHepEventStaticData(date));
    }

    public ZKResultMsg savePersonalShowMenuCodes(String userName, String codes) {
        this.dashboardService.savePersonalShowMenuCodes(userName, codes);
        return ZKResultMsg.successMsg();
    }

    public ZKResultMsg getPersonalShowMenuCodesByUserName(String userName) {
        ZKResultMsg res = ZKResultMsg.successMsg();
        res.setData((Object)this.dashboardService.getPersonalShowMenuCodes(userName));
        return res;
    }

    public ZKResultMsg getSysModuleMenus(String userId) {
        ZKResultMsg menus = this.dashboardService.getShortCutMenuByCurrentUser(this.request.getSession().getId());
        return menus;
    }

    public ModelAndView hepDashboard() {
        return new ModelAndView("dashboard/" + this.getDashboardPage("hep"));
    }

    @ResponseBody
    public ZKResultMsg getDashboardEvent() {
        ZKResultMsg resultMsg = this.dashboardService.getEventByCount(10);
        return resultMsg;
    }

    @ResponseBody
    public ZKResultMsg getDashboardMessage() {
        ZKResultMsg resultMsg = this.dashboardService.getMessageByCount(10);
        return resultMsg;
    }

    public ModelAndView gymDashboard() {
        return new ModelAndView("dashboard/" + this.getDashboardPage("gym"));
    }

    public ZKResultMsg getGymAMountTrendsData(String timeType) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getGymAmountTrendsData(timeType));
    }

    public ZKResultMsg getGymTotalCollections(String timeType) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getGymAmountCollected(timeType));
    }

    public ZKResultMsg getGymActiveMembers() {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getGymActiveMembers());
    }

    public ZKResultMsg getGymExpiringMembers() {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getGymExpiringMembers());
    }

    public ZKResultMsg getGymPeopleInside() {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getGymPeopleInside());
    }

    public ZKResultMsg getGymNewMembers() {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getGymNewMembers());
    }

    public ZKResultMsg getGymMembersCountBasedOnPlans() {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getGymMembersCountBasedOnPlans());
    }

    public ZKResultMsg getGymAmountBasedOnPlans(String timeType, String membership) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getGymAmountBasedOnMemberships(timeType, membership));
    }

    public ZKResultMsg getTotalAmountCollected(String timeType) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getGymTotalAmountCollected(timeType));
    }

    public ZKResultMsg sendFeedBackCountsToDashboard(String date) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.sendFeedBackCountsToDashboard(date));
    }

    public ZKResultMsg getNewMemeberYearAmountCollected(String timeType) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getNewMemeberYearAmountCollected(timeType));
    }

    public ZKResultMsg getNewMemeberDayAmountCollected(String timeType) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getNewMemeberDayAmountCollected(timeType));
    }

    public ZKResultMsg getPaymentHistory() {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getPaymentHistory());
    }
}

