/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.license.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.ClassUtil;
import com.zkteco.zkbiosecurity.core.utils.FileUtils;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.license.remote.BaseLicenseRemote;
import com.zkteco.zkbiosecurity.license.service.BaseLicenseService;
import com.zkteco.zkbiosecurity.license.vo.bean.LicCompany;
import com.zkteco.zkbiosecurity.license.vo.bean.SystemClientInfo;
import com.zkteco.zkbiosecurity.security.annotation.ValidSecurity;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class BaseLicenseController
extends BaseController
implements BaseLicenseRemote {
    private static final Logger logger = LoggerFactory.getLogger(BaseLicenseController.class);
    @Autowired
    private BaseLicenseService baseLicenseService;
    @Value(value="${system.language:zh_CN}")
    private String language;
    @Value(value="${cloud.server.register.url:}")
    private String cloudRegiterUrl;
    public static final String EMAIL_VALIDATE_CODE_SESSION_STR = "emailValiateCode";
    @Value(value="${system.software.environment:Windows7/8/10/11, Windows Server 2008/2012/2016/2019/2022, PostgreSQL, Oracle11g/12c/18c/19c/21c, SQL Server 2008/2012/2014/2016/2017/2019/2022}")
    private String softwareEnvironment;
    @Value(value="${system.software.resolution:1366*768}")
    private String softwareResolution;
    @Value(value="${system.software.browsers:Firefox115+/Chrome109+/Edge}")
    private String softwareBrowsers;
    @Value(value="${system.productCode:}")
    private String productCode;
    @Value(value="${system.privacy.agreement.url:https://policy.zkbiosecurity.com/policy/zkinfo}")
    private String privacyAgreementUrl;
    @Value(value="${system.user.agreement.url:https://policy.zkbiosecurity.com/policy/zkuserinfo}")
    private String userAgreementUrl;
    @Value(value="${system.user.dataPolicy.url:https://policy.zkbiosecurity.com/policy/zkdataPolicy}")
    private String dataPolicyUrl;
    @Value(value="${system.licenseAboutUrl:}")
    private String licenseAboutUrl;
    @Value(value="${system.zkcloud.enable:true}")
    private String zkcloudEnable;

    public ModelAndView getLicenseInfo() {
        Map map = this.baseLicenseService.getLicenseInfo();
        this.request.getServletContext().setAttribute("language", (Object)this.language);
        this.request.getServletContext().setAttribute("systemVersion", map.get("systemVersion"));
        this.request.setAttribute("curVersion", map.get("curVersion"));
        this.request.setAttribute("jarVersionMap", map.get("jarVersionMap"));
        this.request.setAttribute("packageBits", map.get("packageBits"));
        this.request.setAttribute("packageTime", map.get("packageTime"));
        this.request.setAttribute("licenseId", map.get("licenseId"));
        this.request.setAttribute("isShowlicenseInfoDev", (Object)map.containsKey("licenseInfoDev"));
        this.request.setAttribute("licenseInfoDev", map.get("licenseInfoDev"));
        this.request.setAttribute("licenseInfoListT", map.get("licenseInfoListT"));
        this.request.setAttribute("hasLicenseModule", map.get("hasLicenseModule"));
        this.request.setAttribute("hasLicenseId", map.get("hasLicenseId"));
        this.request.setAttribute("productName", map.get("productName"));
        this.request.setAttribute("curYear", map.get("curYear"));
        this.request.setAttribute("zkposCount", map.get("zkposCount"));
        this.request.setAttribute("zkposVersion", map.get("zkposVersion"));
        this.request.setAttribute("zktimeCount", map.get("zktimeCount"));
        this.request.setAttribute("zktimeVersion", map.get("zktimeVersion"));
        this.request.setAttribute("count", map.get("count"));
        this.request.setAttribute("zkecoVersion", map.get("zkecoVersion"));
        this.request.setAttribute("ecoIntegate", map.get("ecoIntegate"));
        this.request.setAttribute("appId", (Object)this.baseLicenseService.getAppId());
        this.request.getSession().setAttribute("isLicenseTest", map.get("isLicenseTest"));
        this.request.setAttribute("cloudRegiterUrl", (Object)this.cloudRegiterUrl);
        this.request.setAttribute("zkcloudEnable", (Object)this.zkcloudEnable);
        this.licenseInfoForLogin();
        this.softwareEnvironment();
        if (StringUtils.isNotBlank((CharSequence)this.licenseAboutUrl)) {
            return new ModelAndView(this.licenseAboutUrl);
        }
        return new ModelAndView("system/license/authLicense");
    }

    private void softwareEnvironment() {
        String[] softwareEnvironments;
        ArrayList<String> list = new ArrayList<String>();
        for (String en : softwareEnvironments = this.softwareEnvironment.split(",")) {
            list.add(" " + en);
        }
        this.request.getSession().setAttribute("softwareEnvironment", (Object)StringUtils.join(list, (String)","));
        this.request.getSession().setAttribute("softwareResolution", (Object)this.softwareResolution);
        this.request.getSession().setAttribute("softwareBrowsers", (Object)this.softwareBrowsers);
    }

    public ModelAndView getLicenseDetails() {
        Map map = this.baseLicenseService.getLicenseDetails();
        this.request.setAttribute("licenseDetailList", map.get("licenseDetailList"));
        return new ModelAndView("system/license/authLicenseDetails");
    }

    public ZKResultMsg getCountries() {
        String continentCode = this.request.getParameter("continent");
        String countryCode = this.request.getParameter("country");
        List countries = this.baseLicenseService.getCountries(continentCode, countryCode);
        return new ZKResultMsg((Object)countries);
    }

    public ZKResultMsg sendEmailValidateCode() {
        String email = this.request.getParameter("email");
        String code = this.baseLicenseService.sendEmailValidateCode(email);
        this.request.getSession().setAttribute(EMAIL_VALIDATE_CODE_SESSION_STR, (Object)code);
        ZKResultMsg retMsg = new ZKResultMsg();
        retMsg.setMsg(code);
        return retMsg;
    }

    public ZKResultMsg validateValidateCode() {
        String rCode;
        ZKResultMsg retMsg = new ZKResultMsg();
        String code = this.request.getParameter("validateCode");
        boolean flag = this.baseLicenseService.validateValidateCode(code, rCode = (String)this.request.getSession().getAttribute(EMAIL_VALIDATE_CODE_SESSION_STR));
        if (flag) {
            return retMsg;
        }
        retMsg.setRet("fail");
        return retMsg;
    }

    public ModelAndView registPage(@RequestParam String activeType) {
        Map map = this.baseLicenseService.registPage();
        this.request.setAttribute("continents", map.get("continents"));
        this.request.setAttribute("countries", map.get("countries"));
        this.request.setAttribute("industries", map.get("industries"));
        this.request.setAttribute("company", map.get("company"));
        this.request.setAttribute("language", (Object)this.language);
        this.request.getSession().setAttribute("isLocal", (Object)("zh_CN".equals(this.language) ? 1 : 0));
        this.licenseInfoForLogin();
        if ("online".equals(activeType)) {
            return new ModelAndView("system/license/authLicenseReg");
        }
        return new ModelAndView("system/license/authLicenseRegOff");
    }

    public ModelAndView activeOffline() {
        return new ModelAndView("system/license/authLicenseActiveOff");
    }

    @LogRequest(module="auth_license_info", object="auth_license_info", opType="auth_license_activation", requestParams={"activeType"}, opContent="auth_license_activation")
    public ZKResultMsg doRegiest(@RequestParam(value="upload") MultipartFile upload, @RequestParam String activeType, LicCompany company) throws Exception {
        boolean online = "online".equals(activeType);
        String ret = "";
        if (upload != null) {
            ret = this.baseLicenseService.doRegiest(upload.getInputStream(), activeType, JSONObject.toJSONString((Object)company));
        }
        this.licenseInfoForLogin();
        FileUtils.saveMultipartFile((String)(ClassUtil.getRootPath() + "/license/temp"), (String)upload.getOriginalFilename(), (MultipartFile)upload);
        return new ZKResultMsg((Object)ret);
    }

    public ZKResultMsg uploadLicenseFile(@RequestParam(value="upload") MultipartFile upload) throws Exception {
        if (upload == null) {
            throw new ZKBusinessException("LicenseError:E0008");
        }
        String ret = this.baseLicenseService.uploadLicenseFile(upload.getInputStream());
        ZKResultMsg msg = new ZKResultMsg();
        msg.setMsg(ret);
        return msg;
    }

    public String downloadUpkFile() {
        String agent = this.request.getHeader("User-Agent");
        String fileNamePrefix = this.baseLicenseService.downloadUpkFile(agent);
        InputStream in = null;
        OutputStream out = null;
        try {
            this.response.setHeader("content-disposition", String.format("attachment;filename=\"%s_lic_upk.xml\"", fileNamePrefix));
            File file = new File(ClassUtil.getRootPath() + "/license/licdl.xml");
            in = new FileInputStream(file);
            int len = 0;
            byte[] buffer = new byte[1024];
            out = this.response.getOutputStream();
            while ((len = in.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                    out.close();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return null;
    }

    public ZKResultMsg licenseFileExists() {
        this.baseLicenseService.licenseFileExists();
        return new ZKResultMsg();
    }

    @ValidSecurity(onlyLogin=true)
    @LogRequest(module="auth_license_info", object="auth_license_info", opType="auth_license_exportFile", opContent="auth_license_exportFile")
    public void exportLicenseFile() throws Exception {
        ServletOutputStream out = null;
        String agent = this.request.getHeader("User-Agent");
        String fileNamePrefix = this.baseLicenseService.exportLicenseFile(agent);
        this.response.setHeader("content-disposition", String.format("attachment;filename=%s-License.xml", fileNamePrefix));
        out = this.response.getOutputStream();
        this.baseLicenseService.exportLicenseFile((OutputStream)out, false);
    }

    @ValidSecurity(onlyLogin=true)
    @LogRequest(module="auth_license_info", object="auth_license_info", opType="auth_license_importFile", opContent="auth_license_importFile")
    public ZKResultMsg importLicenseFile(@RequestParam(value="upload") MultipartFile upload) throws Exception {
        if (upload == null) {
            throw new ZKBusinessException("LicenseError:E0008");
        }
        String ret = this.baseLicenseService.importLicenseFile(upload.getInputStream(), upload.getOriginalFilename());
        this.licenseInfoForLogin();
        FileUtils.saveMultipartFile((String)(ClassUtil.getRootPath() + "/license/temp"), (String)upload.getOriginalFilename(), (MultipartFile)upload);
        return new ZKResultMsg((Object)ret);
    }

    @LogRequest(module="auth_license_info", object="auth_license_info", opType="auth_logout", opContent="auth_logout")
    public ZKResultMsg cancelLicense() {
        String ret = this.baseLicenseService.cancelLicense();
        this.licenseInfoForLogin();
        this.request.getServletContext().setAttribute("companyName", (Object)"");
        return new ZKResultMsg((Object)ret);
    }

    public ModelAndView importLicensePage() {
        return new ModelAndView("system/license/authLicenseImport");
    }

    @LogRequest(module="auth_license_info", object="auth_license_info", opType="auth_license_update", opContent="auth_license_update")
    public ZKResultMsg updateServerLicense() {
        String ret = this.baseLicenseService.updateServerLicense();
        this.licenseInfoForLogin();
        return new ZKResultMsg((Object)ret);
    }

    public ZKResultMsg registerCloudService(SystemClientInfo systemClientInfo) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.baseLicenseService.registerCloudService(systemClientInfo));
    }

    public ZKResultMsg licenseInfoForLogin() {
        Map map = this.baseLicenseService.licenseInfoForLogin();
        this.request.getSession().setAttribute("language", (Object)this.language);
        this.request.getSession().setAttribute("companyName", map.get("companyName"));
        this.request.getSession().setAttribute("LICENSE_OVER_LIMIT", map.get("LICENSE_OVER_LIMIT"));
        this.request.getSession().setAttribute("systemModules", map.get("systemModules"));
        this.request.getSession().setAttribute("currentYear", (Object)Calendar.getInstance().get(1));
        JSONObject jsonObject = (JSONObject)JSONObject.toJSON((Object)map);
        return new ZKResultMsg((Object)jsonObject);
    }

    public ZKResultMsg getAppId() {
        return new ZKResultMsg((Object)this.baseLicenseService.getAppId());
    }

    public ModelAndView getLicenseCompany() {
        this.request.setAttribute("item", (Object)this.baseLicenseService.getLicenseCompany());
        return new ModelAndView("system/license/registCompany");
    }

    public ModelAndView toCloudActivatePage() {
        this.request.setAttribute("privacyAgreementUrl", (Object)this.privacyAgreementUrl);
        this.request.setAttribute("userAgreementUrl", (Object)this.userAgreementUrl);
        this.request.setAttribute("dataPolicyUrl", (Object)this.dataPolicyUrl);
        return new ModelAndView("system/license/cloudActivate");
    }

    @LogRequest(module="auth_license_cloud", object="auth_license_cloud", opType="auth_license_cloud_activeType2", requestParams={"appId"}, opContent="auth_license_cloud_activeType2")
    public ZKResultMsg cloudActivateByAppIdAndKey(String appId, String appKey) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.baseLicenseService.cloudActivate(appId, appKey));
    }

    public ZKResultMsg testLicenseServer() {
        return this.baseLicenseService.testLicenseServer() ? ZKResultMsg.successMsg() : ZKResultMsg.failMsg();
    }

    public ModelAndView connectError() {
        return new ModelAndView("system/license/authLicenseConnectError");
    }

    public ModelAndView importCloudLicensePage() {
        this.request.setAttribute("privacyAgreementUrl", (Object)this.privacyAgreementUrl);
        this.request.setAttribute("userAgreementUrl", (Object)this.userAgreementUrl);
        this.request.setAttribute("dataPolicyUrl", (Object)this.dataPolicyUrl);
        return new ModelAndView("system/license/authCloudLicenseImport");
    }

    @LogRequest(module="auth_license_cloud", object="auth_license_cloud", opType="auth_license_cloud_importFile", opContent="auth_license_cloud_importFile")
    public ZKResultMsg importCloudLicenseFile(@RequestParam(value="upload") MultipartFile upload) {
        if (upload == null) {
            throw new ZKBusinessException("${auth_license_fileNoFound}");
        }
        try {
            ZKResultMsg ret = this.baseLicenseService.importCloudLicenseFile(upload.getInputStream(), upload.getOriginalFilename());
            return I18nUtil.i18nMsg((ZKResultMsg)ret);
        }
        catch (IOException e) {
            throw new ZKBusinessException("${auth_license_fileIncorrectFormat}");
        }
    }

    @LogRequest(module="auth_license_cloud", object="auth_license_cloud", opType="auth_license_cloud_cancel", opContent="auth_license_cloud_cancel")
    public ZKResultMsg cancelCloudLicense() {
        return I18nUtil.i18nMsg((ZKResultMsg)this.baseLicenseService.cancelCloudLicense());
    }

    public ZKResultMsg cloudLicenseFileExists() {
        if (StringUtils.isNotBlank((CharSequence)this.baseLicenseService.getAppId())) {
            return ZKResultMsg.successMsg();
        }
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.getFailMsg((String)"auth_license_cloud_noLicense"));
    }

    @LogRequest(module="auth_license_cloud", object="auth_license_cloud", opType="auth_license_cloud_exportFile", opContent="auth_license_cloud_exportFile")
    public void exportCloudLicenseFile() throws Exception {
        ServletOutputStream out = null;
        String agent = this.request.getHeader("User-Agent");
        String fileNamePrefix = "cloud-" + System.currentTimeMillis();
        this.response.setHeader("content-disposition", String.format("attachment;filename=%s-License.lic", fileNamePrefix));
        out = this.response.getOutputStream();
        this.baseLicenseService.exportCloudLicenseFile((OutputStream)out);
    }

    @LogRequest(module="auth_license_cloud", object="auth_license_cloud", opType="auth_license_cloud_updateLicense", opContent="auth_license_cloud_updateLicense")
    public ZKResultMsg updateCloudInfo() {
        return I18nUtil.i18nMsg((ZKResultMsg)this.baseLicenseService.updateCloudInfo());
    }

    @LogRequest(module="auth_license_info", object="auth_license_info", opType="auth_license_reset", requestParams={"resetType"}, opContent="auth_license_reset")
    public void resetLicense(String resetType) throws Exception {
        boolean online = "online".equals(resetType);
        ServletOutputStream out = null;
        String agent = this.request.getHeader("User-Agent");
        String fileNamePrefix = this.baseLicenseService.exportLicenseFile(agent);
        out = this.response.getOutputStream();
        if (online) {
            this.response.setHeader("content-disposition", String.format("attachment;filename=%s-SN.xml", fileNamePrefix));
        } else {
            this.response.setHeader("content-disposition", String.format("attachment;filename=%s-BackActi.xml", fileNamePrefix));
        }
        try {
            this.baseLicenseService.unbindLicense((OutputStream)out, online);
        }
        catch (Exception e) {
            this.response.setHeader("Content-Disposition", "");
            throw new ZKBusinessException(e.getMessage());
        }
    }
}

