/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ins.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.FileEncryptUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.ImgEncodeUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.ins.remote.InsTransactionRemote;
import com.zkteco.zkbiosecurity.ins.service.InsParamsService;
import com.zkteco.zkbiosecurity.ins.service.InsTransactionService;
import com.zkteco.zkbiosecurity.ins.vo.InsTransactionItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.io.IOException;
import java.util.Base64;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class InsTransactionController
extends ExportController
implements InsTransactionRemote {
    @Autowired
    private InsTransactionService insTransactionService;
    @Autowired
    private InsParamsService insParamsService;

    @RequiresPermissions(value={"ins:transaction"})
    public ModelAndView index() {
        return new ModelAndView("ins/transaction/insTransaction");
    }

    @RequiresPermissions(value={"ins:transaction:refresh"})
    public DxGrid list(InsTransactionItem condition) {
        Pager pager = this.insTransactionService.loadPagerByAuthUserFilter(this.request.getSession().getId(), (BaseItem)condition, this.getPageNo(), this.getPageSize(), this.getLimitCount());
        return GridUtil.convert((Pager)pager, condition.getClass(), (boolean)this.getPageList());
    }

    @RequiresPermissions(value={"ins:transaction:export"})
    @LogRequest(module="ins_module", object="ins_transaction_manager", opType="common_op_export", requestParams={"exportType"}, opContent="common_report_fileType")
    public void export(HttpServletRequest request, HttpServletResponse response) {
        InsTransactionItem insTransactionItem = new InsTransactionItem();
        this.setConditionValue((BaseItem)insTransactionItem);
        List intemList = this.insTransactionService.getItemData(request.getSession().getId(), InsTransactionItem.class, insTransactionItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(intemList, InsTransactionItem.class);
    }

    public ZKResultMsg getPhoto(String pin, String sn, String attDate) {
        ZKResultMsg res = new ZKResultMsg();
        String photoDate = attDate.replaceAll("-", "").replaceAll(" ", "").replaceAll(":", "");
        String photoName = photoDate + "-" + pin + ".jpg";
        String src = "/upload/ins/transactionPhoto/" + sn + '/' + attDate.split(" ")[0] + '/' + photoName;
        res.setData((Object)src);
        return res;
    }

    public void getDecryptFileBase64(String path) {
        if (StringUtils.isNotBlank((CharSequence)path)) {
            String decryptFileBase64 = FileEncryptUtil.getDecryptFileBase64((String)path);
            if (this.insParamsService.verifyPhotoEncryptProp()) {
                decryptFileBase64 = ImgEncodeUtil.base64BoxBlurFilter((String)decryptFileBase64);
            }
            try {
                ServletOutputStream outputStream = this.response.getOutputStream();
                this.response.reset();
                outputStream.write(Base64.getDecoder().decode(decryptFileBase64));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

