/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ins.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ins.remote.InsAreaPersonRemote;
import com.zkteco.zkbiosecurity.ins.service.InsAreaPersonService;
import com.zkteco.zkbiosecurity.ins.service.InsPersonService;
import com.zkteco.zkbiosecurity.ins.vo.InsAreaPersonItem;
import com.zkteco.zkbiosecurity.ins.vo.InsAreaSelectAreaItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class InsAreaPersonController
extends BaseController
implements InsAreaPersonRemote {
    @Autowired
    private InsAreaPersonService insAreaPersonService;
    @Autowired
    private InsPersonService insPersonService;

    @RequiresPermissions(value={"ins:areaPerson"})
    public ModelAndView index() {
        return new ModelAndView("ins/areaPerson/insAreaPerson");
    }

    @RequiresPermissions(value={"ins:areaPerson:edit"})
    @LogRequest(module="ins_module", object="ins_op_forZoneAddPers", opType="common_op_new", requestParams={"areaId"}, opContent="ins_areaPerson_areaId")
    public ZKResultMsg save() {
        String personIds = this.request.getParameter("ids");
        String areaId = this.request.getParameter("areaId");
        ZKResultMsg res = this.insAreaPersonService.addPerson(personIds, areaId, "-1");
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"ins:areaPerson:refresh"})
    public DxGrid list(InsAreaPersonItem condition) {
        Pager pager = this.insAreaPersonService.loadPagerByAuthUserFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"ins:areaPerson:del"})
    @LogRequest(module="ins_module", object="common_setByArea", opType="pers_common_delPerson", requestParams={"areaName", "personPins"}, opContent="pers_person_pin")
    public ZKResultMsg delete(String ids) {
        this.insAreaPersonService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"ins:areaPerson:delArea"})
    @LogRequest(module="ins_module", object="common_setByPerson", opType="base_area_delArea", requestParams={"personPin", "areaNames"}, opContent="base_area_name")
    public ZKResultMsg delArea(String ids) {
        this.insAreaPersonService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @LogRequest(module="ins_module", object="common_setByArea", opType="common_dev_syncPersonInArea", requestParams={"name"}, opContent="base_area_name")
    @RequiresPermissions(value={"ins:areaPerson:syncPerToDev"})
    public ZKResultMsg syncPerToDev(String areaId, String ids) {
        ZKResultMsg res = this.insAreaPersonService.syncPerToDev(areaId, ids);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"ins:areaPerson:addPerson"})
    @LogRequest(module="ins_module", object="ins_op_forZoneAddPers", opType="common_op_new", requestParams={"personPins"}, opContent="pers_person_pin")
    public ZKResultMsg addPerson() {
        String personIds = this.request.getParameter("personIds");
        String areaId = this.request.getParameter("authAreaId");
        ZKResultMsg res = this.insAreaPersonService.addPerson(personIds, areaId, "-1");
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public DxGrid insAreaSelectArea(InsAreaSelectAreaItem condition) {
        Pager pager = new Pager();
        if (condition.getType().equals("noSelected")) {
            pager = this.insPersonService.getNoExistArea(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        } else if (condition.getType().equals("selected")) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }
}

